"""
    DemoSciDXPQt.py

    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
"""
import qt
import sys
from PyDVT.GraphView import *
from PyDVT.DataSelection import XYOrthoLineSelection
from PyDVT.SciDXPData import SciDXPData



#Creating SciDXP Data structure
import ReadSpecFile
sci_data = ReadSpecFile.ReadSpecFileGroupNode('scisoft.dat',start_scan=69, end_scan=70)


#Connecting to a PyDVT Data object ,printing available keys,and loading two pages
dvt_data=SciDXPData()
dvt_data.SetSource(sci_data)
print dvt_data.GetSourceInfo()["KeyList"]
key1=('filename', 'scan70', 'Detector')
key2=('filename', 'scan70', 'Monitor')
key3=('filename', 'scan70', 'Epoch')

#We can load everything with this:
#dvt_data.LoadSource()
#Or just some keys:
dvt_data.LoadSource([key1,key2,key3])


#Usual drawing stuff...
root = qt.QApplication(sys.argv)
view = GraphView(None,{"AddLockPosition":1,"AddOnLine":1,"AddRefresh":1,"AddCursorSelect":1,\
                       "AddStyleSelect":1,"ScrollMode":"ON","AddStatus":1,"AutoHideStatus":1,})
view.SetLabels("DemoSciDXP","(x)","(y)")
view.SetStyle("PointsLine")
graph1=GraphFilter(  "Graph1",\
                     OrthoLineSelection(dvt_data,page={"Key":key1}),\
                     pen=Pen((255,0,0),0,"solid") \
                     )
graph2=GraphFilter(  "Graph2",\
                     OrthoLineSelection(dvt_data,page={"Key":key2}),\
                     pen=Pen((0,0,255),0,"solid"),\
                     xdata=Numeric.arrayrange(41)*2,
                     yscale=1, \
                     )
#Getting X and Y arrays from data
graph3=GraphFilter(  "Graph3",\
                     XYOrthoLineSelection(dvt_data,\
                                          page={"Key":key1},\
                                          xpage={"Key":key3}),\
                     pen=Pen((0,255,0),0,"solid"),\
                     )

view.SetSource((graph1,graph2))


view.resize(500,500)
view.show()
root.setMainWidget(view)
root.exec_loop()

