"""
    DemoQwtBinding.py
    How to use QwtBinding: Qwt for 1d plotting instead of plplot.

    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
"""

import sys

import qt
import PyDVT
PyDVT.SetBinding("QwtBinding")
from PyDVT.GraphView import *
                                            
    

def save():
    view.Save("out.bmp","BMP")


if "qt" in sys.modules.keys():
    root = qt.QApplication(sys.argv)      
    view = GraphView(None,{"AddStyleSelect":1,"AddCursorSelect":1,"AddStatus":1,"AutoHideStatus":1})
else:
    root = Tkinter.Tk()
    view = GraphView(root,{"AddStyleSelect":1,"AddCursorSelect":1,"AddStatus":1,"AutoHideStatus":1})

view.EnableLegend(1,"bottom")

arr1 = Numeric.zeros ((500,))
arr2 = Numeric.zeros ((500,))
arr3 = Numeric.zeros ((500,),'float')
for i in range(500):
    arr1[i]= 500.*Numeric.cos(i/10.)
    arr2[i]= i*(1.1)*Numeric.sin(i/10.)
    arr3[i]= 0.01/(i+1)

view.SetSource((Graph(arr1,pen=Pen((0,0,255),1,"solid"),name="function1 (y1)"),Graph(arr2,pen=Pen((0,255,0),1,"solid"),name="function2 (y1)"),Graph(arr3,yscale=1,pen=Pen((255,0,0),1,"solid"),name="function3 (y2)")))

view.AddMenuSeparator()
view.AddMenuPopupItem("Save (out.bmp)",save)
view.SetLabels("Demo QwtBinding","(x)","(y)","(y2)")
view.SetSize(500,500)
view.Show()    

root.setMainWidget(view)
root.exec_loop()

