from PyDisWindow import *
from PyDVT.View import View

__version__=  '1.0.0'
__author__ =  'Alexandre Gobbo (gobbo@esrf.fr)'



class DemoPyDisPlugin(Plugin):
    ########################################################
    ### Virtuals
    ########################################################
    def OnStartInit (self):
        return 1

    def OnInitMenuBar (self,menu_bar):
        self.menu_plugin = qt.QPopupMenu(menu_bar)
        self.menu_plugin.insertItem('Plugin Info',self.PluginInfo)
        menu_bar.insertItem('&DemoPlugin',self.menu_plugin)

    def OnFinishInit (self,app_window):
        self.app_window=app_window
        

    def OnInitWindowPopupMenu (self,window):
        window.View.AddMenuSeparator()
        window.View.AddMenuPopupItem("View Doc",Command.Command(self.ViewDoc,window))

    def OnFileOpen (self,filename,format_string):
        window=ViewWindow (self.app_window.mdi,TextView)        
        window.show()
        window.SetTitle(os.path.split(filename)[1])
        window.View.SetSource(qt.QString(filename))

    def OnFileSave (self,window,filename,format_string):
        window.View.Save(filename)
        window.SetTitle(os.path.split(filename)[1])
        window.View.SetSource(qt.QString(filename))        

    def OnFilePrint(self,window):
        if window.View.__class__ is TextView:
            self.app_window.statusBar().message("I'm pretending to print...",4000)
            return 1
        return 0

    def GetOpenFormatList(self):
        return ["Text files (*.txt)"]

    def GetSaveFormatList(self,window):
        if window.View.__class__ is TextView: return ["Text files (*.txt)"]
        else: return []
        
    def GetInfoString(self):
        return "v"+__version__

    ########################################################
    ### Private methods
    ########################################################
    def PluginInfo(self):
        new_window=ViewWindow (self.app_window.mdi,TextView)        
        new_window.show()
        new_window.SetTitle("Plugin Info")
        str="Demo PyDis Plugin \nFile: "+__file__
        new_window.View.SetSource(str)

    def ViewDoc(self,window):
        new_window=ViewWindow (self.app_window.mdi,TextView,master_window=window)        
        new_window.show()
        new_window.SetTitle(None,prefix="Doc - ")
        new_window.View.SetSource(str(window.View.__doc__))


class TextView(View):
    def CreateDrawable(self):
        self.Drawable= qt.QTextBrowser(self)
        self.Drawable.show()
    def SetSource(self,source):
        import types
        if type(source)is types.StringType: self.Drawable.setText(source)
        else: self.Drawable.setSource(source)
        self.Refresh()
    def Save(self,filename):
        open(filename,"w+").write(str(self.Drawable.text()))


plugin=DemoPyDisPlugin()