"""
    DemoMCAQt.py
    Specfile MCA plotting simple demo application
 
    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
    
"""


import qt
import sys
import Command

import PyDVT.GraphView as GraphView
import PyDVT.SpecFileData as SpecFileData
import PyDVT.DataSelection as DataSelection
from PyDVT.Binding import Pen

try:
    filename=sys.argv[1]
    mcaname=sys.argv[2]
                    
    app = qt.QApplication(sys.argv)  
    view = GraphView.GraphView(None)            
    data=SpecFileData.SpecFileData()
    data.SetSource(filename)
    data.LoadSource(mcaname)
    view.SetSource(GraphView.GraphFilter(None,DataSelection.OrthoLineSelection(data),pen = Pen((0,0,255),0,"solid")))
    app.setMainWidget(view)
    view.resize(500,500)
    view.SetLabels("MCA " + mcaname)
    view.Show()
    app.exec_loop()
    
except:
    import traceback
    traceback.print_exc()
    print "Usage: DemoMCAQt <filename> <MCA key>"




