"""
    DemoImageFileQt.py
    Demo application - displaying of JPG/PNG/BMP/GIF images 
 
    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
    
"""


import qt
import sys
import PyDVT.ImageView as ImageView
import PyDVT.ImageFileData as ImageFileData
import PyDVT.DataSelection as DataSelection

try:
    filename=sys.argv[1]                    
    root = qt.QApplication(sys.argv)  
    data=ImageFileData.ImageFileData()
    view = ImageView.ImageView(None)
    view.SetSource(ImageView.ImageFilter(None,DataSelection.RectSelection(data)))
    view.resize(500,500)
    view.Show()
    root.setMainWidget(view)
    data.SetSource(filename)
    data.LoadSource()
    root.exec_loop()

except:
    import traceback
    traceback.print_exc()
    print "Usage: DemoImageFileQt <filename>"


