"""
    DemoHistogramQt.py


    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
"""


import sys
import qt
import Numeric

import PyDVT.GraphView as GraphView
import PyDVT.GraphViewSelect as GraphViewSelect
from PyDVT.Filter import Filter
from PyDVT.Data import Data
from PyDVT.DataSelection import OrthoLineSelection

root = qt.QApplication(sys.argv)      
view = GraphView.GraphView(None,{"AddStyleSelect":1})


arr1 = Numeric.zeros ((500,))
for i in range(100):arr1[i]= 1
for i in range(50):arr1[100+i]= 2
for i in range(20):arr1[200+i]= 3
for i in range(10):arr1[300+i]= 4
for i in range(6):arr1[400+i]= 5


hist=GraphView.Hist(arr1,pen=GraphView.Pen((0,255,255),0,"solid"))
hist.SetDivisions(100)
view.SetStyle("Bars")
view.SetSource(hist)
view.SetLabels("Demo Histogram","value","counts")

view.resize(500,500)
view.Show()    
root.setMainWidget(view)
root.exec_loop()
    