"""
    DemoExtendedGraphView.py

    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
"""


import sys
if len (sys.argv)>1 and sys.argv[1]=="Tk":
    import Tkinter
else:
    import qt
from PyDVT.ExtendedGraphView import *


def delGraph():
	global view
	graphToDel=view.GetActiveGraph()
	if graphToDel is not None:
		view.DelGraph(graphToDel['name'])

#--- menu popup callbacks relative to rois ---

def addRoi():
	global view
	if view.Select is not None:
		((xmin,y0),(xmax,y1))=view.Select.Selection["BoundingRect"]
		view.Select.Erase(view)
		view.PutRoi(name='roi',limits=[(xmin,xmax)],pen=Pen((198,154,236),2,"solid"),brush=Brush((198,154,236),"fill_25"))

def delRoi():
	global view
	roiToDel=view.GetActiveRoi()
	if roiToDel is not None:
		view.DelRoi(roiToDel.name)
	
def showRoiLabels():
	global view
	view.ShowRoisNames()

def hideRoiLabels():
	global view
	view.HideRoisNames()

#--- menu popup callbacks relative to rois ---
	
def addPeak():
	global view
	if view.Select is not None:
		((pos,y0),(pos,y1))=view.Select.Selection["BoundingRect"]
		view.PutPeak(name='pk',pos=pos,pen=Pen((0,0,0),2,"solid"))
	
def delPeak():
	global view
	pkToDel=view.GetActivePeak()
	if pkToDel is not None:
		view.DelPeak(pkToDel.name)
	
def showPeakLabels():
	global view
	view.ShowPeaksNames()

def hidePeakLabels():
	global view
	view.HidePeaksNames()

def enableActiveGraphHighlight():
	global view
	view.SetActiveGraphPen((255,0,0),2,'dotted')
	
def disableActiveGraphHighlight():
	global view
	view.SetActiveGraphPen(None)
	

import math
NB_POINTS=500
global view
if "qt" in sys.modules.keys():
    root = qt.QApplication(sys.argv)	  
    view = ExtendedGraphView(None)
else:
    root = Tkinter.Tk()
    view = ExtendedGraphView(root,{'StatusBar':1,'RoiSelection':1,'PeakSelection':1})

# create test command in menu popup
view.AddMenuSeparator()
view.AddMenuPopupItem("Del graph",delGraph)
if view.opts['RoiSelection']==1:
    view.AddMenuSeparator()
    view.AddMenuPopupItem("Add roi",addRoi)
    view.AddMenuPopupItem("Del roi",delRoi)
    view.AddMenuPopupItem("Show roi labels",showRoiLabels)
    view.AddMenuPopupItem("Hide roi labels",hideRoiLabels)
if view.opts['PeakSelection']==1:
    view.AddMenuSeparator()
    view.AddMenuPopupItem("Add peak",addPeak)
    view.AddMenuPopupItem("Del peak",delPeak)
    view.AddMenuPopupItem("Show peaks label",showPeakLabels)
    view.AddMenuPopupItem("Hide peaks label",hidePeakLabels)
view.AddMenuSeparator()
view.AddMenuPopupItem("enable active graph highlight",enableActiveGraphHighlight)
view.AddMenuPopupItem("disable active graph highlight",disableActiveGraphHighlight)

# create graph datas to display
arr1 = Numeric.zeros ((NB_POINTS,))
arr2 = Numeric.zeros ((NB_POINTS,))
for i in range(NB_POINTS):
    arr1[i]= i
    arr2[i]= (i/2)*math.sin(math.sqrt(i))
graphData1=Graph(arr1,pen=Pen((0,0,255),3,"solid"))
graphData2=Graph(arr2,pen=Pen((0,0,255),3,"solid"))
view.SetSource((graphData1,graphData2))
view.SetSize(500,500)
view.Show()

if "qt" in sys.modules.keys():
    root.setMainWidget(view)
    root.exec_loop()
else:
    root.mainloop()
