"""
    DemoCompTk.py
    Sample application - compares two images 

    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
"""


from Tkinter import *
from PyDVT.ImageView import *
from PyDVT.DataSelection import *
from PyDVT.ImageViewSelect import *
from PyDVT.ColormapSelect import *
from PyDVT.EdfFileData import *
from PyDVT.SPSData import *





class MyView(ImageView):
    def EventPosition(self,source):
        global LabelPos
        pos=source.GetSelection()["Position"]
        value=self.GetDataPositionValue(pos.DataCoord)                
        if value is None: str=""
        else: str="x:%07.3f   y:%07.3f   z:%07.3f" % (pos.DataCoord.PageCoord[0],pos.DataCoord.PageCoord[1],value)
        LabelPos.SetText(str)            
        

    def ShowColormapDlg(self):
        if self.GetColormapFilter() is None: return
        if hasattr(self,"ColormapDlg")==0 or self.ColormapDlg==None or self.ColormapDlg.IsDestroyed():
            image_par=self.GetColormapFilter().GetColormapParameters()
            self.ColormapDlg=ColormapDialog(root,image_par)
            self.GetColormapFilter().ConnectColormap(self.ColormapDlg.Colormap)

def EventSelection(source):
    sel=source.GetDataSelection()
    ZoomImg1.SetZoom(rect=(sel.Position[0], sel.Position[1], sel.Position[0]+sel.Size[0], sel.Position[1]+sel.Size[1]))
    ZoomImg2.SetZoom(rect=(sel.Position[0], sel.Position[1], sel.Position[0]+sel.Size[0], sel.Position[1]+sel.Size[1]))          

        
def GetSourceString(page):
    global Data
    ret= Data.GetItemPageInfo("SourceName",page) + " - "
    if type(Data.GetItemPageInfo("Key",page)) is types.StringType:
        ret = ret + Data.GetItemPageInfo("Key",page)
    else:
        ret = ret + ("%d" % (Data.GetItemPageInfo("Key",page)))
    return ret

try:
    mode=sys.argv[1]
    filename=sys.argv[2]

    root = Tk()

    if mode == "EDF":
        Data = EdfFileData()
        index1=int(sys.argv[3])
        index2=int(sys.argv[4])
    elif mode == "SPS":
        Data = SPSData(refresh_interval=100)
        index1=sys.argv[3]
        index2=sys.argv[4]


    ColormapDlg1=ColormapDlg2=None

    Img1=ColormapFilter(None,MultiPageRectSelection(Data,page=0))
    Img2=ColormapFilter(None,MultiPageRectSelection(Data,page=1))

    FullImg1 = MyView(root,{"ZoomMode":"FIT_TO_SCREEN","ScrollMode":"OFF"},relief=SUNKEN,borderwidth=2)
    FullImg1.SetSource(Img1)
    FullImg1.AddMenuPopupItem("Colormap",FullImg1.ShowColormapDlg)

    FullImg2 = MyView(root,{"ZoomMode":"FIT_TO_SCREEN","ScrollMode":"OFF"},relief=SUNKEN,borderwidth=2)
    FullImg2.SetSource(Img2)
    FullImg2.AddMenuPopupItem("Colormap",FullImg2.ShowColormapDlg)

    ZoomImg1 = MyView(root,{"ZoomMode":"OFF","ScrollMode":"OFF"},relief=SUNKEN,borderwidth=2)
    ZoomImg1.SetSource(Img1)
    ZoomImg1.AddMenuPopupItem("Colormap",ZoomImg1.ShowColormapDlg)
    ZoomImg1.LockPosition(1)

    ZoomImg2 = MyView(root,{"ZoomMode":"OFF","ScrollMode":"OFF"},relief=SUNKEN,borderwidth=2)
    ZoomImg2.SetSource(Img2)
    ZoomImg2.AddMenuPopupItem("Colormap",ZoomImg2.ShowColormapDlg)
    ZoomImg2.LockPosition(1)


    ZoomSelect=ImageViewSelectRect(Data,EventSelection)
    ZoomSelect.ConnectView(FullImg1)
    ZoomSelect.ConnectView(FullImg2)

    LabelPos = Label(root)
    LabelImg1 = Label(root)
    LabelImg2 = Label(root)

    LabelImg1.grid(row=0,col=0,sticky=NSEW)
    LabelImg2.grid(row=0,col=1,sticky=NSEW)
    FullImg1.grid(row=1,col=0,sticky=NSEW)
    FullImg2.grid(row=1,col=1,sticky=NSEW)
    ZoomImg1.grid(row=2,col=0,sticky=NSEW)
    ZoomImg2.grid(row=2,col=1,sticky=NSEW)
    LabelPos.grid(row=3,col=0,columnspan=2,sticky=NSEW)
    root.title("DemoComp")
    root.update()

    Data.SetSource(filename)
    Data.LoadSource((index1,index2))
    LabelImg1.config(text= GetSourceString(0))
    LabelImg2.config(text= GetSourceString(1))
    root.mainloop()

except:
    import traceback
    traceback.print_exc()
    print "Usage: DemoCompTk <Mode: SPS or EDF> <Source> <Key1> <Key2>"
