###########################################################
#
# CVS Id:       $Id: corba.py,v 1.1 2002/06/19 15:02:44 svensson Exp $
#
# File:         corba.py
#
# Package:      scisoft/python/scidxp
#
# Author:       Olof Svensson (May 2002)
#
# Description:  This module contains CORBA wrapper and
#               server classes
#
# Change log, most recent first:
#
# Update 19/06/2002 O Svensson (svensson@esrf.fr)
#                   Committed file to CVS repository
#
#

import scidxp.corba_stub
import scidxp__POA
from scidxp.util import *
from omniORB import CORBA, PortableServer
from CosNaming import *
import Numeric, copy
import math, time


####################################################################
#
# Corba events
#
#
#class CorbaEvent(scidxp__POA.corba.stub.CorbaEvent, ScidxpEvent):
#
#  def __init__(self, node, change, param):
#    ScidxpEvent.__init__(node, change, param)
#
#
#class CorbaArrayEvent(scidxp__POA.corba.stub.CorbaArrayEvent, CorbaEvent, ArrayEvent):
#  pass
#
#class CorbaNodeEvent(scidxp__POA.corba.stub.CorbaNodeEvent, CorbaEvent, NodeEvent):
#  pass
#scidxp_corba_stub_idl.py
#
####################################################################
#
# Scidxp to Corba Event wrappers
#

class CorbaToArrayEventWrapper(ArrayEvent):

  def __init__(self, corbaArrayEvent):
    ArrayEvent.__init__(self, None, \
                                corbaArrayEvent.getChange(), \
                                None)
    self._corbaArrayEvent = corbaArrayEvent
    

class ArrayEventToCorbaWrapper(scidxp__POA.corba.stub.CorbaArrayEvent):

  def __init__(self, arrayEvent):
    self._arrayEvent = arrayEvent

  def getChange(self):
    return self._arrayEvent.getChange()

  def getParam(self):
    return None


class CorbaToNodeEventWrapper(NodeEvent):

  def __init__(self, corbaNodeEvent):
    NodeEvent.__init__(self, None, \
                                corbaNodeEvent.getChange(), \
                                None)
    self._corbaNodeEvent = corbaNodeEvent
    

class NodeEventToCorbaWrapper(scidxp__POA.corba.stub.CorbaNodeEvent):

  def __init__(self, nodeEvent):
    self._nodeEvent = nodeEvent

  def getChange(self):
    return self._nodeEvent.getChange()

  def getParam(self):
    return None


class CorbaToArrayEventListenerWrapper:

  def __init__(self, corbaArrayEventListener):
    self._corbaArrayEventListener = corbaArrayEventListener

  def typeChanged(self, arrayEvent):
    self._corbaArrayEventListener.typeChanged(ArrayEventToCorbaWrapper(arrayEvent)._this())
    
  def shapeChanged(self, arrayEvent):
    self._corbaArrayEventListener.shapeChanged(ArrayEventCorbaToWrapper(arrayEvent)._this())
    
  def dataChanged(self, arrayEvent):
    self._corbaArrayEventListener.dataChanged(ArrayEventToCorbaWrapper(arrayEvent)._this())
    
  def arrayChanged(self, arrayEvent):
    self._corbaArrayEventListener.arrayChanged(ArrayEventToCorbaWrapper(arrayEvent)._this())
    

class ArrayEventListenerToCorbaWrapper(scidxp__POA.corba.stub.CorbaArrayEventListener):

  def __init__(self, arrayChangeListener):
    self._arrayChangeListener = arrayChangeListener

  def typeChanged(self, arrayEvent):
    self._arrayChangeListener.typeChanged(ArrayEventToCorbaWrapper(arrayEvent))
    
  def shapeChanged(self, arrayEvent):
    self._arrayChangeListener.shapeChanged(ArrayEventToCorbaWrapper(arrayEvent))
    
  def dataChanged(self, arrayEvent):
    self._arrayChangeListener.dataChanged(ArrayEventToCorbaWrapper(arrayEvent))
    
  def arrayChanged(self, arrayEvent):
    self._arrayChangeListener.arrayChanged(ArrayEventToCorbaWrapper(arrayEvent))


class CorbaToNodeEventListenerWrapper:

  def __init__(self, corbaNodeChangeListener):
    self._corbaNodeChangeListener = corbaNodeChangeListener

  def nameChanged(self, corbaNodeEvent):
    self._corbaNodeChangeListener.nameChanged(CorbaToNodeEventWrapper(corbaNodeEvent))
    
  def attributeChanged(self, corbaNodeEvent):
    self._corbaNodeChangeListener.attributeChanged(CorbaToNodeEventWrapper(corbaNodeEvent))
    
  def childChanged(self, corbaNodeEvent):
    self._corbaNodeChangeListener.childChanged(CorbaToNodeEventWrapper(corbaNodeEvent))
    
  def arrayChanged(self, corbaNodeEvent):
    self._corbaNodeChangeListener.arrayChanged(CorbaToNodeEventWrapper(corbaNodeEvent))
    
  def structureChanged(self, corbaNodeEvent):
    self._corbaNodeChangeListener.structureChanged(CorbaToNodeEventWrapper(corbaNodeEvent))
    
  def nodeDisposed(self, corbaNodeEvent):
    self._corbaNodeChangeListener.nodeDisposed(CorbaToNodeEventWrapper(corbaNodeEvent))
    


class NodeEventListenerToCorbaWrapper(scidxp__POA.corba.stub.CorbaNodeEventListener):

  def __init__(self, nodeEventListener):
    self._nodeEventListener = nodeEventListener

  def nameChanged(self, nodeEvent):
    self._nodeEventListener.nameChanged(NodeEventToCorbaWrapper(nodeEvent))
    
  def attributeChanged(self, nodeEvent):
    self._nodeEventListener.attributeChanged(NodeEventToCorbaWrapper(nodeEvent))
    
  def childChanged(self, nodeEvent):
    self._nodeEventListener.childChanged(NodeEventToCorbaWrapper(nodeEvent))
    
  def arrayChanged(self, nodeEvent):
    self._nodeEventListener.arrayChanged(NodeEventToCorbaWrapper(nodeEvent))
    
  def structureChanged(self, nodeEvent):
    self._nodeEventListener.structureChanged(NodeEventToCorbaWrapper(nodeEvent))
    
  def nodeDisposed(self, nodeEvent):
    self._nodeEventListener.nodeDisposed(NodeEventToCorbaWrapper(nodeEvent))
    

####################################################################
#
# Scidxp to Corba wrappers
#

class ArrayToCorbaWrapper(scidxp__POA.corba.stub.CorbaArray, Array):

  _corbaArrayReferences = {}

  def __init__(self, array):
    self._array   = array
    self._typeCode  = self.dataTypeToCorbaTypeCode(self._array.getDataType())
    self._reference = "%f"%(time.time())
    ArrayToCorbaWrapper._corbaArrayReferences[self._reference] = array

#  def registerArray(self, array):
    

  def getReference(self):
    return self._reference
  
  def getRank(self):
    return self._array.getRank()

  def getExtends(self):
    return self._array.getExtends()

  def getExtend(self, dim):
    return self._array.getExtend(dim)

  def getDataCount(self):
    return self._array.getDataCount()

  def getDataType(self):
    return self._array.getDataType()

  def numpyToAny(self, numpy_data, data_type=None):
    if data_type is None:
      typeCode = self.dataTypeToCorbaTypeCode(self._array.getDataType())
    else:
      typeCode = self.dataTypeToCorbaTypeCode(data_type)
    any = CORBA.Any(typeCode, Numeric.ravel(numpy_data).tolist())
    return any

  def getData(self):
    #print "DEBUG: In getData...", self._array.getDataCount()
    data = self._array.getData()
    #print "DEBUG: In getData... 2"
    return self.numpyToAny(data)

  def getDataAsType(self, type):
    data = self._array.getData(type)
    return self.numpyToAny(data, type)

  def getDataSlab(self, first, last):
    data = self._array.getDataSlab(first, last)
    return self.numpyToAny(data)

  def getDataSlabAsType(self, first, last, type):
    data = self._array.getDataSlab(first, last)
    return self.numpyToAny(data, type)

  def dataTypeToCorbaTypeCode(self, dataType):
    if dataType == 1: # scidxp.corba.stub.CorbaArray.CHR
      typeCode = CORBA.TypeCode("IDL:scidxp/corba/stub/short_sequence:1.0")
    elif dataType == 2: # scidxp.corba.stub.CorbaArray.INT8
      typeCode = CORBA.TypeCode("IDL:scidxp/corba/stub/short_sequence:1.0")
    elif dataType == 3: # scidxp.corba.stub.CorbaArray.INT16
      typeCode = CORBA.TypeCode("IDL:scidxp/corba/stub/short_sequence:1.0")
    elif dataType == 4: # scidxp.corba.stub.CorbaArray.INT32
      typeCode = CORBA.TypeCode("IDL:scidxp/corba/stub/long_sequence:1.0")
    elif dataType == 5: # scidxp.corba.stub.CorbaArray.INT64
      typeCode = CORBA.TypeCode("IDL:scidxp/corba/stub/long_long_sequence:1.0")
    elif dataType == 6: # scidxp.corba.stub.CorbaArray.FLOAT32
      typeCode = CORBA.TypeCode("IDL:scidxp/corba/stub/float_sequence:1.0")
    elif dataType == 7: # scidxp.corba.stub.CorbaArray.FLOAT64
      typeCode = CORBA.TypeCode("IDL:scidxp/corba/stub/double_sequence:1.0")
    else:
      raise "ArrayToCorbaWrapper.dataTypeToCorbaTypeCode: Unknown data type: ", dataType
    return typeCode

  def addArrayEventListener(self, corbaArrayEventListener):
    self._array._arrayChangeSupport.addArrayEventListener( \
      CorbaToArrayEventListenerWrapper(corbaArrayEventListener))

  def removeArrayEventListener(self, corbaArrayEventListener):
    for eventListener in self._array._arrayChangeSupport._arrayChangeListeners:
      if type(eventListener) == type(CorbaToArrayEventListenerWrapper(None)):
        if eventListener._corbaArrayEventListener == corbaArrayEventListener:
          self._array._arrayChangeSupport.removeArrayEventListener(eventListener)

  def fireArrayEvent(self, corbaArrayEvent):
    self._array._arrayChangeSupport.fireArrayEvent(CorbaToArrayEventWrapper(corbaArrayEvent))



class CorbaUtils:

  def numpyToAny(self, data):
    array = Numeric.array((data))
    dataType = self.numpyToDataType(array.typecode())
    if dataType == 1:
      array = Numeric.array(map(ord, data))
    typeCode = self.dataTypeToCorbaTypeCode(dataType)
    any = CORBA.Any(typeCode, Numeric.ravel(array).tolist())
    return (any, dataType)

  def numpyToDataType(self, numpyType):
    if (numpyType) == "c":
      dataType = Array.CHAR
    elif (numpyType) == "1":
      dataType = Array.INT8
    elif (numpyType) == "s":
      dataType = Array.INT16
    elif (numpyType) =="i":
      dataType = Array.INT32
    elif (numpyType) =="l":
      dataType = Array.INT64
    elif (numpyType) == "f":
      dataType = Array.FLOAT32
    elif (numpyType) == "d":
      dataType = Array.FLOAT64
    else:
      raise "DefaultDataType.numpyToDataType: Not supported data type: "+numpyType
    return dataType

  def dataTypeToCorbaTypeCode(self, dataType):
    if dataType == 1: # scidxp.corba.stub.CorbaArray.CHR
      typeCode = CORBA.TypeCode("IDL:scidxp/corba/stub/short_sequence:1.0")
    elif dataType == 2: # scidxp.corba.stub.CorbaArray.INT8
      typeCode = CORBA.TypeCode("IDL:scidxp/corba/stub/short_sequence:1.0")
    elif dataType == 3: # scidxp.corba.stub.CorbaArray.INT16
      typeCode = CORBA.TypeCode("IDL:scidxp/corba/stub/short_sequence:1.0")
    elif dataType == 4: # scidxp.corba.stub.CorbaArray.INT32
      typeCode = CORBA.TypeCode("IDL:scidxp/corba/stub/long_sequence:1.0")
    elif dataType == 5: # scidxp.corba.stub.CorbaArray.INT64
      typeCode = CORBA.TypeCode("IDL:scidxp/corba/stub/long_long_sequence:1.0")
    elif dataType == 6: # scidxp.corba.stub.CorbaArray.FLOAT32
      typeCode = CORBA.TypeCode("IDL:scidxp/corba/stub/float_sequence:1.0")
    elif dataType == 7: # scidxp.corba.stub.CorbaArray.FLOAT64
      typeCode = CORBA.TypeCode("IDL:scidxp/corba/stub/double_sequence:1.0")
    else:
      raise "ArrayToCorbaWrapper.dataTypeToCorbaTypeCode: Unknown data type: ", dataType
    return typeCode


  def createCorbaArray(self, data, shape, factory):
    any, dataType = self.numpyToAny(Numeric.array(data))
    return factory.createCorbaArray(any, dataType, shape)


class ScaleToCorbaWrapper(scidxp__POA.corba.stub.CorbaScale, ArrayToCorbaWrapper):

  def __init__(self, scale):
    ArrayToCorbaWrapper.__init__(self, scale)
    self._name = scale.getName

  def getName(self):
    return self._name


class AttributeToCorbaWrapper(scidxp__POA.corba.stub.CorbaAttribute, ArrayToCorbaWrapper):

  def __init__(self, name, array):
    ArrayToCorbaWrapper.__init__(self, array)
    self._name = name

  def getName(self):
    return self._name


class NodeToCorbaWrapper(scidxp__POA.corba.stub.CorbaNode):

  _nodeReferences = {}

  def __init__(self, node):
    self._node          = node
    self._reference = "%f"%(time.time())
    NodeToCorbaWrapper._nodeReferences[self._reference] = self._node
    
  def getReference(self):
    return self._reference

  def setParentNode(self, corbaParentNode):
    self._node.setParentNode(CorbaToNodeConverter(corbaParentnode))   

  def getParentNode(self):
    parent = self._node.getParentNode()
    if parent is not None:
      return GroupNodeToCorbaWrapper(parent)._this()
    else:
      return None

  def setName(self, name):
    self._node.setName(name)

  def getName(self):
    return self._node.getName()

  def getAttributes(self):
    #print "DEBUG: scidxp_corba in getAttributes", self._node.getAttributes()
    attributes_list = self._node.getAttributes()
    corba_attributes_list = []
    for attribute_name in attributes_list.keys():
      corba_attribute = AttributeToCorbaWrapper(attribute_name, attributes_list[attribute_name])
      corba_attributes_list.append(corba_attribute._this())
    return corba_attributes_list

  def getAttribute(self, name):
    return ArrayToCorbaWrapper(self._node.getAttribute(name))._this()

  def setAttribute(self, name, corbaArray):
    reference = corbaArray.getReference()
    #print "Reference: ", reference, [self._node]
    if reference in ArrayToCorbaWrapper._corbaArrayReferences.keys():
      #print "setAttribut: In references!"
      array = ArrayToCorbaWrapper._corbaArrayReferences[reference]
      #print [array.getData()]
    else:
      array = CorbaToArrayConverter(corbaArray)
#      ArrayToCorbaWrapper.registerArray(self, array)
    self._node.setAttribute(name, array)

  def addNodeEventListener(self, corbaNodeEventListener):
    self._node._nodeChangeSupport.addNodeEventListener( \
      CorbaToNodeEventListenerWrapper(corbaNodeEventListener))

  def removeNodeEventListener(self, corbaNodeEventListener):
    for eventListener in self._node._nodeChangeSupport._nodeChangeListeners:
      if type(eventListener) == type(CorbaToNodeEventListenerWrapper(None)):
        if eventListener._corbaNodeEventListener == corbaNodeEventListener:
          self._node._nodeChangeSupport.removeNodeEventListener(eventListener)

  def fireNodeEvent(self, corbaNodeEvent):
    self._node._arrayChangeSupport.fireNodeEvent( \
      CorbaToNodeEventWrapper(corbaNodeEvent))

  def isMutable(self):
    return self._node.isMutable()

  def isGroupNode(self):
    return self._node.isGroupNode()

  def isDataSetNode(self):
    return self._node.isDataSetNode()

  def getFactory(self):
    return DefaultCorbaFactory()._this()



class GroupNodeToCorbaWrapper(scidxp__POA.corba.stub.CorbaGroupNode, \
                              NodeToCorbaWrapper):

  def __init__(self, groupnode):
    NodeToCorbaWrapper.__init__(self, groupnode)
    self._groupnode = groupnode
    self._corbawrappernodes = {}

  def insertChild(self, corbaNode):
    #print "DEBUG: in insertChild:", [corbaNode]
    self._corbawrappernodes[corbaNode.getName()] = corbaNode
    reference = corbaNode.getReference()
    if reference in NodeToCorbaWrapper._nodeReferences.keys():
      self._groupnode.insertChild(NodeToCorbaWrapper._nodeReferences[reference])
    else:
      if corbaNode.isDataSetNode:
        self._groupnode.insertChild(CorbaToDataSetNodeConverter(corbaNode))
      elif corbaNode.isGroupNode:
        self._groupnode.insertChild(CorbaToGroupNodeConverter(corbaNode))
      else:
        print "ERROR! child ", corbaNode.getName(), " is neither DataSetNode nor GroupNode!"
        sys.exit(1)

  def removeChild(self, corbaNode):
    if corbanode.getParent() != self:
      return
    corbanode.setParent(None)
    del self._groupnode._nodes[corbaNode.getName()]
    del self._corbawrappernodes[corbaNode.getName()]


  def getChild(self, name):
    child = self._groupnode.getChild(name)
    #if not name in self._corbawrappernodes.keys():
    #  if self._corbawrappernodes[name].getReference() != child.getReference():
    if child.isDataSetNode():
      self._corbawrappernodes[name] = DataSetNodeToCorbaWrapper(child)._this()
    elif child.isGroupNode():
      self._corbawrappernodes[name] = GroupNodeToCorbaWrapper(child)._this()
    else:
      print "ERROR! child ", child.getName(), " is neither DataSetNode nor GroupNode!"
      sys.exit(1)
    node = self._corbawrappernodes[name]
    return node

  def getChildren(self):
    children = self._groupnode.getChildren()
    corba_children = []
    #print "DEBUG 23: ", self._corbawrappernodes.keys()
    for name in children.keys():
      #if not name in self._corbawrappernodes.keys():
      child = self._groupnode.getChild(name)
      #print [child]
      if child.isDataSetNode():
        self._corbawrappernodes[name] = DataSetNodeToCorbaWrapper(child)._this()
      elif child.isGroupNode():
        self._corbawrappernodes[name] = GroupNodeToCorbaWrapper(child)._this()
      else:
        raise "ERROR: Illegal child "+child.getName()
      corba_children.append(self._corbawrappernodes[name])
    return corba_children




class DataSetNodeToCorbaWrapper(scidxp__POA.corba.stub.CorbaDataSetNode, \
                                NodeToCorbaWrapper):

  def __init__(self, arraynode):
    NodeToCorbaWrapper.__init__(self, arraynode)
    self._arraynode = arraynode
    self._corbaArray = None

  def setData(self, corbaArray, scales):
    reference = corbaArray.getReference()
    #print "Reference: ", reference
    if reference in ArrayToCorbaWrapper._corbaArrayReferences.keys():
      #print "In references!"
      array = ArrayToCorbaWrapper._corbaArrayReferences[reference]
    else:
      array = CorbaToArrayConverter(corbaArray)
#      ArrayToCorbaWrapper.registerArray(self, array)
    self._corbaArray = corbaArray
    self._arraynode.setData(array, None)

  def getData(self):
    if self._corbaArray is None:
      #print "getData: creating wrapper..."
      self._corbaArray = ArrayToCorbaWrapper(self._arraynode.getData())._this()
    #print "getData: ", [self._corbaArray]
    return self._corbaArray

  def getScales(self):
    return None

  def getScale(self, dim):
    return None

  def isDataSetNode(self):
    #print "DEBUG: in isDataSetNode(self)"
    return CORBA.TRUE


####################################################################################
#
#  Converter from CORBA to Default scidxp components
#


class CorbaToArrayConverter(DefaultArray):

  def __init__(self, corbaArray):
    self._extnds    = corbaArray.getExtends()
    self._rank      = corbaArray.getRank()
    self._dataCount = corbaArray.getDataCount()
    self._dataType  = corbaArray.getDataType()
    self._typeCode  = self.dataTypeToCorbaTypeCode(self._dataType)
    any = corbaArray.getData()
    array = any.value()
    self._data      = Numeric.array((array))
    self._arrayChangeSupport = ArrayChangeSupport(self)
    self._corbaArray = corbaArray

  def dataTypeToCorbaTypeCode(self, dataType):
    if dataType == 1: # scidxp.corba.stub.CorbaArray.CHR
      typeCode = CORBA.TypeCode("IDL:scidxp/corba/stub/short_sequence:1.0")
    elif dataType == 2: # scidxp.corba.stub.CorbaArray.INT8
      typeCode = CORBA.TypeCode("IDL:scidxp/corba/stub/short_sequence:1.0")
    elif dataType == 3: # scidxp.corba.stub.CorbaArray.INT16
      typeCode = CORBA.TypeCode("IDL:scidxp/corba/stub/short_sequence:1.0")
    elif dataType == 4: # scidxp.corba.stub.CorbaArray.INT32
      typeCode = CORBA.TypeCode("IDL:scidxp/corba/stub/long_sequence:1.0")
    elif dataType == 5: # scidxp.corba.stub.CorbaArray.INT64
      typeCode = CORBA.TypeCode("IDL:scidxp/corba/stub/long_long_sequence:1.0")
    elif dataType == 6: # scidxp.corba.stub.CorbaArray.FLOAT32
      typeCode = CORBA.TypeCode("IDL:scidxp/corba/stub/float_sequence:1.0")
    elif dataType == 7: # scidxp.corba.stub.CorbaArray.FLOAT64
      typeCode = CORBA.TypeCode("IDL:scidxp/corba/stub/double_sequence:1.0")
    else:
      raise "ArrayToCorbaWrapper.dataTypeToCorbaTypeCode: Unknown data type: ", dataType
    return typeCode


class CorbaToAttributeConverter(CorbaToArrayConverter,DefaultAttribute):

  def __init__(self, corbaAttribute):
    CorbaToArrayConverter.__init__(self, corbaAttribute)
    self._name = corbaAttribute.getName()


class CorbaToScaleConverter(CorbaToArrayConverter,DefaultScale):

  def __init__(self, corbaScale):
    CorbaToArrayConverter.__init__(self, corbaScale)
    self._name = corbaScale.getName()


class CorbaToNodeConverter(DefaultNode):
 
  def __init__(self, corbaNode):
    self._corbaNode = corbaNode
    self._mutable = corbaNode.isMutable()
    self._disposed = 0
    self._name = corbaNode.getName()
    self._parent = None
    self._attributes = {}
    corbaAttributes = corbaNode.getAttributes()
    for corbaAttribute in corbaAttributes:
      self._attributes[corbaAttribute.getName()] = CorbaToAttributeConverter(corbaAttribute)


class CorbaToGroupNodeConverter(CorbaToNodeConverter, DefaultGroupNode):

  def __init__(self, corbaGroupNode):
    CorbaToNodeConverter.__init__(self, corbaGroupNode)
    self._nodes = {}
    corbaNodes = corbaGroupNode.getNodes()
    for corbaNode in corbaNodes:
      nodeName = corbaNode.getName()
      if corbaNode.isDataSetNode():
        self._nodes[nodeName] = CorbaToDataSetNodeConverter(corbaNode)
      elif corbaNode.isGroupNode():
        self._nodes[nodeName] = CorbaToGroupNodeConverter(corbaNode)


class CorbaToDataSetNodeConverter(CorbaToNodeConverter, DefaultDataSetNode):

  def __init__(self, corbaDataSetNode):
    array = CorbaToArrayConverter(corbaDataSetNode.getData())
    DefaultDataSetNode.__init__(self, corbaDataSetNode.getName(), array)
    CorbaToNodeConverter.__init__(self, corbaDataSetNode)
    #self._scales = None


####################################################################################
#
#  Default CORBA Scidxp components for the CorbaFactory
#

class DefaultCorbaNodeEvent(NodeEventToCorbaWrapper):

  def __init__(self, action):
    NodeEventToCorbaWrapper.__init__(self, NodeEvent(action))

class DefaultCorbaArrayEvent(ArrayEventToCorbaWrapper):

  def __init__(self, action):
    ArrayEventToCorbaWrapper.__init__(self, ArrayEvent(action))


class DefaultCorbaArray(scidxp__POA.corba.stub.CorbaArray, \
                          ArrayToCorbaWrapper):

  def __init__(self, any_data, dataType, extends):
    self._array = DefaultArray(any_data.value(), dataType=dataType, extends=extends)
    self._reference = "%f"%(time.time())
    ArrayToCorbaWrapper._corbaArrayReferences[self._reference] = self._array
    #print self._reference

#    self._extnds    = extends
#    self._rank      = len(extends)
#    self._data      = Numeric.array((any_data.value()))
#    self._data.shape = extends
#    self._dataCount = 1
#    for i in self._extnds:
#      self._dataCount = self._dataCount*i
#    self._dataType  = dataType
#    self._typeCode  = self.dataTypeToCorbaTypeCode(self._dataType)


class DefaultCorbaAttribute(scidxp__POA.corba.stub.CorbaAttribute, \
                            DefaultCorbaArray,
                            DefaultAttribute):

  def __init__(self, name, corbaArray):
    self._name = name
    self._extnds    = corbaArray.getExtends()
    self._rank      = corbaArray.getRank()
    self._data      = corbaArray.getData().value()
    self._dataCount = corbaArray.getDataCount()
    self._dataType  = corbaArray.getDataType()
    self._typeCode  = self.dataTypeToCorbaTypeCode(self._dataType)

  def dataTypeToCorbaTypeCode(self, dataType):
    if dataType == 1: # scidxp.corba.stub.CorbaArray.CHR
      typeCode = CORBA.TypeCode("IDL:scidxp/corba/stub/short_sequence:1.0")
    elif dataType == 2: # scidxp.corba.stub.CorbaArray.INT8
      typeCode = CORBA.TypeCode("IDL:scidxp/corba/stub/short_sequence:1.0")
    elif dataType == 3: # scidxp.corba.stub.CorbaArray.INT16
      typeCode = CORBA.TypeCode("IDL:scidxp/corba/stub/short_sequence:1.0")
    elif dataType == 4: # scidxp.corba.stub.CorbaArray.INT32
      typeCode = CORBA.TypeCode("IDL:scidxp/corba/stub/long_sequence:1.0")
    elif dataType == 5: # scidxp.corba.stub.CorbaArray.INT64
      typeCode = CORBA.TypeCode("IDL:scidxp/corba/stub/long_long_sequence:1.0")
    elif dataType == 6: # scidxp.corba.stub.CorbaArray.FLOAT32
      typeCode = CORBA.TypeCode("IDL:scidxp/corba/stub/float_sequence:1.0")
    elif dataType == 7: # scidxp.corba.stub.CorbaArray.FLOAT64
      typeCode = CORBA.TypeCode("IDL:scidxp/corba/stub/double_sequence:1.0")
    else:
      raise "ArrayToCorbaWrapper.dataTypeToCorbaTypeCode: Unknown data type: ", dataType
    return typeCode


class DefaultCorbaScale(scidxp__POA.corba.stub.CorbaScale, \
                        DefaultCorbaArray):

  def __init__(self, name, corbaArray):
    self._name = name
    self._extnds    = corbaArray.getExtends()
    self._rank      = corbaArray.getRank()
    self._data      = corbaArray.getData().value()
    self._dataCount = corbaArray.getDataCount()
    self._dataType  = corbaArray.getDataType()
    self._typeCode  = self.dataTypeToCorbaTypeCode(self._dataType)


    
class DefaultCorbaDataSetNode(scidxp__POA.corba.stub.CorbaDataSetNode,
                              DataSetNodeToCorbaWrapper):

  def __init__(self, name, corbaArray):
    array = CorbaToArrayConverter(corbaArray)
    DataSetNodeToCorbaWrapper.__init__(self, DefaultDataSetNode(name, array))
    self._corbaArray = corbaArray


class DefaultCorbaGroupNode(scidxp__POA.corba.stub.CorbaGroupNode,
                            GroupNodeToCorbaWrapper):

  def __init__(self, name):                                    
    GroupNodeToCorbaWrapper.__init__(self, DefaultGroupNode(name))
    #self._name = name
    #self._parent = None
    #self._nodes = {}
    #self._attributes = {}
                                         


class DefaultCorbaFactory(scidxp__POA.corba.stub.CorbaScidxpFactory):

  def __init__(self):
    pass

  def __call__(self):
    return self

  def __del__(self):
    pass

  def createCorbaChangeNodeEvent(self, action):
    return DefaultCorbaChangeNodeEvent(action)._this()

  def createCorbaArrayEvent(self, action):
    return DefaultCorbaArrayEvent(action)._this()

  def createCorbaArray(self, any_data, dataType, extends):
    return DefaultCorbaArray(any_data, dataType, extends)._this()

  def createCorbaAttribute(self, name, corbaArray):
    return DefaultCorbaAttribute(name, corbaArray)._this()

  def createCorbaScale(self, name, corbaArray):
    return DefaultCorbaScale(name, corbaArray)._this()

  def createCorbaDataSetNode(self, name, corbaArray):
    return DefaultCorbaDataSetNode(name, corbaArray)._this()

  def createCorbaGroupNode(self, name):
    return DefaultCorbaGroupNode(name)._this()

#
# Python singleton:
#
DefaultCorbaFactory = DefaultCorbaFactory()


class DefaultCorbaServer(GroupNodeToCorbaWrapper):

  def __init__(self, groupNode):
    GroupNodeToCorbaWrapper.__init__(self, groupNode)
    #self._factory = self.getFactory()

  def run_server(self):
    #
    # Create the orb
    #
    orb = CORBA.ORB_init(["python", 
                          "-ORBInitialHost", "scisoft1.esrf.fr", 
                          "-ORBInitialPort", "19000",
                          "-ORBgiopMaxMsgSize", "100000000"], CORBA.ORB_ID)
    #
    # Find the root POA
    #
    poa = orb.resolve_initial_references("RootPOA")
    #    
    # Create an object reference, and implicitly activate the object
    #
    corbaObject = self._this()
    #
    # Obtain a reference to the root naming context
    #
    obj =         orb.resolve_initial_references("NameService")
    rootContext = obj._narrow(NamingContext)

    if rootContext is None:
      print "Failed to narrow the root naming context"
      sys.exit(1)
    #
    # Bind a context named "scidxp" to the root context
    #
    name = [NameComponent("scidxp","")]
    try:
      scidxpContext = rootContext.bind_new_context(name)
      print "scidxp context bound"

    except NamingContext.AlreadyBound:
      print "scidxp context already exists"
      obj = rootContext.resolve(name)
      scidxpContext = obj._narrow(NamingContext)
      if scidxpContext is None:
        print "scidxpContext exists but is not a NamingContext"
        sys.exit(1)
    #
    # Bind the server object to the scidxp context
    #
    name = [NameComponent(self.getName(), "")]
    try:
      scidxpContext.bind(name, corbaObject)
      print "New ",name," object bound"

    except NamingContext.AlreadyBound:
      scidxpContext.rebind(name, corbaObject)
      print "Test Server binding already existed --rebound"
    #    
    # Activate the POA
    #
    poaManager = poa._get_the_POAManager()
    poaManager.activate()
    #
    # Everything is running now, but if this thread drops out of the end
    # of the file, the process will exit. orb.run() just blocks until the
    # ORB is shut down
    #
    try:
      orb.run()
    except:
      print 'shutting down server'
      scidxpContext.unbind(name)






