"""
    DemoScanQt.py
    Demo application - graph displaying of a scan in spec - PyQt GUI
 
    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
"""    


import qt
import sys
from PyDVT.SPSData import SPSData
from PyDVT.ScanGraphView import ScanGraphView
from PyDVT.SPSScanGraphFilter import SPSScanGraphFilter
from PyDVT.DataSelection import XYOrthoLineSelection
from PyDVT.Binding import Pen



try:
    specname=sys.argv[1]
    arrayname=sys.argv[2]
    coly=int(sys.argv[3])
    colx=int(sys.argv[4])

    root = qt.QApplication(sys.argv)

    data=SPSData(refresh_interval=100)
    data.SetSource(specname)
    data.LoadSource(arrayname,col=coly)
    data.LoadSource(arrayname,col=colx,append=1)
    sel=XYOrthoLineSelection(data,page=0,xpage=1)
    view = ScanGraphView(None,{"AddLockPosition":1,"AddOnLine":1,"AddRefresh":1,"AddCursorSelect":1,"AddStyleSelect":1,"ScrollMode":"ON","AddStatus":1,"AutoHideStatus":1,})
    view.SetLabels("DemoScan","(x)","(y)")
    view.SetXAxis((0,200000))
    view.SetYAxis((0,200000))
    view.SetAutoRescale(1)
    view.SetSource(SPSScanGraphFilter("G1",sel,pen=Pen((255,0,0),0,"solid")))
    view.resize(500,500)
    view.Show()

    root.setMainWidget(view)
    root.exec_loop()

except:
    import traceback
    traceback.print_exc()
    print "Usage: DemoScanQt <Spec Name> <Array Name> <coly> <colx>"


