"""
    DemoSPSQt.py
    Demo application - image displaying of SPS Shared Array - PyQt GUI
 
    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
"""    


import qt
import sys
from PyDVT.SPSData import SPSData
from PyDVT.ExtendedImageView import ExtendedImageView,ColormapFilter
from PyDVT.DataSelection import RectSelection


try:
    root = qt.QApplication(sys.argv)

    data=SPSData(refresh_interval=50)
    view = ExtendedImageView(None,{"AddSelection":0, "AddLockPosition":1})        
    view.SetSource(ColormapFilter(None,RectSelection(data)))        
    data.SetSource(sys.argv[1])
    data.LoadSource(sys.argv[2])

    view.resize(500,500)
    view.Show()
    root.setMainWidget(view)
    root.exec_loop()

except:
    import traceback
    traceback.print_exc()
    print "Usage: DemoSPSQt <Spec Name> <Array Name>"


