"""
    DemoPolarQt.py
    Demo application - GraphView plotting using polar coordinates

    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
"""


import qt
import sys
import Numeric

from PyDVT.GraphView import Graph,PolarGraph,GraphView,Pen


root = qt.QApplication(sys.argv)      



dtr = Numeric.pi / 180.0
r = Numeric.sin((dtr*5.)*Numeric.arrayrange(361))
t=dtr*Numeric.arrayrange(361)

pi=Numeric.pi
r1=Numeric.array([0.8,0.8,0.8,0.8,0.8],Numeric.Float)
t1=Numeric.array([0,pi*0.5,pi,pi*1.5,pi*2],Numeric.Float)

view=GraphView(None,{"AddStyleSelect":1,"AddStatus":1,"AddLog":0})
view.SetPolarEnv(1)
view.resize(500,500)
view.Show()
view.SetLabels("DemoPolar")
view.SetSource((PolarGraph(r,t),PolarGraph(r1,t1,symbol="circles",pen=Pen((255,0,0),3,"dotted"))))
root.setMainWidget(view)

root.exec_loop()

