"""
    DemoFitTk.py
    Demo application - fitting a numeric array, setting initial parameters
 
    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
"""    


import Tkinter
import sys
import Numeric

from PyDVT.Data import Data
from PyDVT.GraphView import GraphView,GraphFilter
from PyDVT.DataSelection import OrthoLineSelection
from PyDVT.FitFilter import FitFilter
from PyDVT.Binding import Pen,FitParametersDialog


    
root = Tkinter.Tk()
data=Data()
arr = Numeric.ones ((200,),"f")
arr[100:110]=[3,5,8,10,20,17,15,13,8,2]
data.AppendPage({},arr)
FitDlg=None
sel=OrthoLineSelection(data)
fit_filter=FitFilter(sel)
pars={}
pars["WeightFlag"]=0
pars["Theory"]="Area Gaussians"
pars["Background"]="Linear"
pars["Mode"]="Normal"
pars["Sensitivity"]=3.25
pars["FwhmPoints"]=10
pars["Yscaling"]=1.0  
pars["AutoScaling"]=0
pars["AutoFwhm"]=0
fit_filter.SetParameters(pars)
FitDlg=FitParametersDialog(root,None)
FitDlg.Show()
fit_filter.ConnectParameterEditor(FitDlg)


view = GraphView(root,{"AddLockPosition":1,"AddOnLine":1,"AddRefresh":1,"AddCursorSelect":1,"AddStyleSelect":1,"ScrollMode":"ON","AddStatus":1,"AutoHideStatus":1,})
view.SetLabels("DemoFit","(x)","(y)")
view.SetStyle("PointsLine")
view.SetSource((GraphFilter("G1",sel,pen=Pen((255,0,0),1,"solid")),GraphFilter("G2",fit_filter,pen=Pen((0,255,0),1,"dotted"))))

view.SetSize(500,500)
view.Show()


root.mainloop()

