"""
    DemoFitSPSQt.py
    Demo application - fitting a SPS array giving initial parameters
 
    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
"""    


import qt
import sys
import Numeric

from PyDVT.SPSData import SPSData
from PyDVT.GraphView import GraphView,GraphFilter
from PyDVT.DataSelection import OrthoLineSelection
from PyDVT.FitFilter import FitFilter
from PyDVT.Binding import Pen,FitParametersDialog


def ShowFitParsDialog():
    global FitDlg,fit_filter
    if FitDlg==None or FitDlg.IsDestroyed():
        FitDlg=FitParametersDialog(None,None)
        FitDlg.Show()
        fit_filter.ConnectParameterEditor(FitDlg)
        fit_filter.Refresh()

try:
    specname=sys.argv[1]
    arrayname=sys.argv[2]
    
    root = qt.QApplication(sys.argv)
    data=SPSData(refresh_interval=100)
    data.SetSource(specname)
    data.LoadSource(arrayname)
    sel=OrthoLineSelection(data)
    FitDlg=None
    fit_filter=FitFilter(sel)
    pars={}
    pars["Theory"]="Pseudo-Voigt Line"
    pars["Background"]="Linear"
    pars["Mode"]="Normal"
    pars["AutoScaling"]=0
    pars["AutoFwhm"]=1

    pars["WeightFlag"]=0
    pars["Theory"]="Area Gaussians"
    pars["Background"]="Linear"
    pars["Mode"]="Normal"
    pars["Sensitivity"]=3.25
    pars["AutoScaling"]=1
    pars["AutoFwhm"]=1
    
    fit_filter.SetParameters(pars)

    view = GraphView(None,{"AddLockPosition":1,"AddOnLine":1,"AddRefresh":1,"AddCursorSelect":1,"AddStyleSelect":1,"ScrollMode":"ON","AddStatus":1,"AutoHideStatus":1,})
    view.SetLabels("DemoFit","(x)","(y)")
    view.SetStyle("PointsLine")
    view.SetSource((GraphFilter("G1",sel,pen=Pen((255,0,0),0,"solid")),GraphFilter("G2",fit_filter,pen=Pen((0,255,0),0,"dotted"))))
    view.AddMenuSeparator()
    view.AddMenuPopupItem("Fit parameters",ShowFitParsDialog)


    view.resize(500,500)
    view.Show()
    root.setMainWidget(view)
    root.exec_loop()


except:
    import traceback
    traceback.print_exc()
    print "Usage: DemoFitSPS <Spec name> <array name>"
