"""
    DemoEdfQt.py
 
    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
    
"""


from qt import *
from PyDVT.ExtendedImageView import ExtendedImageView,ColormapFilter
from PyDVT.Binding import Dialog,Container,Pen
from PyDVT.GraphView import GraphView,GraphFilter,HistFilter
from PyDVT.MeshView import MeshView,MeshFilter
from PyDVT.EdfFileData import EdfFileData
from PyDVT.DataSelection import RectSelection
from Command import Command
import sys



class MyView(ExtendedImageView):
  def EventSelection(self,source):    
    sel=source.GetDataSelection()
    if sel==None:return
    if source.GetType()=="Rect":
        if (hasattr(self,"Dialog3d")==0) or self.Dialog3d.IsVisible()==0:
            self.Dialog3d=MeshView(None)
            self.Dialog3d.SetSize(600,400)
            self.Dialog3d.Show()
            self.Dialog3d.setFocus()
        self.Dialog3d.SetSource(MeshFilter(None,sel)) 
        self.Dialog3d.Show()
    else:
        graph.Show()
        graph.SetSource(GraphFilter("",sel,pen=Pen((255,0,0),0,"solid")))

  def focusInEvent (self,e):
     self.GetDrawable().setFocus()

                            
def Histogram():
    global histwindow ,histdlg   
    if histwindow is None or histwindow.IsVisible()==0:
        histwindow=GraphView(None)
        histwindow.SetSize(600,400)        
        histwindow.SetStyle("Bars")
        histwindow.Show()
    histfilter=HistFilter(None,view.GetSource()[0],pen=Pen((255,0,0),1,"solid"))
    histfilter.SetDivisions(100)
    histwindow.SetSource(histfilter) 


def PageSelect(page):
    data.LoadSource(page)
    app.setName("DemoExt" + " - " + filename + " - Image: " + ("%d" % (page+1)))            


try:
    filename=sys.argv[1]    
    app = QApplication(sys.argv)
    container=Container(None)
    splitter = QSplitter(Qt.Vertical,container)
    data=EdfFileData()
    view = MyView(splitter)
    graph = GraphView(splitter,{"AddStyleSelect":1,"AddStatus":1,"AutoHideStatus":1,"AddCursorSelect":1})
    histwindow=histdlg=None
    data.SetSource(filename)    
    view.SetSource(ColormapFilter(None,RectSelection(data)))
    PageSelect(0)
    view.AddMenuSeparator()  
    for i in data.GetSourceInfo()["KeyList"]: view.AddMenuPopupItem("Image " + str(i+1),Command(PageSelect,i),"radiobutton")
    view.GetPopupMenu().SetCheckedRadio("Image 1")
    view.AddMenuSeparator()  
    view.AddMenuPopupItem("Histogram",Histogram)    
    app.setMainWidget(container)
    container.SetSize(600,400)
    graph.hide()
    container.Show()
    app.setMainWidget(container)
    app.exec_loop()
    
except:
    import traceback
    traceback.print_exc()
    print "Usage: DemoEdfQt <filename(edf)>"    



