import EventHandler
from PyDVT.Binding import Brush, Pen

class ViewSelectList:
	def __init__(self, view, viewselect_class):
		self.View	= view
		self.SelectList	= []
		self.ViewSelect	= viewselect_class

		self.eh		= EventHandler.EventHandler()
		self.ChangeEvent= self.eh.create("ListChange")

	def GetList(self):
		return self.SelectList

	def Enable(self, index=None):
		for idx in self.__GetIndexList(index):
			self.SelectList[idx].Enable()

	def Disable(self, index=None):
		for idx in self.__GetIndexList(index):
			self.SelectList[idx].Disable()

	def __GetIndexList(self, index=None):
		if index is None:
			index= range(len(self.SelectList))
			index.reverse()
			return index
		elif index<0:
			index= self.GetActive()
			if index is None:
				return []
			else:
				return [ index ]
		else:
			if type(index)!=type([]): index= [index]
			index.sort()
			index.reverse()
			return index
			
	def SendEvent(self):
		self.eh.event(self.ChangeEvent, self.SelectList)

	def SetActive(self, index=0):
		""" index= index of ViewSelect to set active
			   -1 to set all ViewSelect non active
		"""
		for idx in range(len(self.SelectList)):
			self.SelectList.SetActive(index==idx)

	def GetActive(self):
		for idx in range(len(self.SelectList)):
			if self.SelectList[idx].IsActive():
				return idx
		return None

	def Hide(self, index=None):
		for idx in self.__GetIndexList(index):
			self.SelectList[idx].Hide()

	def Show(self, index=None):
		for idx in self.__GetIndexList(index):
			self.SelectList[idx].Show()

	def Delete(self, index=-1, sendevent=1):
		""" index = idx or [idxs] to delete ViewSelect
			  = -1 to delete active ViewSelect if any
			  = None to delete all ViewSelect
		"""
		for idx in self.__GetIndexList(index):
			select= self.SelectList[idx]
			select.Erase(self.View)
			select.Destroy()
			del self.SelectList[idx]
		if sendevent: self.SendEvent()

	def Add(self, rect, sendevent=1):
		new= self.ViewSelect()
		new.ConnectView(self.View)
		new.SetPen(self.GetPen())
		new.SetBrush(self.GetBrush())
		new.SetSelectionPos(rect)
		self.SelectList.append(new)
		if sendevent: self.SendEvent()
		return len(self.SelectList)-1

	def GetPen(self):
		return Pen((0,0,0), 1, "solid")

	def GetBrush(self):
		return Brush((240,240,240),"fill_100")
