from DataSelection import OrthoLineSelection
import os.path

class McaSPSSelection(OrthoLineSelection):
	def __init__(self, source=None, key_list=None, synchronized=1):
		page= {"Key": key_list["Key"], "SourceName": key_list["SourceName"]}
		if not key_list.has_key("plot"): key_list["plot"]= "cols"
		if not key_list.has_key("x"): key_list["x"]= 0
		if not key_list.has_key("y"): key_list["y"]= 1

		cols= (key_list["plot"]=="cols")
		yidx= key_list["y"]
		if cols:
			yposition= (yidx,0)
			ysize= (1, "ALL")
		else:
			yposition= (0,yidx)
			ysize= ("ALL", 1)
		OrthoLineSelection.__init__(self, source, yposition, ysize, page, synchronized)

		xidx= key_list["x"]
		if xidx is not None:
			if cols:
				xposition= (xidx,0)
				xsize= (1,"ALL")
			else:
				xposition= (xidx,0)
				xsize= ("ALL",1)
			self.xselection= OrthoLineSelection(source, xposition, xsize, page, synchronized=0)
		else:
			self.xselection= None

		self.range= key_list.has_key("range") and key_list["range"] or None
		print "SPS", self.IndexList

	def GetOutput(self):
		ysel= OrthoLineSelection.GetOutput(self)
		if not ysel.has_key("data"): return {}

		if self.xselection is not None:
			xsel= self.xselection.GetOutput()
			if not xsel.has_key("data"): 
				ysel["xdata"]= Numeric.arrayrange(ysel["data"].shape[0])
			else:
				ysel["xdata"]= xsel["data"]

		if self.range is not None:
			ysel["data"]= ysel["data"][self.range[0]:self.range[1]]
			ysel["xdata"]= ysel["xdata"][self.range[0]:self.range[1]]

		return ysel
			
	def GetInfo(self):
		info= {}
		info["index_list"]= self.IndexList
		info["Legend"]= "%s:%s"%(self.IndexList[0]["SourceName"], self.IndexList[0]["Key"])
		return info

	def Destroy(self, source=None):
		self.xselection.Destroy(source)
		OrthoLineSelection.Destroy(self)

	def GetType(self):
		return "SpecArray"
