
from PyDVT.ViewSelect import ViewSelect
from math import fabs

class PeakViewSelect(ViewSelect):
	def __init__(self, data=None, callback=None):
		ViewSelect.__init__(self, data, callback)

	def SetSelection(self, selection):
		""" selection= { "name": (x, ymax) }
		    ymin is always defined as graph minimum
		    if ymax is None, ymax will be set as graph maximum
		"""
		ViewSelect.SetSelection(self, selection)

	def DrawView(self, view):
		try:
			if view.GetSource() == (): return
			self.DrawSelection(view)
		except:
			pass

	def DrawSelection(self, view):
		(ymin,ymax)= view.GetYAxis()
		for (name, coord) in self.Selection.items():
			xpos= coord[0]
			ypos= coord[1]
			if ypos is None:
				ypos= ymax
			
			if name in self.ViewList[view].keys():
				view.Drawable.SetObjectCoords(self.ViewList[view][name],
						xpos, ymin, xpos, ypos)
			else:
				self.ViewList[view][name]= view.Drawable.PutLine(xpos, ymin,
						xpos, ypos, self.Pen)

	def EraseView(self, view):
		for name in self.ViewList[view].keys():
			if name!="Mode":
				view.Drawable.EraseObject(self.ViewList[view][name])
				del self.ViewList[view][name]

	def GetType(self):
		return "Peak"

