import qt
import EventHandler
import SpecFileData, SpecFileSelection, SpecFileSelector
import SPSData, SPSSelection, SPSSelector

"""
SourceClass= { type: [ data_class, selection_class, selection_widget, refresh_interval(msec) or None ] }
"""

SourceClass= { SpecFileData.SOURCE_TYPE: [ SpecFileData.SpecFileData, 
					SpecFileSelection.McaSelection, 
					SpecFileSelector.SpecFileSelector,
					None ],
		SPSData.SOURCE_TYPE: [ SPSData.SPSData,
					SPSSelection.McaSPSSelection,
					SPSSelector.SPSSelector,
					500 ] 
		}

SourceMenu= { SpecFileData.SOURCE_TYPE: ["Spec&File", qt.Qt.CTRL+qt.Qt.Key_F],
		SPSData.SOURCE_TYPE: ["Spec &Arrays", qt.Qt.CTRL+qt.Qt.Key_A]
	    }


class McaDataSource:
	def __init__(self, data_class, selection_class, selection_widget, refresh_interval=None):
		self.DataClass= data_class
		self.SelectionClass= selection_class
		self.SelectionWidgetClass= selection_widget

		self.Data= self.DataClass(refresh_interval)
		self.SelectionWidget= None

		self.SelectionList= []
		self.SelectionObjs= []

		self.eh= EventHandler.EventHandler()
		self.addDataEvent= self.eh.create("addDataEvent")

	def createSelectionWidget(self, parent=None):
		""" Create Selection widget and register to its events
		"""
		self.SelectionWidget= self.SelectionWidgetClass(parent)
		self.SelectionWidget.setData(self.Data)
		self.SelectionWidget.eh.register("addSelection", self.addSelection)
		self.SelectionWidget.eh.register("delSelection", self.delSelection)
		return self.SelectionWidget

	def getSelectionWidget(self, parent=None):
		""" Return the selection widget. If it doesn't exist, create it.
		"""
		if self.SelectionWidget is None:
			self.createSelectionWidget(parent)
		self.updateSelectionWidget()
		return self.SelectionWidget

	def closeSelectionWidget(self):
		""" Close the selection widget and unregister from its events
		"""
		if self.SelectionWidget is not None:
			self.SelectionWidget.eh.unregister("addSelection", self.addSelection)
			self.SelectionWidget.eh.unregister("delSelection", self.delSelection)
			self.SelectionWidget.close()

	def updateSelectionWidget(self):
		""" Update the selection widget with the current selection list
		"""
		if self.SelectionWidget is not None:
			self.SelectionWidget.setSelected(self.SelectionList)

	def addSelection(self, selkeys):
		""" Arguments: selkeys is a list of selection keys needed to create DataSelection Object.
		    Load the source indexed by SourceName and Key in selection keys
		    Create DataSelection object with all selection keys
		    Send addDataEvent with all DataSelection objects
		"""
		toadd= [ sel for sel in selkeys if sel not in self.SelectionList ]
		data= []
		failed= []
			
		for sel in toadd:
			# --- load the source
			name= sel["SourceName"]
			sourced= (name==self.Data.SourceName)
			if not sourced:
				sourced= self.Data.SetSource(name)
				name= self.Data.SourceName
			if sourced:
				key= sel["Key"]
				sourced= (key in self.Data.GetSourceLoadedKeys(name))
				if not sourced:
					try: self.Data.LoadSource(key_list=[key], append=1, invalidate=1)
					except: pass
					sourced= (key in self.Data.GetSourceLoadedKeys(name))

				if sourced:
					# --- create data selection object
					try:
						datasel= self.SelectionClass(source=self.Data, key_list=sel, synchronized=1)
						data.append(datasel)
						self.SelectionList.append(sel)
						self.SelectionObjs.append(datasel)
					except:
						sourced= 0
			if not sourced:
				failed.append(sel)

		if len(data):
			self.eh.event(self.addDataEvent, data)
			self.updateSelectionWidget()
		return failed
	
	def delSelection(self, selkeys):
		""" Arguments: list of selection keys as used for addSelection
		    Remove selection keys from selection list
		    Delete linked page source if no other selection are linked to that page
		"""
		todel= []
		names= []
		for sel in selkeys:
			if sel in self.SelectionList:
				idx= self.SelectionList.index(sel)
				todel.append(idx)

		if len(todel):
			self.__deleteIndex(todel)
			self.updateSelectionWidget()

	def __deleteIndex(self, index):
		""" Delete given indexes in SelectionList/Name
		    Delete Data source if no other selection are linked to that source
			( based only on "SourceName" and "Key" )
		"""
		loaded= []
		unload= []
		for idx in range(len(self.SelectionList)):
			sel= self.SelectionList[idx]
			key= {"SourceName": sel["SourceName"], "Key": sel["Key"]}
			if idx in index:
				unload.append(key)
			else:
				loaded.append(key)
		for idx in index:
			del self.SelectionList[idx]
			self.SelectionObjs[idx].Destroy()
			del self.SelectionObjs[idx]
		for key in unload:
			if key not in loaded:
				self.Data.Delete(key)
			
	def delDataSelection(self, datasel):
		""" Arguments: list of DataSelection objects
		    Remove DataSelection Objects (by calling their Destroy method)
		    Refresh internal SelectionList and the selection widget
		"""
		todel= []
		for sel in datasel:
			if sel in self.SelectionObjs:
				todel.append(self.SelectionObjs.index(sel))

		if len(todel):
			self.__deleteIndex(todel)
			self.updateSelectionWidget()


def test(type):
	import SpecFileData, SpecFileSelection, SpecFileSelector
	import SPSData, SPSSelection, SPSSelector
	import qt

	global d

	def CB(sellist):
		global d
		print "DataNumPages", d.Data.GetNumberPages()
		for sel in sellist:
			print sel

	d= McaDataSource(SourceClass[type][0], SourceClass[type][1], SourceClass[type][2], SourceClass[type][3])
	d.eh.register("addDataEvent", CB)

	a= qt.QApplication(sys.argv)
	w= d.getSelectionWidget()
	a.setMainWidget(w)
	w.show()

	a.exec_loop()

if __name__=='__main__':
	import sys
	if len(sys.argv)!=2:
		print "TEST: %s <SOURCE_TYPE>"%sys.argv[0]
		sys.exit(0)
	test(sys.argv[1])
