
from qt import *

class GraphItemList(QWidget):
	def __init__(self, parent=None, name=None, graph=None):
		QWidget.__init__(self, parent, name, 0)

		self.name= name
		self.graph= graph
		self.refreshFlag= 0

		self.items= ["list", "roi", "setting"]

		mainLayout= QVBoxLayout(self)

		self.list= QListBox(self)
		self.list.insertItem("Data List")
		self.list.insertItem("ROI List")
		self.list.insertItem("Settings")
		self.connect(self.list, SIGNAL("highlighted(int)"), self.__selectItem)
		mainLayout.addWidget(self.list)

		#cmdWidget= QWidget(self)
		#cmdLayout= QHBoxLayout(cmdWidget)
		#remove= QPushButton("Remove", cmdWidget)
		#cmdLayout.addWidget(remove)
		#self.connect(remove, SIGNAL("clicked()"), self.__removeClicked)
		#mainLayout.addWidget(cmdWidget)

	def initSelect(self):
		self.list.setSelected(0, 1)

	def setAutoRefresh(self, auto):
		if self.refreshFlag!=auto:
			self.refreshFlag= auto
			if auto:
				self.setGraphFilters(self.graph.GetSource())
				self.graph.eh.register("SourceChange", self.setGraphFilters)
			else:
				self.graph.eh.unregister("SourceChange", self.setGraphFilters)
			
	def setGraphFilters(self, filters):
		datanames= [ filter.GetInfo()["name"] for filter in filters ]
		currnames= self.items[3:]

		delnames= [ name for name in currnames if name not in datanames ]
		for name in delnames:
			self.__removeData(name)

		addnames= [ name for name in datanames if name not in currnames ]
		for name in addnames:
			filter= filters[datanames.index(name)]
			legend= filter.GetDataSelection().GetInfo().get("Legend", None)
			self.__insertData(name, legend)
	
	def __removeData(self, name):
		idx= self.items.index(name)
		self.list.removeItem(self.items.index(name))
		del self.items[idx]

	def __insertData(self, name, legend=None):
		if legend is None:
			legend= "data no %d"%len(self.items)
		self.list.insertItem(legend)
		self.items.append(name)

	def __selectItem(self, index):
		name= self.items[index]
		self.emit(PYSIGNAL("itemSelected"), (name,))

	def __removeClicked(self):
		print "removeClicked"

if __name__=="__main__":
	import sys

	a= QApplication(sys.argv)
	QObject.connect(a, SIGNAL("lastWindowClosed()"),a,SLOT("quit()"))

	w= GraphItemList()
	a.setMainWidget(w)
	w.show()

	a.exec_loop()
