from qt import *
from PyDVT.QtBinding.FitParametersDialog import FitParametersDialog


class FitWindow(FitParametersDialog):
	def __init__(self, parent=None, name=None):
		FitParametersDialog.__init__(self, parent, None)
		self.setCaption(name)

class NewFitWindow(QMainWindow):
	def __init__(self, parent=None, name="FitWindow", fl=0):
		QMainWindow.__init__(self, parent, name, fl)
	
		layout= QVBoxLayout(self)

		self.table= ParametersTab(self)
		layout.addWidget(self.table)

		butWidget= QGroupBox(3, Qt.Horizontal, self)
		close= QPushButton("Close", butWidget)
		self.connect(close, SIGNAL("clicked()"), self.close)
		self.estimateButton= QPushButton("Estimate", butWidget)
		self.connect(self.estimateButton, SIGNAL("clicked()"), self.Estimate)
		self.startfitButton= QPushButton("Start Fit", butWidget)
		self.connect(self.startfitButton, SIGNAL("clicked()"), self.StartFit)

		layout.addWidget(butWidget)

		self.setCaption(name)
		self.statusBar().message("Ready")

	def __buttonClicked(self, idx):
		if idx==0:	self.close()
		elif idx==1:	self.Estimate()
		elif idx==2:	self.StartFit()

	def onInitialize(self, eh=None, fit=None):
		self.Reset()

		self.eh= eh
		if self.eh is not None:
			self.EvParamChange = self.eh.create("ParametersChange")
			self.eh.register("FitFinished", self.__fitFinished)

		self.fit= fit
		if self.fit is not None:
			print "Initialize config menu"

	def StartFit(self):
		#parameters= self.GetParameters()
		print "StartFit"

	def Estimate(self):
		print "Estimate"
