from qt import *
from qttable import *
from McaGraphView import CalibTypes, CalibDefaultType, CalibDefaultName, CalibDefaultCoeff

class DataInfo(QWidget):
	def __init__(self, parent=None, name=None, graph=None):
		QWidget.__init__(self, parent, name, 0)

		self.name= name
		self.graph= graph
		self.refreshFlag= 0

		mainLayout= QHBoxLayout(self)

		# --- calibration table
		self.table= QTable(self)
		self.table.setSelectionMode(QTable.SingleRow)
		self.table.setFocusStyle(QTable.FollowStyle)

		self.table.setNumCols(6)
		Hheader= self.table.horizontalHeader()
		Hheader.setLabel(0, "Type")
		Hheader.setLabel(1, "Active")
		Hheader.setLabel(2, "Name")
		Hheader.setLabel(3, "A")
		Hheader.setLabel(4, "B")
		Hheader.setLabel(5, "C")

		self.connect(self.table, SIGNAL("valueChanged(int,int)"), self.__valueChanged)
		mainLayout.addWidget(self.table)

		# --- command buttons
		butWidget= QWidget(self)
		butLayout= QVBoxLayout(butWidget)

		addB= QPushButton("Add", butWidget)
		butLayout.addWidget(addB)
		delB= QPushButton("Remove", butWidget)
		butLayout.addWidget(delB)

		self.connect(addB, SIGNAL("clicked()"), self.__addClicked)
		self.connect(delB, SIGNAL("clicked()"), self.__delClicked)

		mainLayout.addWidget(butWidget, 0, Qt.AlignTop)

	def setGraph(self, graph):
		self.graph= graph

	def setFilter(self, filter):
		if filter is not None:
			self.calib= filter.GetCalib()
			self.refresh()
		else:
			self.reset()
			self.calib= None

	def setAutoRefresh(self, auto):
		if auto!=self.refreshFlag:
			self.refreshFlag= auto

	def reset(self):
		self.table.setNumRows(0)

	def refresh(self):
		self.reset()
		param= self.calib.GetParam()
		for type in CalibTypes:
			for name in param[type][1].keys():
				active= name==param[type][0]
				self.addRow(type, active, name, param[type][1][name])
		self.__adjustTable()

	def addRow(self, type, active, name, coeff):
		row= self.table.numRows()
		self.table.setNumRows(row+1)
		self.table.setItem(row, 0, self.__getComboItem(CalibTypes, type))
		self.table.setItem(row, 1, self.__getCheckItem(None, active))
		self.table.setText(row, 2, name)
		self.table.setText(row, 3, "%g"%coeff[0])
		self.table.setText(row, 4, "%g"%coeff[1])
		self.table.setText(row, 5, "%g"%coeff[2])
		if type==CalibDefaultType and name==CalibDefaultName:
			self.table.setRowReadOnly(row, 1)

	def __getCheckItem(self, text, checked=0):
		item= QCheckTableItem(self.table, text)
		item.setChecked(checked)
		return item

        def __getComboItem(self, data, selected=None):
                item= QComboTableItem(self.table, self.__getStringList(data))
                if selected is not None:
                        item.setCurrentItem(data.index(selected))
                return item

        def __getStringList(self, plist):
                strlist= QStringList()
                for d in plist:
                        strlist.append(d)
                return strlist

        def __adjustTable(self):
                for col in range(1,self.table.numCols()):
                        self.table.adjustColumn(col)

	def __valueChanged(self, row, col):
		type= str(self.table.item(row, 0).currentText())
		name= str(self.table.text(row, 2))
		if (col==1):
			active= self.table.item(row, 1).isChecked()
			self.calib.SetActive(type, active and name or None)
		elif col in (3, 4, 5):
			try:
				a= float(str(self.table.text(row, 3)))
				b= float(str(self.table.text(row, 4)))
				c= float(str(self.table.text(row, 5)))
				self.calib.Set(type, name, (a, b, c))
			except:
				self.refresh()

	def __addClicked(self):
		self.calib.Set(CalibTypes[1], "calib%d"%self.table.numRows(), CalibDefaultCoeff)
		self.refresh()

	def __delClicked(self):
		for row in range(self.table.numRows()):
			if self.table.isRowSelected(row):
				type= str(self.table.item(row, 0).currentText())
				name= str(self.table.text(row, 2))
				if not (type==CalibDefaultType and name==CalibDefaultName):
					self.calib.Remove(type, name)
					self.refresh()
