import sys,types
from Numeric import *

sys.path.insert(0,'./..')
sys.path.insert(0,'../fit')

import PyDVT
from PyDisWindow import *
import Py4datDisplay
from Binding import FitParametersDialog
from PyDVT.View import View
from ExtendedImageView import *
from Py4datGraphView import *
from PyDVT.GraphView import GraphView,GraphFilter
import ImageViewSelect
import Py4datImageViewSelect
from AzimIntFilter import AzimIntFilter
from FitFilter import FitFilter
from Py4datMaskFilter import Py4datMaskFilter
from IntegrateQFilter import *
from IntegratePhiFilter import *
import DataWrapper
import AzimInt
import Integration
import WriteEdfFile
import ReadHdf5File
import WriteHdf5File
import Py4datDisplay
import SciDXPData
from PyDVT.ImageView import ImageView


DEBUG=1

class Py4datTransformPlugin(Plugin):
    	########################################################
    	### Virtuals
    	########################################################
    	def OnStartInit (self):
		if DEBUG: print 'In Py4datTransformPlugin.OnStartInit...'
		return 1

    	def OnInitMenuBar (self,menu_bar):
        	if DEBUG: print 'In Py4datTransformPlugin.OnInitMenuBar...'
		self.menu_plugin = qt.QPopupMenu(menu_bar)
        	self.menu_plugin.insertItem('Save Stack I(Phi)',self.StackSaveIPhi)
        	menu_bar.insertItem('&Transform',self.menu_plugin)

    	def OnFinishInit (self,app_window):
        	if DEBUG: print 'In Py4datTransformPlugin.OnFinishInit...'
		self.app_window=app_window

    	def OnInitWindowPopupMenu (self,window):
    		if DEBUG: print 'In Py4datTransformPlugin.OnInitWindowPopupMenu...'
    		if isinstance(window.View,ImageView) == 0 or window.master_window is not None: return
        	window.Mask=None
		window.rois={}
		window.activeRoi=None
		window.activeRoiHighlight=[]
		window.roiLimit_dnd=0 	# roi limit drag 'n' drop management mode
		window.View.AddMenuSeparator()
		window.View.AddMenuPopupItem("Add mask Rectangle",Command.Command(self.MaskDefine))
		window.View.AddMenuPopupItem("Add mask Polygon",Command.Command(self.Polygon))
		window.View.AddMenuPopupItem("Del Masks",Command.Command(self.DelMasks))
		window.View.AddMenuPopupItem("AzimInt",Command.Command(self.AzimInt))
	
	def OnFileOpen (self,filename,format_string):
        	if DEBUG: print 'In Py4datTransformPlugin.OnFileOpen...'
		type=string.upper(format_string)
            	short_name= os.path.split(filename)[1]
            	print string.upper(type)[0:4]
		if string.upper(type)[0:4]=="HDF5":
                	window=ViewWindow (self.app_window.mdi,ExtendedGraphView,short_name)
                	window.shortName=short_name
                	window.fileName=filename
			scidxpData=SciDXPData.SciDXPData()
                	window.Data=scidxpData
			inputDataSetNode=ReadHdf5File.ReadHdf5FileGroupNode(filename)
                	window.Data.SetSource(inputDataSetNode)
                	window.DataSelection=DataSelection.OrthoLineSelection(window.Data)
                	window.Filter=GraphView.GraphFilter(None,window.DataSelection)
                	window.View.SetSource(window.Filter)
                	info=window.Data.GetSourceInfo()
                	window.NumImages=info["Size"]
                	#self.app_window.SetEdfViewMenu(window)
                	self.app_window.PageSelect(window,0) 
	
	def GetOpenFormatList(self):
        	if DEBUG: print 'In Py4datTransformPlugin.GetOpenFormatList...'
		return ["HDF5 files (*.hdf5)"]
	
    	########################################################
    	### Private methods
    	########################################################
    	
	def UpdateViews(self,window):
		if DEBUG: print 'In Py4datTransformPlugin.UpdateViews...'
		#for win in self.app_window.mdi.windows:  print win.name
		azimIntWindow=self.app_window.GetWindow('AzimInt - '+ window.name)
		integratePhiWindow=self.app_window.GetWindow('I(Phi) - AzimInt - '+ window.name)
		integrateqWindow=self.app_window.GetWindow('I(q) - AzimInt - '+ window.name)
		if azimIntWindow != None: 
			self.AzimInt()
			if integratePhiWindow != None:
				self.IPhi()
			if integrateqWindow != None: 
				self.Iq()
	
	############## MASK ################################################
		
	def SetMask(self, val=None, rect=None):
		window=self.app_window.mdi.activeWindow()
		window.View.Drawable.SetMask (val=val,rect=rect)
	
	def DelMasks(self):
		window=self.app_window.mdi.activeWindow()
		data=window.View.GetSource()[0].GetOutput()['data']
		window.View.GetSource()[0].GetSource().SetMask(Numeric.ones(data.shape,data.typecode()))
		window.View.Refresh()
		window.Mask=None
		self.UpdateViews(window)
	
	def MaskDefine(self):
		window=self.app_window.mdi.activeWindow()
		if (window.View.Source!=()):
			#window.View.DisableModeRoi()
			
			data=window.View.Source[0].GetData()
			if data==None: return
			#print window.View.Source[0]
			if type(window.Mask)==types.NoneType:
				maskedImage=Py4datMaskFilter(DataSelection.RectSelection(data))
				colormap=ColormapFilter("colormap",maskedImage)
				window.View.SetSource(colormap)
			
			window.View.MaskSelect=ImageViewSelect.ImageViewSelectRect(data,self.EventMaskSelection)
			window.View.MaskSelect.ConnectView(window.View)		
			
	def EventMaskSelection(self,source):
		window=self.app_window.mdi.activeWindow()
		if (window.View.Source != ()) and (window.View.Source[0] != None):
			#print 'mask',window.Mask
			if type(window.Mask)==types.NoneType:
				window.Mask=ones(window.View.Source[0].GetData().Pages[0].Array.shape)
			data=window.View.GetSource()[0].GetOutput()['data']
          		if window.View.GetSource()[0]==None:
             			window.View.ClearMaskSelect()
              			return
          		window.View.MaskSelect.EraseSelection(window.View)
          		(p0,p1)=source.GetSelection()["BoundingRect"]
          		(x0,y0),(x1,y1)=window.View.Source[0].DataCoord2SelectionCoord(p0),window.View.Source[0].DataCoord2SelectionCoord(p1)
          		rect=(min(x0,x1),min(y0,y1),max(x0,x1),max(y0,y1))
          		#print x0,y0,x1,y1
			x,y=x0,y0
			while x < x1:
				while y < y1:
					window.Mask[y,x]=0.
					y=y+1
				x,y=x+1,y0
			#print window.View.GetSource()[0].GetSource()
			window.View.GetSource()[0].GetSource().SetMask(window.Mask)
			window.View.Refresh()
			#print window.View
			self.UpdateViews(window)
			self.ClearMaskSelect()

	def ClearMaskSelect(self):
		window=self.app_window.mdi.activeWindow()
        	if (window.View.MaskSelect is not None):
          		window.View.MaskSelect.Destroy()
          		window.View.MaskSelect=None    

	################## POLYGON ################################################
		
	def Polygon(self):
		window=self.app_window.mdi.activeWindow()
		if (window.View.Source!=()):
			#self.DisableModeRoi()
			data=window.View.Source[0].GetData()
			if type(window.Mask)==types.NoneType:
				maskedImage=Py4datMaskFilter(DataSelection.RectSelection(data))
				colormap=ColormapFilter("colormap",maskedImage)
				window.View.SetSource(colormap)
			if data==None: return
			if hasattr(window.View,"PolygonSelect") and window.View.PolygonSelect is not None:
				window.View.PolygonSelect.Destroy()
			window.View.PolygonSelect=Py4datImageViewSelect.ViewSelectPolygon(data,self.EventPolygonSelection)
			window.View.PolygonSelect.ConnectView(window.View)
			#from Binding import Pen
			#self.PolygonSelect.SetPen(Pen((255,0,0),2,"dotted"))
			
	def EventPolygonSelection(self,source):
		window=self.app_window.mdi.activeWindow()
		#print 'Polygon selected' 
		if type(window.Mask)==types.NoneType:
				window.Mask=ones(window.View.Source[0].GetData().Pages[0].Array.shape)
		#print source.GetSelection()['Polygon']
		nbSites=len(source.GetSelection()['Polygon'])-1
		listx,listy=[],[]
		for position in source.GetSelection()['Polygon']:
			listx.append(position.PageCoord[0]),listy.append(position.PageCoord[1])
		#print listx,listy
		xmin,ymin,xmax,ymax=min(listx),min(listy),max(listx),max(listy)
		#print 'xmin, ymin, xmax, ymax=',xmin, ymin, xmax, ymax
		x=xmin
		while x < xmax:	
			y=ymin
			while y < ymax:
				i=0
				#position='OUT'
				intersection=0
				#if i==0:
				while i < nbSites:
					try:
						(xi,yi)=(source.GetSelection()['Polygon'][i].PageCoord)
						if i<nbSites-1: (xinext,yinext)=(source.GetSelection()['Polygon'][i+1].PageCoord)
						elif i==nbSites-1:(xinext,yinext)=(source.GetSelection()['Polygon'][0].PageCoord)
						#try: (xinext,yinext)=source.GetSelection()['Polygon'][i+1].PageCoord
						#except: (xinext,yinext)=source.GetSelection()['Polygon'][-1].PageCoord
						#try: (xiend,yiend)=source.GetSelection()['Polygon'][i+2].PageCoord
						#except: (xiend,yiend)=source.GetSelection()['Polygon'][i+2-nbSites].PageCoord
						#if float((x-xi)*(yinext-yi)-(y-yi)*(xinext-xi))*float((xiend-xinext)*(yinext-yi)-(yiend-yinext)*(xinext-xi)) > 0.:
						a=(yinext-yi)*1./(xinext-xi)
						b=(yi*xinext-yinext*xi)*1./(xinext-xi)
						c=(y*1./x)
						xj=b/(c-a)
						yj=(c*b)/(c-a)
						if xj>min(xi,xinext) and xj<max(xi,xinext) and yj>min(yi,yinext) and yj<max(yi,yinext) and xj<x and yj<y:
							#print 'positive result',float((x-xi)*(yinext-yi)-(y-yi)*(xinext-xi))*float((xiend-xinext)*(yinext-yi)-(yiend-yinext)*(xinext-xi))
							#print 'intersection=',xj,yj
							intersection=intersection+1
							#position='IN'
						#else: 
							#print 'negative result'
							#position='OUT'
							#break
						#print i
						i=i+1
					except:
						i=i+1
						continue
				#if position=='IN':
				#	self.Source[0].GetData().Pages[0].Array[y,x]=0.
				#print 'intersection=',intersection
				if intersection % 2==0: pass #print 'intersection pair'
				else:
					window.Mask[y,x]=0.
					#self.Source[0].GetData().Pages[0].Array[y,x]=0.
					#print 'intersection impair'
				y=y+1
			x=x+1
		#print window.View.GetSource()[0].GetSource()
		window.View.GetSource()[0].GetSource().SetMask(window.Mask)
		window.View.Refresh()
		self.UpdateViews(window)
		source.Disable()
		self.ClearPolygonSelect()
		
	def ClearPolygonSelect(self):
        	window=self.app_window.mdi.activeWindow()
		if (window.View.PolygonSelect is not None):
          		window.View.PolygonSelect.Destroy()
          		window.View.PolygonSelect=None
    


	################## SELECT ROI ###############################################

	def _SetRoi(self,parentWindow):
		if DEBUG==1: print 'In _SetRoi...'
		window=self.app_window.mdi.activeWindow()
		newstate=not window.View.MenuPopup.IsItemChecked(window.View.RoiMenuItem)
		self.SetModeStateRoi(newstate,parentWindow)
		window.View.MenuPopup.CheckItem(window.View.RoiMenuItem,newstate)
		
	def _DelAllRois(self,parentWindow):
		window=self.app_window.mdi.activeWindow()
		for roi in self.GetRois(parentWindow): 
			self.DelRoi(roi.name)
		print window.name
		print window.master_window.name
		self.UpdateViews(window.master_window)
		

	############################################
	###   SELECTION ON THE IMAGE CALLBACKS   ###
	############################################
	
	def EventRoiSelection(self,source):
		"""
		Virtual : Callback of a new roi selection : to be overidden for specific behavior
		"""
		window=self.app_window.mdi.activeWindow()
		parentWindow=window.master_window
		if DEBUG : print "EventRoiSelection"
		((xmin,y0),(xmax,y1))=window.View.Select.Selection["BoundingRect"][0].PageCoord,window.View.Select.Selection["BoundingRect"][1].PageCoord
		self.PutRoi(name='roi',limits=[(xmin,xmax)],pen=Pen((100,100,100),2,"solid"),brush=Brush((100,100,100),"fill_25"))
		nbRois=len(self.GetRois(parentWindow))
		#print self.GetRois(parentWindow)
		i=0
		if DEBUG:
			while i<nbRois:
				print self.GetRois(parentWindow)[i].name
				print self.GetRois(parentWindow)[i].limits[0]
				i=i+1

	##########################################
	###  IMAGE ITEMS SELECTION CALLBACKS   ###
	##########################################
		
	def ClickOnRoiCB(self,roiName=None):
		"""
		Callback of a click in a roi event : to be overidden for specific behavior
		"""
		if DEBUG : print " ClickOnRoiCB ",roiName
		# if more than one roi, make it being the active one
		self.SetActiveRoi(roiName)

	##################################
	###   MOUSE EVENTS CALLBACKS   ###
	##################################
	
	
	def EventButtonPressMotion(self,pos):
		#if self.opts['RoiSelection']: 
		# roi limits drag 'n' drop
		window=self.app_window.mdi.activeWindow()
		if window.roiLimit_dnd:
			i=0
			while i<len(window.draggedRoiLimit):
				roi,limit=window.draggedRoiLimit[i]
				roi.MoveLimit(limit,pos.DataCoord[0])
				if roi==self.GetActiveRoi():
					# update active roi highlight box
					for obj in window.activeRoiHighlight:
						xmin,ymin,xmax,ymax=window.View.Drawable.GetObjectCoords(obj)
						ymin,ymax=0,view.Source[0].GetData().Pages[0].Array.shape[1]
						if xmin==limit:
							xmin=pos.DataCoord[0]
							window.View.Drawable.SetObjectCoords(obj,xmin,ymin,xmax,ymax)
						elif xmax==limit:
							xmax=pos.DataCoord[0]
							window.View.Drawable.SetObjectCoords(obj,xmin,ymin,xmax,ymax)
				window.draggedRoiLimit[i]=(roi,pos.DataCoord[0])
				i+=1
	
	def EventButtonRelease(self,pos):
		#if self.opts['RoiSelection']: 
		# disable roi limits drag 'n' drop if set
		window=self.app_window.mdi.activeWindow()
		if window.roiLimit_dnd:
			window.roiLimit_dnd=0
			window.draggedRoiLimit=overlappedRoiLimit
	

	################################
	###      ROI MANAGEMENT      ###
	################################
	
	def InsideRoi(self,pos):
		"""
		return the sequence of rois containing the image position 'pos'. If None, return an empty sequence
		"""
		window=self.app_window.mdi.activeWindow()
		ret=[]
		for roi in window.rois.keys():
			# in each roi 
			for min,max in window.rois[roi].limits:
				# in each roi limit
					if pos[0]>=min and pos[0]<=max:
						ret.append(window.rois[roi])
		return ret

	
	
	def PutRoi(self,name='roi',limits=[],pen=Pen((0,0,0),2,"solid"),brush=Brush((0,0,0),"fill_25")):
		"""
		Put a roi on the image with the specified parametres :
			-	name : the name given to this roi. If an already existant roi have the same name, it will be renamed with an non existing name using the style existing-name'_x'
				 		   where x is a integer.
			-	limits : the image limits defining this roi : it's a sequence of min,max tuples
			-	pen : the pen style used for drawing the roi border
			-	brush : the brush style used for filling the roi
		Once the roi has been added, it is set as the active one		   
		"""	
		window=self.app_window.mdi.activeWindow()
		if DEBUG: print 'In PutRoi...'
		if window.rois.has_key(name):
			# if a roi with a name of label exists : renamed the one to add
			i=0
			while window.rois.has_key(name+'_'+str(i)):
				i+=1
			name+='_'+str(i)
		
		# hide all other roi names
		for roi in window.rois.keys():
			window.rois[roi].HideName()
		
		# add the new roi parametres to the list
		#print 'ROI name=',name,'ROI limits=',limits
		window.rois[name]=Py4datDisplay.Py4datImageViewRoi(window.View,name,limits,pen,brush)
		
		# make the new roi become the active one
		self.SetActiveRoi(name)
			
	def DelRoi(self,name=''):
		"""
		Delete the roi with the given name
		"""
		window=self.app_window.mdi.activeWindow()
		if window.rois.has_key(name):
			# erases roi rectangles
			for obj in window.rois[name].drawnRect:
				window.View.Drawable.EraseObject(obj)
			# erases roi labels
			for obj in window.rois[name].drawnLab:
				window.View.Drawable.EraseObject(obj)
			# delete it in the rois list
			del window.rois[name]
			
			if self.GetActiveRoi().name == name:
				# if roi to delete is the active one : erases active roi border rectangles
				for obj in window.activeRoiHighlight:
					window.View.Drawable.EraseObject(obj)
					window.activeRoiHighlight.remove(obj)
			
	def ShowRoisNames(self):
		"""
		show all rois labels
		"""
		window=self.app_window.mdi.activeWindow()
		for roi in window.rois.keys():
			window.rois[roi].ShowName()
			
	def ShowRoiName(self,name=''):
		"""
		show the label of the roi called 'name' 
		"""
		window=self.app_window.mdi.activeWindow()
		if window.rois.has_key(name):
			window.rois[name].ShowName()
		
	def HideRoisNames(self):
		"""
		hide all rois labels
		"""
		window=self.app_window.mdi.activeWindow()
		for roi in window.rois.keys():
			window.rois[roi].HideName()
			
	def HideRoiName(self,name=''):
		"""
		hide the label of the roi called 'name' 
		"""
		window=self.app_window.mdi.activeWindow()
		if window.rois.has_key(name):
			window.rois[name].HideName()
		
	def SetActiveRoi(self,name=''):
		"""
		if existant, set the roi with a name of 'name' as the active one. Draws a red rectangle around it, and remove it on the old active one
		"""		
		window=self.app_window.mdi.activeWindow()
		if window.rois.has_key(name):
			window.activeRoi=window.rois[name]

			# if more than one roi : draw a red rectangle around the roi to view which one is the active one
			if len(window.rois)>1: 
				# erases old active roi border rectangles
				for obj in window.activeRoiHighlight:
					window.View.Drawable.EraseObject(obj)
					window.activeRoiHighlight.remove(obj)
				# create it on new active one
				ymin,ymax=0,window.View.Source[0].GetData().Pages[0].Array.shape[1]
				for xmin,xmax in window.activeRoi.limits:
					# create the highlight rectangle
					window.activeRoiHighlight.append(window.View.Drawable.PutRectangle(xmin,ymin,xmax,ymax,pen=Pen((255,0,0),2,"solid")))

				# erases others roi lablels
				self.HideRoisNames()
			# show the label of the active roi
			self.ShowRoiName(name)
			
	def GetActiveRoi(self):
		"""
		return the active roi
		"""
		window=self.app_window.mdi.activeWindow()
		return window.activeRoi
		
	def GetRois(self,parentWindow):
		"""
		return a sequence containing all the displayed roi
		"""
		#window=self.app_window.mdi.activeWindow()
		#if window.name[0:10]!='AzimInt - ': window=window.master_window
		window=self.app_window.GetWindow('AzimInt - '+ parentWindow.name)
		if window==None: 
			return []
		else:
			ret=[]
			for roi in window.rois.keys():
				ret.append(window.rois[roi])
			return ret
		
	# Roi mode
	def SetModeStateRoi(self,state,parentWindow):
		if state==0:
			self.DisableModeRoi()
		else:
			self.EnableModeRoi(parentWindow)
	
	def EnableModeRoi(self,parentWindow):
		# disable other selections
		if DEBUG: print 'In EnableModeRoi...'
		window=self.app_window.mdi.activeWindow()
		if window.View.ZoomSelect is not None:
			window.View.DisableModeZoom()

		if window.View.Select is None:
			window.View.MenuPopup.CheckItem(window.View.RoiMenuItem,1)
		
			window.activeMode='Roi'
			
			if (window.View.Source != ()):
				self._DestroySelect()
				data=window.View.Source[0].GetData()
				if data==None: return
				#print dir(ImageViewSelect)
				window.View.Select=Py4datDisplay.ViewSelectHRect(data,self.EventRoiSelection)
				#print window.View.Select
				window.View.Select.ConnectView(window.View)
		
	def DisableModeRoi(self):
		window=self.app_window.mdi.activeWindow()
		if window.View.Select is not None:
			#self.MenuPopup.UnselectItem(3)
			window.View.MenuPopup.CheckItem(window.View.RoiMenuItem,0)
			
			window.View.activeMode=None
			self._DestroySelect()
			
	def _DestroySelect(self):
		window=self.app_window.mdi.activeWindow()
		if window.View.Select is not None:
			window.View.Select.Erase(window.View)
			window.View.Select.Destroy()
			window.View.Select=None

    	############## AZIM INT ################################################
    
    	def AzimInt(self):
    		if DEBUG: print 'In Py4datTransformPlugin.AzimInt...'
		parentWindow=self.GetSourceWindow()
    		window=self.app_window.GetWindow('AzimInt - '+ parentWindow.name)
		if window is None:
    			window=ViewWindow (self.app_window.mdi,ExtendedImageView,name='AzimInt - '+ parentWindow.name,view_pars={"UseImageValues":1},master_window=parentWindow)
			window.SetTitle(None,prefix="AzimInt - ")
			self.app_window.Set2DViewMenu(window)
			window.View.AddMenuSeparator()
			window.View.RoiMenuItem=window.View.AddMenuPopupItem('Roi',Command.Command(self._SetRoi,parentWindow),'checkbutton')
			window.View.AddMenuPopupItem('Del Rois',Command.Command(self._DelAllRois,parentWindow))
			window.View.AddMenuPopupItem("I(Phi)",Command.Command(self.IPhi))
			window.View.AddMenuPopupItem("I(q)",Command.Command(self.Iq))
			window.rois={}
			window.activeRoi=None
			window.activeRoiHighlight=[]
			window.roiLimit_dnd=0 	# roi limit drag 'n' drop management mode
    		#print window.View.Source[0]

			#window.DataSelection=parentWindow.View.Source[0]
    		#window.Filter=ColormapFilter(None,AzimIntFilter(window.DataSelection,buffer_input=1))
			window.DataSelection=AzimIntFilter(parentWindow.View.Source[0],buffer_input=1)
			window.Filter=ColormapFilter(None,window.DataSelection)
    		
    		window.Filter.SetColormapParameters(parentWindow.View.GetColormapFilter().GetColormapParameters())
    		#print 'ROIs=',window.rois
		window.View.SetSource(window.Filter)
		#print 'ROIs=',window.rois

	################## INTEGRATE  I(Phi)################################################

	def IPhi(self):
		if DEBUG: print 'In Py4datTransformPlugin.IPhi...'
		#window=self.app_window.GetWindow('I(Phi) - '+ parentWindow.name)
		parentWindow=self.GetSourceWindow()
		AzimIntWindow=self.app_window.GetWindow('AzimInt - '+ parentWindow.name)
		window=self.app_window.GetWindow('I(Phi) - '+ AzimIntWindow.name)
		if (AzimIntWindow.View.Source!=()):
			if DEBUG: print 'In IPhi...'				
			if window is None:
    				window=ViewWindow (self.app_window.mdi,PyDVT.GraphView.GraphView,'I(Phi) - '+ AzimIntWindow.name,{"AddStyleSelect":1,"AddCursorSelect":1,"AddStatus":1,"AutoHideStatus":1},master_window=AzimIntWindow )
				window.SetTitle(None,prefix="I(Phi) - ")
				self.app_window.Set1DViewMenu(window)
				window.View.SetStyle("PointsLine")

				#window.View.AddMenuSeparator()
				#window.View.AddMenuPopupItem("Fit",self.Fit1d)
				
			window.DataSelection=parentWindow.View.Source[0]
			window.Filter=IntegratePhiFilter("1",AzimIntFilter(window.DataSelection),plugin=self,parentWindow=parentWindow)
			window.View.SetSource(window.Filter)
	
	################## FIT 1D ################################################
	################## I(q) ################################################
	
	def Iq(self):
		if DEBUG: print 'In Py4datTransformPlugin.Iq...'
		parentWindow=self.GetSourceWindow()
		print 'In Iq:',parentWindow.name
		window=self.app_window.GetWindow('I(q) - AzimInt - '+ parentWindow.name)
		AzimIntWindow=self.app_window.GetWindow('AzimInt - '+ parentWindow.name)
		if (parentWindow.View.Source!=()):
			if DEBUG: print 'I funtion of q...'
			if window is None:
				window=ViewWindow (self.app_window.mdi,PyDVT.GraphView.GraphView,'I(q) - '+ AzimIntWindow.name,{"AddStyleSelect":1,"AddCursorSelect":1,"AddStatus":1,"AutoHideStatus":1},master_window=AzimIntWindow)
				window.SetTitle(None,prefix="I(q) - ")
				self.app_window.Set1DViewMenu(window)
				window.View.SetStyle("PointsLine")
			window.DataSelection=parentWindow.View.Source[0]
			window.Filter=IntegrateQFilter("1",AzimIntFilter(window.DataSelection),pen=Pen((0,128,0),0,"solid"))
			window.View.SetSource(window.Filter)

	################## Stack Save I(Phi) ################################################
	
	def GetSourceWindow(self):
		window=self.app_window.mdi.activeWindow()
		while window.master_window!=None:
			window=window.master_window
		return window
		
	def StackSaveIPhi(self):
		window=self.GetSourceWindow()
		if self.GetRois(window)==[]: print 'Do AzimInt to select ROIs !'
		elif len(self.GetRois(window))!=3: print 'You must select 3 ROIs before integrate !'
		else:	
			print self.GetRois(window)[0].limits[0],self.GetRois(window)[1].limits[0],self.GetRois(window)[2].limits[0]
			if window.shortName=='Stack':
				image=0
				print 'fileName=',window.fileName
				while image < window.NumImages:
					#self.IPhi(window)
					data=EdfFileData.EdfFileData()
					data.SetSource(window.fileName[image])
					data.LoadSource()
					#print 'Info:',data.GetSourceInfo()
					#print 'nb pages:',data.GetNumberPages()
					groupNode=DataWrapper.DataToGroupNode(data,'groupNode')
					datasetnode=groupNode.getChild('page0')
					AzimIntDataSetNode=AzimInt.AzimIntDataSetNode(datasetnode) 	
					#WriteEdfFile.WriteEdfFile('AzimInt'+str(image)+'.edf',AzimIntDataSetNode)
					Limits = [self.GetRois(window)[0].limits[0],self.GetRois(window)[1].limits[0],self.GetRois(window)[2].limits[0]]
					Limits.sort()
					ROI=Limits[1]
					BKG1=Limits[0]
					BKG2=Limits[2]
					AzimIntDataSetNode.setAttribute('ROI1',ROI)
					AzimIntDataSetNode.setAttribute('ROI0',BKG1)
					AzimIntDataSetNode.setAttribute('ROI2',BKG2)
					IntDataSetNode=Integration.IntegrationDataSetNode(AzimIntDataSetNode)
					groupnode=DefaultGroupNode('')
					groupnode.insertChild(IntDataSetNode)
					name=string.split(window.fileName[image],'/')[-1]
					WriteHdf5File.WriteHdf5File('IPhi'+str(image)+'_'+name[0:-4]+'.hdf5',groupnode)
					image=image+1
		
			
plugin=Py4datTransformPlugin()
