"""
	DrawableTable.py
	Table displaying widget
		
"""

from PyDVT import __version__,__date__,__author__


from TableWidget import TableWidget

class  Drawable_Table(TableWidget):
    def __init__( self, parent=None, vertical_header=1, horizontal_header=1):
        # OK ?
        TableWidget.__init__( self, parent,cellsCnf={'cellsType':'Text','cellsOptions':{'height':1,'width':7,'bd':2}})

        if not vertical_header:
            self.hideRowTitles()
        if not horizontal_header:
            self.hideColumnTitles()
        self.Data=None
        self.myparent=parent

    def Show(self):
       self.pack(expand=1,fill='both')
       self.show()

    def SetData(self,data=None,h_header=None,v_header=None):
        self.Data=data
        if data is not None:
            self.SetRows(data.shape[0])
            self.SetCols(data.shape[1])

            if v_header is not None:
                for i in range(len(v_header)):
                    self.SetVHeaderText(i,str(v_header[i]))

            if h_header is not None:
                for i in range(len(h_header)):
                    self.SetHHeaderText(i,str(h_header[i]))
                    
            self._fillTable()
        else:
            self.SetRows(0)
            self.SetCols(0)

    def _fillTable(self):
        
        for i in range(self.getNbrOfRows()):
            for j in range(self.getNbrOfCols()):
                self.SetText(i,j,str(self.Data[i,j]))

    def SetRows(self,rows):
        for i in range(self.getNbrOfRows(),rows):
            self.addRow(rowName="",rowTitleCnf={'bg':'light blue','bd':2,'relief':'groove'}, cellsCnf={'cellsType':'Text','cellsOptions':{'height':1,'width':7,'bd':2}})
        for i in range(rows,self.getNbrOfRows()):
            self.delRow(i)

    def SetCols(self,cols):
        for i in range(self.getNbrOfCols(),cols):
            self.addColumn(columnName="", colTitleCnf={'bg':'light blue','bd':2,'relief':'groove'},cellsCnf={'cellsType':'Text','cellsOptions':{'height':1,'width':7,'bd':2}})
        for i in range(cols,self.getNbrOfCols()):
            self.delColumn(i)

    def SetText(self,row,col,text):
        txt=self.getCellWidget(col,row)
        txt.delete(1.0,'end')
        txt.insert('end',text)

    def SetHHeaderText(self,col,text):
        self.setColumnName(col,text)
        
    def SetVHeaderText(self,row,text):
        self.setRowName(row,text)

    def MergeCells(self,row,col,rowspan,colspan):
        ###TODO MergeCells in Tk
        pass

    def AdjustColumn(self,col):
        self.uniformizeCellSize()

    def contentsMousePressEvent(self, e):		
        pass

    def contentsMouseDoubleClickEvent(self,e):	   
        pass

    def contentsMouseReleaseEvent(self,e):
        pass

    def contentsMouseMoveEvent(self,e):	   
        pass

    def keyPressEvent(self,e):
        #TODO: Not working: table doesn't have input focus
        ret=str(e.char)
        if ret=="":
            ret= e.keycode
        self.parent._KeyPress(ret)

    def GetViewport(self):
        return self

