import Pmw
import Tkinter as Tk
import Selector
import tkColorChooser


# ----------------------------------------------------------
# 		PROPERTIES DIALOG
# ----------------------------------------------------------
class PropertiesDialog(Tk.Toplevel):
    def __init__(self, parent, title=None):
	Tk.Toplevel.__init__(self, parent)
	#self.transient(parent)
	if title: self.title(title)

	self.parent	= parent
	self.destroyed	= 0
	
	body	= Tk.Frame(self)
	focus	= self.body(body)
	body.pack(padx=5, pady=5)

	self.buttonbox()

	self.protocol("WM_DELETE_WINDOW", self.close)
        self.geometry("+%d+%d" % (parent.winfo_rootx()+50,
                                  parent.winfo_rooty()+50))

        if focus is not None:
	    focus.focus_set()

    def body(self, master):
	pass

    def buttonbox(self):
	box= Tk.Frame(self)
	Tk.Button(box, text='Default', command=self.default).pack(side='left', padx=5, pady=5)
	Tk.Button(box, text='Close', command=self.close).pack(side='left', padx=5, pady=5)
	Tk.Button(box, text='Apply', command=self.apply).pack(side='left', padx=5, pady=5)
	box.pack()

    def close(self):
	self.parent.focus_set()
	self.destroyed= 1
	self.destroy()

    def apply(self):
	pass

    def default(self):
	pass


# ----------------------------------------------------------
# 		ELEMENT PROPERTIES
# ----------------------------------------------------------
class ElementProperties(PropertiesDialog):
    def __init__(self, parent, elements, eltname=None):
	self.elements= elements
	self.eltkeys= elements.keys()
	self.eltname= eltname
	if self.eltname is None:
	    self.eltname= self.elements.keys()[0]

	PropertiesDialog.__init__(self, parent, title='Element properties')

    def body(self, master):
	lb= Tk.Label(master, text='Graph Element:')
	lb.grid(row=0, column=0, sticky='e')
	self.eltchoice= Selector.Selector(master, self.eltkeys, command= self.select)
	self.eltchoice.grid(row=0, column=1, sticky='w')

	sep= Tk.Frame(master, bd=2, relief='ridge', bg='black')
	sep.grid(row=1, column=0, columnspan=2,sticky='ensw')

	lb= Tk.Label(master, text='Symbol')
	lb.grid(row=2, column=0, sticky='w')
	self.all_symbols= ['circle', 'square', 'diamond', 'plus', 'cross', 'splus', 'scross', 'triangle', 'no symbol']
	self.symbol= Selector.Selector(master, self.all_symbols)
	self.symbol.grid(row=2, column=1, sticky='ew')

	lb= Tk.Label(master, text='Color')
	lb.grid(row=3, column=0, sticky='w')
	self.color= Tk.Button(master, command=self.__askcolor, width=10)
	self.color.grid(row=3, column=1, sticky='ew')

	self.eltchoice.show_item(self.eltname)

    def __askcolor(self):
	newcolor= tkColorChooser.askcolor(color=self.color.cget('background'))
	self.color.configure(bg=newcolor[1])
	
    def show(self, eltname):
	#self.iconify()
	#self.deiconify()
	self.focus_set()
	self.eltchoice.show_item(eltname)

    def select(self, eltname=None):
	self.eltname= eltname
	properties= self.elements[self.eltname].getconfig()
	self.symbol.show_item(properties['symbol'])
	self.color.configure(bg=properties['color'])

    def apply(self):
	elt= self.elements[self.eltname]
	symbol= self.symbol.value.get()
	if symbol=='no symbol':
	    elt['symbol']= ''
	else:
	    elt['symbol']= symbol
	color= self.color.cget('background')
	elt['color']= color

    def default(self):
	elt= self.elements[self.eltname]
	elt.setconfig(elt.default)
	self.select(self.eltname)
	


def test():
    x = range(10)
    y1= range(10)
    y2= range(0, 20, 2)
    y3= range(0, 30, 3)

    root= Tk.Tk()
    g = BltGraph(root)
    g.setx('x', x)
    g.sety('x', 'y1', y1)
    g.sety('x', 'y2', y2)
    g.sety('x', 'y3', y3)
    g.pack()

    g.crosshairs.toggle()
    g.gridlines.setconfig({'hide':0})

    ycnf= g.elements['y1'].getconfig()
    ycnf['dashes']= 5
    ycnf['symbol']= 'triangle'
    g.elements['y1'].setconfig(ycnf)

    #d = GraphDialog(root, 'test')    

    root.mainloop()


if __name__=='__main__':
    test()
