"""
    BinarySearch.py
    Performs binary search over NumPy arrays.
    Needed because NumPy's searchsorted function just searches ascending arrays.
        
"""

from PyDVT import __version__,__date__,__author__


def BinarySearch(array,value,len=None):
    if len==None or len>array.shape[0]: len=array.shape[0]
    #Ascending
    bottom = 0
    if len==0: return 0
    top = len -1    
    if array[top]>=array[0]:
        if value<array[0]: return 0
        while bottom < top: 
            middle = (top + bottom) / 2 
            if array [middle] < value: bottom = middle + 1 
            elif array [middle] > value: top = middle - 1 
            else: return middle 
        if array [bottom] > value: return bottom 
        else: return bottom + 1
    #Descending
    else:
        if value>array[0]: return 0
        while bottom < top: 
            middle = (top + bottom) / 2 
            if array [middle] > value: bottom = middle + 1 
            elif array [middle] < value: top = middle - 1 
            else: return middle
        #if array [top] <= value: return top 
        #else: return top + 1
        if array [bottom] <= value: return bottom 
        else: return bottom + 1
            