from numarrayall import *

numarray_nonzero = nonzero

def nonzero(a):
    """nonzero() returns either an index array or a tuple of index
    arrays corresponding to the indices where the values of an array
    are not equal to zero.

    This is the Numeric compatible version of nonzero() supplied by
    numarray.numeric.  It differs from numarray.nonzero() in the
    handling of 1D arrays.  numarray.nonzero() always returns a tuple;
    Numeric.nonzero() returns a tuple when the number of dimensions of
    the array is not one.
    """
    nz = numarray_nonzero(a)
    if len(nz) > 1:
        return nz
    elif len(nz) == 1:
        return nz[0]
    else:
        return nz
