import numarrayall as num

def BIT(x):
    return num.array([(1 << x)], type=num.Int32)

POS_QUIET_NAN     = BIT(0)
NEG_QUIET_NAN     = BIT(1)
POS_SIGNAL_NAN    = BIT(2)
NEG_SIGNAL_NAN    = BIT(3)
POS_INFINITY      = BIT(4)
NEG_INFINITY      = BIT(5)
POS_DENORMALIZED  = BIT(6)
NEG_DENORMALIZED  = BIT(7)
POS_NORMALIZED    = BIT(8)
NEG_NORMALIZED    = BIT(9)
POS_ZERO          = BIT(10)
NEG_ZERO          = BIT(11)
INDETERM          = BIT(12)
BUG               = BIT(15)

NAN = POS_QUIET_NAN | NEG_QUIET_NAN | POS_SIGNAL_NAN | NEG_SIGNAL_NAN | INDETERM
INFINITY = POS_INFINITY | NEG_INFINITY
SPECIAL = NAN | INFINITY

NORMALIZED = POS_NORMALIZED | NEG_NORMALIZED
DENORMALIZED = POS_DENORMALIZED | NEG_DENORMALIZED
ZERO = POS_ZERO | NEG_ZERO
NUMBER = NORMALIZED | DENORMALIZED | ZERO

def mask(a, m):
    """mask(a, m) returns the values of 'a' satisfying category 'm'.
    mask does a parallel check for values which are not classifyable
    by the categorization code, raising a RuntimeError exception if
    any are found.
    """
    f = num.ieeemask(a, m)
    g = num.ravel(num.ieeemask(a, BUG))
    if num.bitwise_or.reduce(g) != 0:
        raise RuntimeError("Unclassifyable floating point values.")
    return f

def index(a, msk):
    """index returns the tuple of indices where the values satisfy 'mask'"""
    return num.nonzero(mask(a, msk))

def getinf(a):
    """getinf returns the tuple of indices where the values are infinite"""
    return index(a, INFINITY)

def setinf(a, value):
    """setinf sets the elements of a which are infinite to 'value' instead."""
    num.put(a, getinf(a), value)

def getnan(a):
    """getnan returns the tuple of indices where the values are not-a-numbers"""
    return index(a, NAN)

def setnan(a, value):
    """setnan sets the elements of a which are NANs to 'value' instead."""
    num.put(a, getnan(a), value)

def getbug(a):
    """getbug returns the indices where the values are not classifyable."""
    return index(a, BUG)

