#!/usr/bin/env python


import sys
import os
import os.path
from qt import QApplication, QTranslator, QTextCodec, SIGNAL, SLOT

from Config import ConfigUILanguage


if __name__ == '__main__':
    app = QApplication(sys.argv)

    # We can only import these after creating the QApplication because they
    # make Qt calls that need the QApplication to exist.
    from HelpWindow import HelpWindow

    # Use the program on the command line if one was given.
    qtdir = os.getenv("QTDIR")
    
    try:
        home = sys.argv[1]
    except:
        if qtdir is not None:
            home = os.path.normpath(qtdir + '/doc/html/index.html')
        else:
            home = None
    
    # Load translation files and install them
    loaded = 0
    if ConfigUILanguage is None:
        loc = unicode(QTextCodec.locale())
    else:
        loc = ConfigUILanguage
        
    # get the path to the python installation
    if sys.platform == "win32":
        ericDir = sys.prefix + "\\Lib\\site-packages\\eric"
    else:
        vl = sys.version.split()[0].split('.')
        ericDir = sys.prefix + "/lib/python" + vl[0] + "." + vl[1] + "/site-packages/eric"
        
    # 1) load translations for qt
    qtTrans = QTranslator(None)
    qtdir = os.getenv("QTDIR")
    # try Qt installation first
    if qtdir is not None:
        loaded = qtTrans.load("qt_" + loc,
                    qtdir + os.sep + "translations")
    # try in our installation if not found
    if not loaded:
        loaded = qtTrans.load("qt_" + loc, ericDir)
    # try in current directory if still not found
    if not loaded:
        loaded = qtTrans.load("qt_" + loc, ".")
    # install it if successful
    if loaded:
        app.installTranslator(qtTrans)
    else:
        print "helpviewer: no translations for Qt found"
        
    # 2) load translations for eric
    ericTrans = QTranslator(None)
    loaded = qtTrans.load("eric_" + loc, ".")
    # try in our installation if not found
    if not loaded:
        loaded = qtTrans.load("eric_" + loc, ericDir)
    # install it if successful
    if loaded:
        app.installTranslator(ericTrans)
    else:
        print "helpviewer: no translations for helpviewer found."
        print "Please contact the Detlev Offenbach <detlev@die-offenbachs.de>."
    
    help = HelpWindow(home, '.', None, 'help viewer')
    help.setCaption('Helpviewer')

    app.setMainWidget(help)
    if QApplication.desktop().width() > 400 and \
       QApplication.desktop().height() > 500:
        help.show()
    else:
        help.showMaximized()

    app.connect(app, SIGNAL('lastWindowClosed()'),
                app, SLOT('quit()'))
    app.exec_loop()
