#!/usr/bin/env python


import sys
import os
from qt import QApplication, QTranslator, QTextCodec

from Config import ConfigUILanguage

qtTrans = None
ericTrans = None


if __name__ == '__main__':
    app = QApplication(sys.argv)

    # We can only import these after creating the QApplication because they
    # make Qt calls that need the QApplication to exist.
    from DebugServer import DebugServer
    from UserInterface import UserInterface

    # Use the program on the command line if one was given.
    try:
        prog = sys.argv[1]
    except:
        prog = None

    # Load translation files and install them
    loaded = 0
    if ConfigUILanguage is None:
        loc = unicode(QTextCodec.locale())
    else:
        loc = ConfigUILanguage
    
    # get the path to the python installation
    if sys.platform == "win32":
        ericDir = sys.prefix + "\\Lib\\site-packages\\eric"
    else:
        vl = sys.version.split()[0].split('.')
        ericDir = sys.prefix + "/lib/python" + vl[0] + "." + vl[1] + "/site-packages/eric"
        
    # 1) load translations for qt
    qtTrans = QTranslator(None)
    qtdir = os.getenv("QTDIR")
    # try Qt installation first
    if qtdir is not None:
        loaded = qtTrans.load("qt_" + loc,
                    qtdir + os.sep + "translations")
    # try in our installation if not found
    if not loaded:
        loaded = qtTrans.load("qt_" + loc, ericDir)
    # try in current directory if still not found
    if not loaded:
        loaded = qtTrans.load("qt_" + loc, ".")
    # install it if successful
    if loaded:
        app.installTranslator(qtTrans)
    else:
        print "eric: no translations for Qt found"
        
    # 2) load translations for eric
    ericTrans = QTranslator(None)
    loaded = qtTrans.load("eric_" + loc, ".")
    # try in our installation if not found
    if not loaded:
        loaded = qtTrans.load("eric_" + loc, ericDir)
    # install it if successful
    if loaded:
        app.installTranslator(ericTrans)
    else:
        print "eric: no translations for eric found."
        print "Please contact the Detlev Offenbach <detlev@die-offenbachs.de>."
    
    dbs = DebugServer()
    mw = UserInterface(dbs,prog)
    app.setMainWidget(mw)
    mw.show()

    app.exec_loop()
