# Copyright (c) 2000 Phil Thompson <phil@river-bank.demon.co.uk>
# Copyright (c) 2002 Detlev Offenbach <detlev@die-offenbachs.de>


from qt import QPixmap, QFileDialog, QFileIconProvider


# Convert all the XPM icons to QPixmaps.

IconNewWindowXPM = [
    "22 22 11 1",
    ". c None",
    "# c #000000",
    "c c #000080",
    "b c #0000ff",
    "d c #585858",
    "g c #a0a0a0",
    "i c #c0c000",
    "a c #c3c3c3",
    "h c #ffff00",
    "f c #ffffc0",
    "e c #ffffff",
    "......................",
    "......................",
    "......................",
    "...################...",
    "...#aabcbbccbcccaa#...",
    "...#aabbbbcbccccaa#...",
    "...#dddddddddddddd#...",
    "...#eeeeeeeeeeeeee#...",
    "...#eeeeeeeeeefefe#...",
    "...#eeeeeeeeeeeeef#...",
    "...#eeeeeefefgfefe#...",
    "...#eeeeeegfeghegf#...",
    "...#eeeeeefghihihe#...",
    "...#eeeeeeeeifffif#...",
    "...#eefefgfhhfefhhf...",
    "...#########ifffi##...",
    "...........#hihih.....",
    "..........#f.#h.#f....",
    ".............#f.......",
    "......................",
    "......................",
    "......................"
]

IconNewWindow = QPixmap(IconNewWindowXPM)


IconOpenXPM = [
    '22 22 5 1',
    '  c Gray100',
    '. c Yellow',
    'X c #848200',
    'o c Gray0',
    'O c None',
    'OOOOOOOOOOOOOOOOOOOOOO',
    'OOOOOOOOOOOOOOOOOOOOOO',
    'OOOOOOOOOOOOOOOOOOOOOO',
    'OOOOOOOOOOOOooooOOOOoO',
    'OOOOOOOOOOOoOOOOooOooO',
    'OOOOOOOOOOOOOOOOOOoooO',
    'OOOOOOOOOOOOOOOOOooooO',
    'OooooOOOOOOOOOOOoooooO',
    'o. . ooooooooooOOOOOOO',
    'o . . . . . . oOOOOOOO',
    'o. . . . . . .oOOOOOOO',
    'o . . . . . . oOOOOOOO',
    'o. . . ooooooooooooooo',
    'o . . ooXXXXXXXXXXXXoo',
    'o. . ooXXXXXXXXXXXXooO',
    'o . ooXXXXXXXXXXXXooOO',
    'o. ooXXXXXXXXXXXXooOOO',
    'o ooXXXXXXXXXXXXooOOOO',
    'oooXXXXXXXXXXXXooOOOOO',
    'ooXXXXXXXXXXXXooOOOOOO',
    'oooooooooooooooOOOOOOO',
    'OOOOOOOOOOOOOOOOOOOOOO'
]

IconOpen = QPixmap(IconOpenXPM)


IconPrintXPM = [
    "22 22 10 1",
    ". c None",
    "a c #000000",
    "f c #303030",
    "d c #404000",
    "# c #585858",
    "g c #808080",
    "e c #a0a0a0",
    "c c #c3c3c3",
    "h c #ffdca8",
    "b c #ffffff",
    "......................",
    "......................",
    "......................",
    "...........#a#........",
    "..........#bbc#a......",
    ".........dbbbbbbe#....",
    ".........#bbbbbbbea...",
    ".......a#bbbbbbbbfa...",
    "......agcbbbbbbbega...",
    ".....ae#bhbhbbbb#a....",
    "....aeee##hbhbhea#....",
    "...aeeeeee###hbf#a....",
    "...a..eeeeeee###eea...",
    "...a......eeeeeee#a...",
    "...a.........eee##a...",
    "....aa#........###a...",
    ".......aa#.....##a....",
    "..........aa#..#a.....",
    ".............aaa......",
    "......................",
    "......................",
    "......................"
]

IconPrint = QPixmap(IconPrintXPM)


IconCloseXPM = [
    "22 22 3 1",
    ". c None",
    "# c #000000",
    "a c #ffffff",
    "......................",
    "......................",
    "......................",
    "........#####.........",
    "......#########.......",
    ".....###########......",
    "....##aa#####aa##.....",
    "....##aaa###aaa##.....",
    "...####aaa#aaa####....",
    "...#####aaaaa#####....",
    "...######aaa######....",
    "...#####aaaaa#####....",
    "...####aaa#aaa####....",
    "....##aaa###aaa##.....",
    "....##aa#####aa##.....",
    ".....###########......",
    "......#########.......",
    "........#####.........",
    "......................",
    "......................",
    "......................",
    "......................"
]

IconClose = QPixmap(IconCloseXPM)


IconExitXPM = [
    "22 22 4 1",
    ". c None",
    "# c #000000",
    "b c #303030",
    "a c #757575",
    "......................",
    "......................",
    "..........##..........",
    "..........##..........",
    "......#...##...#......",
    ".....###..##..###.....",
    "....a##a..##..a##a....",
    "....##b...##...b##....",
    "...a##a...##...a##a...",
    "...###....##....###...",
    "...##a....##....a##...",
    "...##a....##....a##...",
    "...###....##....###...",
    "...a##a........a##a...",
    "....##b........b##....",
    "....a##ba....ab##a....",
    ".....a####aa####a.....",
    "......a########a......",
    "........a####a........",
    "......................",
    "......................",
    "......................"
]

IconExit = QPixmap(IconExitXPM)


IconWhatsThisXPM = [
    '16 16 3 1',
    '   c None',
    'o  c #000000',
    'a  c #000080',
    'o        aaaaa  ',
    'oo      aaa aaa ',
    'ooo    aaa   aaa',
    'oooo   aa     aa',
    'ooooo  aa     aa',
    'oooooo  a    aaa',
    'ooooooo     aaa ',
    'oooooooo   aaa  ',
    'ooooooooo aaa   ',
    'ooooo     aaa   ',
    'oo ooo          ',
    'o  ooo    aaa   ',
    '    ooo   aaa   ',
    '    ooo         ',
    '     ooo        ',
    '     ooo        '
]

IconWhatsThis = QPixmap(IconWhatsThisXPM)


IconDirOpenXPM = [
    '16 16 6 1',
    '. c None',
    'b c #ffff00',
    'd c #000000',
    '* c #999999',
    'c c #cccccc',
    'a c #ffffff',
    '................',
    '................',
    '...*****........',
    '..*aaaaa*.......',
    '.*abcbcba******.',
    '.*acbcbcaaaaaa*d',
    '.*abcbcbcbcbcb*d',
    '*************b*d',
    '*aaaaaaaaaa**c*d',
    '*abcbcbcbcbbd**d',
    '.*abcbcbcbcbcd*d',
    '.*acbcbcbcbcbd*d',
    '..*acbcbcbcbb*dd',
    '..*************d',
    '...ddddddddddddd',
    '................'
]

IconDirOpen = QPixmap(IconDirOpenXPM)


IconDirClosedXPM = [
    '16 16 6 1',
    '. c None',
    'b c #ffff00',
    'd c #000000',
    '* c #999999',
    'a c #cccccc',
    'c c #ffffff',
    '................',
    '................',
    '..*****.........',
    '.*ababa*........',
    '*abababa******..',
    '*cccccccccccc*d.',
    '*cbababababab*d.',
    '*cabababababa*d.',
    '*cbababababab*d.',
    '*cabababababa*d.',
    '*cbababababab*d.',
    '*cabababababa*d.',
    '*cbababababab*d.',
    '**************d.',
    '.dddddddddddddd.',
    '................'
]

IconDirClosed = QPixmap(IconDirClosedXPM)


IconFilePythonXPM = [
    '16 15 7 1',
    '. c #000000',
    '# c #00ff00',
    'a c #ff0000',
    'b c None',
    'c c #ffff00',
    'd c #808000',
    'e c #0000ff',
    'bbbbb..bbbbbbbbb',
    'bbbb.ddbbbbbbbbb',
    'bbbb...dbbbbbbbb',
    'bbbbc.e.bbbbbbbb',
    'bbbb.d.d.bbbbbbb',
    'b.ddddddd.dbbbbb',
    'b.dddd###.dbbbbb',
    'bbb###.#d##bbbbb',
    'bbb.a.##d##bbbbb',
    'bbbabb.b##dbbbbb',
    'bbbbbbb#ddbbbbbb',
    'bbbb.d#dd..b.bbb',
    'bbbb.#dd.ddbd..b',
    'bbbb##ddddddbbbb',
    'bbbbbd##b##bbbbb'
]

IconFilePython = QPixmap(IconFilePythonXPM)


IconFileMiscXPM = [
    '16 16 5 1',
    '. c #7f7f7f',
    '# c None',
    'c c #000000',
    'b c #bfbfbf',
    'a c #ffffff',
    '################',
    '..........######',
    '.aaaaaaaab.#####',
    '.aaaaaaaaba.####',
    '.aaaaaaaacccc###',
    '.aaaaaaaaaabc###',
    '.aaaaaaaaaabc###',
    '.aaaaaaaaaabc###',
    '.aaaaaaaaaabc###',
    '.aaaaaaaaaabc###',
    '.aaaaaaaaaabc###',
    '.aaaaaaaaaabc###',
    '.aaaaaaaaaabc###',
    '.aaaaaaaaaabc###',
    '.bbbbbbbbbbbc###',
    'ccccccccccccc###'
]

IconFileMisc = QPixmap(IconFileMiscXPM)


IconRunXPM = [
    "22 22 2 1",
    ". c None",
    "# c #0000c0",
    "......................",
    "......................",
    "......................",
    "......................",
    ".............#........",
    ".............##.......",
    ".............###......",
    "........#########.....",
    ".......#.....###......",
    "......#......##.......",
    ".....#.......#........",
    ".....#................",
    ".....#................",
    ".....#................",
    "......#...............",
    ".......#..............",
    "........####..........",
    "......................",
    "......................",
    "......................",
    "......................",
    "......................"
]

IconRun = QPixmap(IconRunXPM)


IconContinueXPM = [
    "22 22 2 1",
    ". c None",
    "# c #0000c0",
    "......................",
    "......................",
    "......................",
    "........#.............",
    "........##............",
    "........###...........",
    "....########...###....",
    "...#....###.......#...",
    "..#.....##.........#..",
    ".#......#...........#.",
    ".#..................#.",
    ".#..................#.",
    ".#...........#......#.",
    "..#.........##.....#..",
    "...#.......###....#...",
    "....###...########....",
    "...........###........",
    "............##........",
    ".............#........",
    "......................",
    "......................",
    "......................"
]

IconContinue = QPixmap(IconContinueXPM)


IconStepXPM = [
    "22 22 3 1",
    ". c None",
    "a c #000000",
    "# c #0000c0",
    "......................",
    "......................",
    "......................",
    "....######............",
    "...#..................",
    "..#......aaaaaaaaaaa..",
    "..#....#..............",
    "...#...##.............",
    "....######..aaaaaaaa..",
    ".......##.............",
    ".......#..............",
    "............aaaaaaaa..",
    "......................",
    "......................",
    "............aaaaaaaa..",
    "......................",
    "......................",
    ".........aaaaaaaaaaa..",
    "......................",
    "......................",
    "......................",
    "......................"
]

IconStep = QPixmap(IconStepXPM)


IconStepOverXPM = [
    "22 22 3 1",
    ". c None",
    "a c #000000",
    "# c #0000c0",
    "......................",
    "....######............",
    "...#..................",
    "..#......aaaaaaaaaaa..",
    "..#...................",
    "..#...................",
    "..#.........aaaaaaaa..",
    "..#...................",
    "..#...................",
    "..#.........aaaaaaaa..",
    "..#...................",
    "..#...................",
    "..#.........aaaaaaaa..",
    "..#...................",
    "..#...................",
    "..#......aaaaaaaaaaa..",
    "..#....#..............",
    "...#...##.............",
    "....######............",
    ".......##.............",
    ".......#..............",
    "......................"
]

IconStepOver = QPixmap(IconStepOverXPM)


IconStepOutXPM = [
    "22 22 3 1",
    ". c None",
    "a c #000000",
    "# c #0000c0",
    "......................",
    "......................",
    ".......#..............",
    ".......##.............",
    "....######............",
    "...#...##.............",
    "..#....#..............",
    "..#......aaaaaaaaaaa..",
    "..#...................",
    "...#..................",
    "....######..aaaaaaaa..",
    "......................",
    "......................",
    "............aaaaaaaa..",
    "......................",
    "......................",
    "............aaaaaaaa..",
    "......................",
    "......................",
    ".........aaaaaaaaaaa..",
    "......................",
    "......................"
]

IconStepOut = QPixmap(IconStepOutXPM)


IconStepQuitXPM = [
    "22 22 3 1",
    ". c None",
    "a c #0000c0",
    "# c #ff0000",
    "......................",
    "......................",
    "......................",
    "...#..............#...",
    "....#........a...#....",
    ".....#.......aa.#.....",
    "......#......aa#......",
    ".......#aaaaaa#aa.....",
    ".......a#....#aa......",
    "......a..#..#aa.......",
    ".....a....##.a........",
    ".....a....##..........",
    ".....a...#..#.........",
    ".....a..#....#........",
    "......a#......#.......",
    "......#a.......#......",
    ".....#..aaaa....#.....",
    "....#............#....",
    "...#..............#...",
    "......................",
    "......................",
    "......................"
]

IconStepQuit = QPixmap(IconStepQuitXPM)


IconBreakXPM = [
    '19 17 3 1',
    ' 	c None',
    '_	c #ffffff',
    '# 	c #ff0000',
    '                   ',
    '      #######      ',
    '     #########     ',
    '    ###########    ',
    '   #############   ',
    '  ###############  ',
    '  #_________#___#  ',
    '  #_###_#_#_#_#_#  ',
    '  #___#_#_#_#_#_#  ',
    '  ###_#_#_#_#___#  ',
    '  #___#_#___#_###  ',
    '  ###############  ',
    '   #############   ',
    '    ###########    ',
    '     #########     ',
    '      #######      ',
    '                   '
]

IconBreak = QPixmap(IconBreakXPM)


IconCBreakXPM = [
    '19 17 3 1',
    ' 	c None',
    '_	c #ffffff',
    '# 	c #008000',
    '                   ',
    '      #######      ',
    '     #########     ',
    '    ###########    ',
    '   #############   ',
    '  ###############  ',
    '  #_________#___#  ',
    '  #_###_#_#_#_#_#  ',
    '  #___#_#_#_#_#_#  ',
    '  ###_#_#_#_#___#  ',
    '  #___#_#___#_###  ',
    '  ###############  ',
    '   #############   ',
    '    ###########    ',
    '     #########     ',
    '      #######      ',
    '                   '
]

IconCBreak = QPixmap(IconCBreakXPM)


IconUnittestXPM = [
    "22 22 3 1",
    ". c None",
    "# c #0000c0",
    "a c #ff0000",
    "......................",
    "......................",
    "......................",
    "..##......aaaaaaaaaa..",
    "..##......#aaaaaaaaa..",
    "..##......##..aa......",
    "..##......##..aa......",
    "..##......##..aa......",
    "..##......##..aa......",
    "..##......##..aa......",
    "..##......##..aa......",
    "..##......##..aa......",
    "..##......##..aa......",
    "..##......##..aa......",
    "...##....##...aa......",
    "...##....##...aa......",
    "....######....aa......",
    ".....####.....aa......",
    "......................",
    "......................",
    "......................",
    "......................"
]

IconUnittest = QPixmap(IconUnittestXPM)


IconDesignerXPM = [
    "22 22 14 1",
    ". c None",
    "# c #000000",
    "k c #161616",
    "d c #202000",
    "i c #404000",
    "a c #505000",
    "j c #707000",
    "c c #808000",
    "f c #888828",
    "h c #909000",
    "b c #a0a000",
    "g c #a8a828",
    "l c #b0b000",
    "e c #c0c000",
    "......................",
    "......................",
    "......................",
    "........#.............",
    ".........#............",
    ".........##...........",
    "..........###.........",
    "..........##..........",
    "...#....####..........",
    "....##..##.##.........",
    ".....####.#.#.........",
    "......####..####......",
    "......#..####abcd.....",
    "...........#aeefg#....",
    "...........#geh#hi....",
    "...........#cf##jk....",
    "............dlhj##....",
    ".............#id##....",
    "..................#...",
    "......................",
    "......................",
    "......................"
]

IconDesigner = QPixmap(IconDesignerXPM)


IconFileDesignerXPM = [
    "16 16 14 1",
    ". c None",
    "# c #000000",
    "k c #161616",
    "d c #202000",
    "i c #404000",
    "a c #505000",
    "j c #707000",
    "c c #808000",
    "f c #888828",
    "h c #909000",
    "b c #a0a000",
    "g c #a8a828",
    "l c #b0b000",
    "e c #c0c000",
    ".....#..........",
    "......#.........",
    "......##........",
    ".......###......",
    ".......##.......",
    "#....####.......",
    ".##..##.##......",
    "..####.#.#......",
    "...####..####...",
    "...#..####abcd..",
    "........#aeefg#.",
    "........#geh#hi.",
    "........#cf##jk.",
    ".........dlhj##.",
    "..........#id##.",
    "...............#"
]

IconFileDesigner = QPixmap(IconFileDesignerXPM)


IconLinguistXPM = [
    "22 22 17 1",
    ". c None",
    "# c #000000",
    "b c #000080",
    "f c #0000c0",
    "e c #0000ff",
    "c c #004040",
    "g c #00c0c0",
    "a c #303030",
    "h c #400000",
    "k c #c05800",
    "d c #c0c0ff",
    "j c #ff0000",
    "n c #ff00ff",
    "m c #ffdca8",
    "l c #ffff00",
    "o c #ffffc0",
    "i c #ffffff",
    "......................",
    "......................",
    "......................",
    ".........####.........",
    "........####..........",
    ".......##ab....#......",
    "......#bac###.#d#.....",
    ".....##aaacef#d#gh....",
    ".....#aaaeaai###d#....",
    "....#aaabaeiii###gh...",
    "....##a###ii.i#d###...",
    "...##j#ii#i.i.i#......",
    "...#kj##i#jiiij##.....",
    "...#jjk##jkjijkkj#h...",
    "...##lmllmlljjnjk##...",
    "....##a#lmlol#a###....",
    "......###lml#.........",
    "........######........",
    "..........#####.......",
    "......................",
    "......................",
    "......................"
]

IconLinguist = QPixmap(IconLinguistXPM)


IconFileLinguistXPM = [
    "16 16 17 1",
    ". c None",
    "# c #000000",
    "b c #000080",
    "f c #0000c0",
    "e c #0000ff",
    "c c #004040",
    "g c #00c0c0",
    "a c #303030",
    "h c #400000",
    "k c #c05800",
    "d c #c0c0ff",
    "j c #ff0000",
    "n c #ff00ff",
    "m c #ffdca8",
    "l c #ffff00",
    "o c #ffffc0",
    "i c #ffffff",
    "......####......",
    ".....####.......",
    "....##ab....#...",
    "...#bac###.#d#..",
    "..##aaacef#d#gh.",
    "..#aaaeaai###d#.",
    ".#aaabaeiii###gh",
    ".##a###ii.i#d###",
    "##j#ii#i.i.i#...",
    "#kj##i#jiiij##..",
    "#jjk##jkjijkkj#h",
    "##lmllmlljjnjk##",
    ".##a#lmlol#a###.",
    "...###lml#......",
    ".....######.....",
    ".......#####...."
]

IconFileLinguist = QPixmap(IconFileLinguistXPM)


IconBackXPM = [
    "22 22 8 1",
    ". c None",
    "# c #000000",
    "f c #004040",
    "e c #008080",
    "d c #00c0c0",
    "c c #00ffff",
    "a c #c0ffff",
    "b c #ffffff",
    "......................",
    "......................",
    "......................",
    "......................",
    "...........##.........",
    "..........#a#.........",
    ".........#bc#.........",
    "........#bcd#.........",
    ".......#bcdd######....",
    "......#bcdddcaaac#....",
    ".....#bcdddddddde#....",
    "....#acddddddddde#....",
    ".....#fedddddddde#....",
    "......#fedddeeeee#....",
    ".......#fedd######....",
    "........#fed#.........",
    ".........#fe#.........",
    "..........#f#.........",
    "...........##.........",
    "......................",
    "......................",
    "......................"
]

IconBack = QPixmap(IconBackXPM)


IconForwardXPM = [
    "22 22 8 1",
    ". c None",
    "# c #000000",
    "f c #004040",
    "e c #008080",
    "c c #00c0c0",
    "b c #00ffff",
    "a c #c0ffff",
    "d c #ffffff",
    "......................",
    "......................",
    "......................",
    "......................",
    ".........##...........",
    ".........#a#..........",
    ".........#ba#.........",
    ".........#cba#........",
    "....######ccba#.......",
    "....#dddabcccba#......",
    "....#dccccccccba#.....",
    "....#acccccccccef#....",
    "....#accccccccef#.....",
    "....#ceeeecccef#......",
    "....######ccef#.......",
    ".........#cef#........",
    ".........#ef#.........",
    ".........#f#..........",
    ".........##...........",
    "......................",
    "......................",
    "......................"
]

IconForward = QPixmap(IconForwardXPM)


IconHomeXPM = [
    "22 22 11 1",
    ". c None",
    "# c #000000",
    "d c #400000",
    "c c #800000",
    "e c #a0a0a0",
    "b c #c00000",
    "i c #c05800",
    "a c #ff0000",
    "h c #ff8000",
    "g c #ffa858",
    "f c #ffffff",
    "......................",
    "......................",
    "......................",
    "..........##..........",
    ".....#...#ab#.........",
    ".....#..#abac#........",
    ".....#.#abddbc#.......",
    ".....##abde.dbc#......",
    ".....#abde.f.dbc#.....",
    "....#abde.fff.dbc#....",
    "...#abde.fffff.dbc#...",
    "...cdde.fdddff.e##c...",
    ".....#e.dgghdf.e#.....",
    ".....#e.dgiidf.e#.....",
    ".....#e.dgiidf.e#.....",
    ".....#e.dgiidf.e#.....",
    ".....#e.dhiidf.e#.....",
    ".....#e.dhiidf.e#.....",
    "......##########......",
    "......................",
    "......................",
    "......................"
]

IconHome = QPixmap(IconHomeXPM)


IconAddBookmarkXPM = [
    "22 22 9 1",
    ". c None",
    "# c #000000",
    "d c #303030",
    "b c #800080",
    "a c #c000c0",
    "f c #c0c000",
    "e c #ffff00",
    "c c #ffffc0",
    "g c #ffffff",
    "......................",
    "......................",
    "......................",
    "......................",
    "...############.......",
    "....#aaaabababb##.....",
    ".....#aababababab#....",
    "......#aababbbbbbb#...",
    ".....#aababababbbb#...",
    "....#bababbbbbbbbb#...",
    "...###########cbbb#...",
    "..........#c#de##c#...",
    "...........#efefe.....",
    "............fcccf.....",
    ".........#ceecgceec...",
    "............fcccf.....",
    "...........#efefe.....",
    "..........#c.#e.#c....",
    ".............#c.......",
    "......................",
    "......................",
    "......................"
]

IconAddBookmark = QPixmap(IconAddBookmarkXPM)


IconEditBookmarksXPM = [
    "22 22 6 1",
    ". c None",
    "# c #000000",
    "c c #303030",
    "d c #585858",
    "b c #800080",
    "a c #c000c0",
    "......................",
    "......................",
    "......................",
    "......................",
    "......................",
    "...############.......",
    "....#aaaabababb##.....",
    ".....#aababababab#....",
    "......#aababbbbbbb#...",
    ".....#aababababbbb#...",
    "....#bababbbbbbbbb#...",
    "...############bbb#...",
    "............#cc##b#...",
    "...........#cdcdc#....",
    "..........#dddd##.....",
    ".........#dddd#.......",
    ".........ccccc........",
    "......................",
    "......................",
    "......................",
    "......................",
    "......................"
]

IconEditBookmarks = QPixmap(IconEditBookmarksXPM)


# Set the icon provider.

class IconProvider(QFileIconProvider):
    """IconProvider(self)

    This class provides icons to QFileDialog for Python files.

    """
    def __init__(self):
        QFileIconProvider.__init__(self)

    def pixmap(self,finfo):
        if str(finfo.extension()) == 'py':
            pm = IconFilePython
        elif str(finfo.extension()) == 'ui':
            pm = IconFileDesigner
        elif str(finfo.extension()) == 'ts':
            pm = IconFileLinguist
        else:
            pm = None

        return pm


IconProviderInstance = IconProvider()
QFileDialog.setIconProvider(IconProviderInstance)
