"""
    FitDialog.py
    Fit filter parameters control dialog.
    
"""

from PyDVT import __version__,__date__,__author__


################################################################################
import Tkinter
import EventHandler
import Command
from Binding import *

if __name__ == "__main__":
    import sys
    sys.path.insert(0,"../../Depends/")
    sys.path.insert(0,"../../Depends/fit/")

from TkMultiparameters import ParametersTab as Parameters
from PyDVT.FitFilter import DEFAULT_FIT_PARS

class FitParametersDialog(Dialog):
    """
    """
    def __init__(self, parent,initial_parameters):
        self.Parameters=DEFAULT_FIT_PARS
        if initial_parameters is not None: self.Parameters.update(initial_parameters)
        self.eh = None
        self.ParametersChange = None
        Dialog.__init__(self,parent,"Fit Parameters Editor",modal=0)
        #self.MenuBar=Tkinter.Menu(parent)
        self.MenuBar=Menu(self)
        #self.menuAction = Tkinter.Menu(self.MenuBar, tearoff=1)
        #self.menuConfig = Tkinter.Menu(self.MenuBar, tearoff=1)
        self.menuAction = Menu(self.MenuBar)
        self.menuConfig = Menu(self.MenuBar)
        self.MenuBar.add_cascade(label="Action", menu=self.menuAction)
        self.MenuBar.add_cascade(label="Config", menu=self.menuConfig)
        self.table=Parameters(self)
        self.label=Label(self)
        self.config(menu=self.MenuBar)
        self.table.pack(side=Tkinter.TOP, fill=Tkinter.BOTH, expand=Tkinter.YES)
        self.label.pack(side=Tkinter.BOTTOM, fill=Tkinter.X, expand=Tkinter.YES)
        self.label.SetText('Ready')
        self.SetSize(600,400)

        self.Mode=self.Parameters["Mode"]
        self.Theory=self.Parameters["Theory"]
        self.Background=self.Parameters["Background"]
        self.WeightFlag=self.Parameters["WeightFlag"]
        self.Sensitivity=self.Parameters["Sensitivity"]
        self.FwhmPoints=self.Parameters["FwhmPoints"]
        self.Yscaling=self.Parameters["Yscaling"]
        self.AutoScaling=self.Parameters["AutoScaling"]
        self.AutoFwhm=self.Parameters["AutoFwhm"]
        self.TableParameters=[]

    def onInitialize(self,eh=None,fit=None):
        #self.menuConfig.delete()
        #self.menuAction.delete()
        self.theory_menu_dict={}
        self.back_menu_dict={}
        self.weight_menu_dict={}
        self.mode_menu_dict={}
        self.WeightFlag=self.Theory=self.Background=None

        if self.eh is not None:
            self.eh.unregister("FitFinished", self.onFitFinished)
        self.eh = eh
        self.fit = fit
        if self.eh is not None:
            self.ParametersChange = self.eh.create("ParametersChange")
            self.eh.register("FitFinished", self.onFitFinished)
        if fit is not None:
            self.EstimateMenuItem=self.menuAction.AddCommand('Estimate',self.onEstimate)
            self.ActionMenuItem=self.menuAction.AddCommand('StartFit',self.onStartFit)

            self.menuConfigTheory = Menu(self.menuConfig)
            self.menuConfig.AddCascade('Theory',self.menuConfigTheory)
            self.menuConfigBackground = Menu(self.menuConfig)
            self.menuConfig.AddCascade('Background',self.menuConfigBackground)
            self.menuConfigWeight = Menu(self.menuConfig)
            self.menuConfig.AddCascade('Weight',self.menuConfigWeight)
            self.menuConfigMode = Menu(self.menuConfig)
            self.menuConfig.AddCascade('Mode',self.menuConfigMode)
            self.menuConfig.AddCommand('Peak Search',self.OnPeakSearch)
            
            for theory in fit.theorylist:
                self.theory_menu_dict[theory]=self.menuConfigTheory.AddCommand(theory,Command.Command(self.onTheorySelect,theory),style = 'checkbutton')
            for background in fit.bkglist:
                self.back_menu_dict[background]=self.menuConfigBackground.AddCommand(background,Command.Command(self.onBackgroundSelect,background),style = 'checkbutton')
            for weight_flag in ["Statistical","No weight"]:                
                self.weight_menu_dict[weight_flag]=self.menuConfigWeight.AddCommand(weight_flag,Command.Command(self.onWeightSelect,weight_flag),style = 'checkbutton')
            for mode in ["Normal","MCA"]:                
                self.mode_menu_dict[mode]=self.menuConfigMode.AddCommand(mode,Command.Command(self.onModeSelect,mode),style = 'checkbutton')
            if fit.fitconfig['WeightFlag']:self.onWeightSelect("Statistical")
            else:self.onWeightSelect("No weight")
            self.onTheorySelect(fit.fitconfig['fittheory'])
            self.onBackgroundSelect(fit.fitconfig['fitbkg'])
            self.onModeSelect(self.Mode)


    def onWeightSelect(self,value):
        for weight_flag in self.weight_menu_dict.keys():
            if value==weight_flag:
                self.menuConfigWeight.CheckItem(self.weight_menu_dict[weight_flag],1)
            else:
                self.menuConfigWeight.CheckItem(self.weight_menu_dict[weight_flag],0)
        self.WeightFlag=value
        

    def onTheorySelect(self,value):
        for theory in self.theory_menu_dict.keys():
            if value==theory:
                self.menuConfigTheory.CheckItem(self.theory_menu_dict[theory],1)
            else:
                self.menuConfigTheory.CheckItem(self.theory_menu_dict[theory],0)
        self.Theory=value
                        
    def onBackgroundSelect(self,value):
        for back in self.back_menu_dict.keys():
            if value==back:
                self.menuConfigBackground.CheckItem(self.back_menu_dict[back],1)
            else:
                self.menuConfigBackground.CheckItem(self.back_menu_dict[back],0)
        self.Background=value

    def onModeSelect(self,value):
        for mode in self.mode_menu_dict.keys():
            if value==mode:
                self.menuConfigMode.CheckItem(self.mode_menu_dict[mode],1)
            else:
                self.menuConfigMode.CheckItem(self.mode_menu_dict[mode],0)
        self.Mode=value
        if self.Mode=="MCA":
            self.menuAction.DisableItem( self.EstimateMenuItem)
        else:
            self.menuAction.EnableItem( self.EstimateMenuItem)

    
    def onEstimate(self):
        self.label.SetText('Estimate')
        self.Apply("ESTIMATE")
        

    def onStartFit(self):
        self.label.SetText('Start Fit')
        self.TableParameters= self.table.fillfitfromtable()
        if self.TableParameters is None: self.Apply("ESTIMATE_FIT")
        else: self.Apply("FIT")
        
    def OnPeakSearch(self):
        self.PeakSearchDlg=Dialog(self,"Peak Search",1,0)
        Tkinter.Label(self.PeakSearchDlg, text="Sensitivity:").grid(row=0, sticky=Tkinter.NW,column=0)
        Tkinter.Label(self.PeakSearchDlg, text="FwhmPoints:").grid(row=1, sticky=Tkinter.NW,column=0)
        Tkinter.Label(self.PeakSearchDlg, text="Yscaling:").grid(row=2, sticky=Tkinter.NW,column=0)
        self.SensEntry=Tkinter.Entry(self.PeakSearchDlg)
        self.SensEntry.grid(row=0, sticky=Tkinter.NE,column=1)
        self.SensEntry.insert(Tkinter.INSERT,str(self.Sensitivity))
        self.FwhmEntry=Tkinter.Entry(self.PeakSearchDlg)
        self.FwhmEntry.grid(row=1, sticky=Tkinter.NE,column=1)
        self.FwhmEntry.insert(Tkinter.INSERT,str(self.FwhmPoints))
        self.YsEntry=Tkinter.Entry(self.PeakSearchDlg)
        self.YsEntry.grid(row=2, sticky=Tkinter.NE,column=1)
        self.YsEntry.insert(Tkinter.INSERT,str(self.Yscaling))
        self.varAutoScaling = Tkinter.IntVar()
        self.varAutoScaling.set(self.AutoScaling)
        chk1 = Tkinter.Checkbutton(self.PeakSearchDlg, text="Auto YScaling", variable=self.varAutoScaling)        
        chk1.grid(row=3, sticky=Tkinter.NW,column=0,columnspan=2)
        self.varAutoFwhm = Tkinter.IntVar()
        self.varAutoFwhm.set(self.AutoFwhm)
        chk2 = Tkinter.Checkbutton(self.PeakSearchDlg, text="Auto Fwhm", variable=self.varAutoFwhm)
        chk2.grid(row=4, sticky=Tkinter.NW,column=0,columnspan=2)
        button = Tkinter.Button(self.PeakSearchDlg, text="OK",command=self.OnOkPeakSearch)
        button.grid(row=5, column=0, columnspan=2, sticky=Tkinter.NSEW)
        self.PeakSearchDlg.Show()

    def OnOkPeakSearch(self):
        try:
            self.Sensitivity=float(self.SensEntry.get())
            self.FwhmPoints=int(self.FwhmEntry.get())
            self.Yscaling=float(self.YsEntry.get())
            self.AutoScaling=self.varAutoScaling.get() 
            self.AutoFwhm=self.varAutoFwhm.get() 
        except: pass
        self.PeakSearchDlg.destroy()
        

    def SetParameters(self,parameters):
        if "WeightFlag" in parameters.keys():
            if parameters["WeightFlag"]: self.onWeightSelect("Statistical")
            else: self.onWeightSelect("No weight")            
        if "Theory" in parameters.keys(): self.onTheorySelect(parameters["Theory"])
        if "Background" in parameters.keys():self.onBackgroundSelect(parameters["Background"])
        if "Mode" in parameters.keys():self.onModeSelect(parameters["Mode"])
        if "Sensitivity" in parameters.keys(): self.Sensitivity=parameters["Sensitivity"]
        if "FwhmPoints" in parameters.keys(): self.FwhmPoints=parameters["FwhmPoints"]
        if "Yscaling" in parameters.keys(): self.Yscaling=parameters["Yscaling"]
        if "AutoScaling" in parameters.keys(): self.AutoScaling=parameters["AutoScaling"]
        if "AutoFwhm" in parameters.keys(): self.AutoFwhm=parameters["AutoFwhm"]
        

    def GetParameters(self):
        if self.WeightFlag=="Statistical": weight_flag=1
        else: weight_flag=0
        return {"Theory":self.Theory,"Mode":self.Mode,"Background":self.Background,"WeightFlag":weight_flag,"Sensitivity":self.Sensitivity,"FwhmPoints":self.FwhmPoints,"Yscaling":self.Yscaling,"AutoScaling":self.AutoScaling,"AutoFwhm":self.AutoFwhm}

    
    def onFitFinished(self,parameters):
        self.label.SetText('Ready')
        if self.Mode=="MCA": self.table.fillfrommca(parameters)
        else:
            self.table.fillfromfit(parameters,current="Region 1")
            for view in self.table.tables.keys():
                if view != "Region 1":
                    self.table.removeview(view)
        
    
    def Apply(self,action="FIT"):
        """
        Called by ColormapEditorWidget then change takes place
        """
        if self.eh is not None:
            pars={}
            if self.WeightFlag=="Statistical": pars["WeightFlag"]=1
            else: pars["WeightFlag"]=0
            pars["Theory"]=self.Theory
            pars["Background"]=self.Background
            pars["Sensitivity"]=self.Sensitivity
            pars["FwhmPoints"]=self.FwhmPoints
            pars["AutoFwhm"]=self.AutoFwhm
            pars["Yscaling"]=self.Yscaling         
            pars["AutoScaling"]=self.AutoScaling
            pars["Mode"]=self.Mode
            pars["Action"]=action
            pars["FitPars"]=self.TableParameters
            self.eh.event(self.ParametersChange,pars)


if __name__ == "__main__":
    root = Tkinter.Tk()   
    mw = FitParametersDialog(root,None)

    from Specfit import Specfit
    from SpecfitFunctions import SpecfitFunctions
    fit=Specfit()
    fit.importfun("SpecfitFunctions.py")
    fit.settheory('Area Gaussians')
    
    mw.onInitialize(EventHandler.EventHandler(),fit)
    mw.SetSize(500,500)
    mw.Show()
    root.mainloop()

