#!/usr/bin/env python
"""This module implements a selector class. It looks like a button which 
display a menu when is pressed. This menu can be updated on the fly."""

from Tkinter import *
from Tkinter import _cnfmerge,_setit

DEBUG = 0

class Selector(Menubutton):
   def __init__(self, master, optlist, postcommand=None,
                command=None,cnf={},**kw):
         """
         Class constructor
         command is a callable object which is called  when an
         item is selected.
         postcommand is callable object which is called when the
         menu is displayed (for example an update function for the menu).
         """
         if DEBUG:
               print 'Selector : init'

         self.value = StringVar()

         kwdef = {"borderwidth": 2, "textvariable": self.value,
               "indicatoron": 1, "relief": 'raised', "anchor": "c",
               "highlightthickness": 2}

         cnf = _cnfmerge((cnf,kwdef,kw))

         Menubutton.__init__(self, master, cnf)
         self.widgetName    = 'tk_optionMenu'
         self.callback      = command
         if postcommand:
             self.postcommand   = postcommand
             menu = self.__menu = Menu(self, name="menu", 
                                   postcommand=self.postcommand, tearoff=0)
         else:
             menu = self.__menu = Menu(self, name="menu",tearoff=0)
         self.menuname      = menu._w
         self["menu"]       = menu

         self.setoptions(optlist)

   def setoptions(self, newlist):
         """Set the list newlist as items to the menu"""
         if DEBUG:
                print 'Selector : setting options'

         if len(newlist):
            self.optlist = newlist
            self.value.    set(newlist[0])
         else:
            self.optlist = []
            self.value.    set("")
         self.fillmenu()

   def fillmenu(self):
         """Fill the menu"""
         if DEBUG:
               print 'Selector : filling menu' 

         self.__menu.delete(0,'end')
         for v in self.optlist:
             self.__menu.add_command(label=v,
                 command=_setit(self.value, v, self.callback))

   def __getitem__(self, name):
        if name == 'menu':
           return self.__menu
        return Widget.__getitem__(self, name)

   def show_item(self,item):
        """Select the menu item item just like if the user had clicked on."""
        index = self.__menu.index(item)
        self.__menu.invoke(index)

   def destroy(self):
        """Destroy the selector"""
        if DEBUG:
             print 'Selector : destroy' 

        Menubutton.destroy(self)
        self.__menu = None


def test():
   """Selector class test function"""
   def show():
       global bla
       print "Showing menu"
       bla.setoptions([1,2,3,4,5,6])
   def gotit(item):
       print item," selected"
       print "bla.value =",bla.value.get()
   global bla
   root = Tk()
   value=StringVar()
   bla  = Selector(root,[1,2,3,4],postcommand=show,command=gotit)
   bla.   pack()
   root.  mainloop()
   

if __name__ == '__main__':
   test()
