"""
    SciDXPData.py
    Data derived class to interface SciDXP
"""

from PyDVT import __version__,__date__,__author__


################################################################################  
from Data import *
################################################################################

SOURCE_TYPE = "SciDXP"

#TODO: Updating, by polling or receiving events?
#TODO: Load group nodes as well?

class SciDXPData(Data):
    """
    Specializes Data class in order to interface SciDXP objects.    
    Interface: Data class interface.
    """
    def __init__(self,refresh_interval=None,info={}):
        """
        See Data.__init__
        """
        self.SciDXPObj=None
        info["Class"]="SciDXPData"
        #TODO: Other info?
        Data.__init__(self,refresh_interval,info)


    def SetSource (self,source=None):
        """
        Sets a new source for data retrieving, an node.
        self.Source will be this node.
        Returns 0 if error
        Parameters:
        source: node object 
        """        
        if source==self.Source: return 1
        try:
            self.Source = source
            self.SourceName=source.getName()
        except:
            self.Source = None
            self.SourceName= None
            return 0
        return 1


    def GetSourceInfo (self):
        """
        Returns information about node object created by
        SetSource, to give application possibility to know about
        it before loading.
        Returns a dictionary with the keys "Size" (number of possible
        keys to this source) and "KeyList" (list of all available keys
        in this source). Each element in "KeyList" is a tuple of strings
        meaning the name of the several hierarquical (all group nodes
        and the final dataset node).
        """        
        if self.SourceName == None: return None
        keylist=self.__GetKeyList(self.Source)
        source_info={}
        source_info["Size"]=len(keylist)
        source_info["KeyList"]=keylist
        return source_info        

        
    
    def LoadSource(self,key_list="ALL",append=0,invalidate=1):
        """
        Creates a given number of pages, getting data from the actual
        source (set by SetSource)
        Parameters:
        key_list: list of all keys to be read from source. 
                 It can be also one single key, if only one
                 is to be read.
        append: If non-zero appends to the end of page list.
                Otherwise, initializes the page list                
        invalidate: if non-zero performas an invalidade call after
                    loading        
        """
        if self.SourceName == None: return
        if append==0: Data.Delete(self)
        source_info=self.GetSourceInfo()
        if key_list == "ALL":           
            key_list=source_info["KeyList"]
        elif type(key_list) is types.TupleType: key_list=[key_list]
        
        for key in key_list:
            if key not in source_info["KeyList"]: raise "SciDXPData: bad key"
            if self.SourceName!=key[0]: raise "SciDXPData: bad key"
            obj=self.Source
            for i in range(1,len(key)):
                obj=obj.getChild(key[i])
            array=obj.getData().getData()            
            info={}
            info["SourceType"]=SOURCE_TYPE
            info["SourceName"]=self.SourceName
            info["Key"]=key
            info["Source"]=self.Source
            #TODO: OTHER INFO?
            self.AppendPage(info,array)        
        if invalidate: self.Invalidate()


    def __GetKeyList(self,node):
        try:
            self._keylist=[]
            self._position=[]    
            self.__inspect(node)
            return self._keylist
        except:
            return []
        
    def __inspect(self,node):
        self._position.append(node.getName())
        if hasattr(node,"getChildren"):
            children=node.getChildren()            
            for name in children.keys(): self.__inspect(children[name])        
        else:
            self._keylist.append(tuple(self._position))
        del self._position[-1]


################################################################################
    

        