"""
    Drawable3D.py
    3D plotting of 2D arrays 
"""

from PyDVT import __version__,__date__,__author__



class  Drawable_3D:
    """
    3D plotting widget interface definition
            
    This class generates the following callbacks to parent (a View object):
        _RightButtonPress
        _ButtonPress
        _DoubleClick
        _ButtonRelease
        _Motion
        _ButtonPressMotion
        _KeyPress
    """
    def __init__( self, parent=None):
        """
        Parameters:
            parent: parent widget (a View object)
        """
        pass
    

    def Show(self):
        """
        Displays widget
        """
        pass


    def RemoveFunction(self,name=None):
        """
        Parameters:
            name: name of the function to be removed from the drawable.
                  if none, all are removed
        """        
        pass

            
    def SetFunction(self,name,function_pars):        
        """
        Parameters:
            name: name of the function to be included
            function_pars: dictionary with the function properties (see MeshView)
        """        
        pass

              
    def SetFunctionItem(self,name,item,val):
        """
        Sets "item" of the function named "name" to the value "val"
        """        
        pass


    def SetTrackScrollbars(self,value):
        """
        Parameters:
            if value non-zero, scrollbar events promote continuous redrawing.
            Otherwise, just when button is released.
        """
        pass


    def SetLabels(self,title_label="",x_label="",y_label="",z_label=""):
        """
        Parameters:
            title_label: Label on the top of drawing
            x_label: Label for x axis
            y_label: Label for y axis
            z_label: Label for z axis
        """
        pass


    def SetEnv(self,xmin,xmax,ymin,ymax,zmin,zmax):   
        """
        Sets drawing limits
        Parameters:
            xmin,xmax: lower,upper values of x axis
            ymin,ymax: lower,upper values of y axis
            zmin,zmax: lower,upper values of z axis
        """
        pass
  

    def SetStyle(self,style):
        """
        Parameters:
            style: "3dSurface", "SurfaceMesh" or "ShadedSurface"
        """
        pass

    
    def SetMeshPlottingMode(self,opt):
        """
        Parameters:
            style: "XLines", "YLines" or "Both"
        """
        pass


    def Linear( self ):
        """
        Sets linear scale
        """
        pass


    def Log( self,minvalue=0.000001):
        """
        Sets logarithmic scale
        Parameters:
            minvalue: if on is non-zero sets the displaying value
                      for all values lass than or equals to zero
        """
        pass


    def Redraw(self):
        """
        Draws itself        
        """
        pass


    def Destroy(self):
        """
        Cleanup
        """
        pass


    def Save(self,filename,format):
        """
        Parameters:
            filename: name of the output file.
            format: format to be saved ("PS","PNG","BMP" or "JPG")
        """
        pass
