#ifdef Py_ARRAYOBJECT_H
#error "Can't use numarray Numeric compatability *and* Numeric in same module"
#endif

#if !defined(__arrayobject_h)
#define __arrayobject_h

#define REFCOUNT(obj) (((PyObject *)(obj))->ob_refcnt)
#define MAX_ELSIZE 16

#if defined(PY_ARRAY_UNIQUE_SYMBOL) 
#define libnumarray_UNIQUE_SYMBOL PY_ARRAY_UNIQUE_SYMBOL
#define PyArray_API PY_ARRAY_UNIQUE_SYMBOL
#else
#define PyArray_API  libnumarray_API
#endif

#include "libnumarray.h"

#define import_array() import_libnumarray();

#define PyArray(m)               ((PyArrayObject *)(m))
#define PyArray_SIZE(m)          PyArray_Size((PyObject *) m)
#define PyArray_NBYTES(m)        ((PyArray(m))->descr->elsize * PyArray_SIZE(m))
#define PyArray_ISCONTIGUOUS(m)  (((PyArray(m))->flags & CONTIGUOUS) != 0)
#define PyArray_ISALIGNED(m)     (((PyArray(m))->flags & ALIGNED) != 0)
#define PyArray_ISBYTESWAPPED(m) (!((PyArray(m))->flags & NOTSWAPPED))
#define PyArray_ISWRITABLE(m)    (((PyArray(m))->flags & WRITABLE) != 0)
#define PyArray_ISSPACESAVER(m)  0
#define PyArray_ISCARRAY(m)      (((PyArray(m))->flags & IS_CARRAY) == IS_CARRAY)
#define PyArray_isArray(o)       (PyArray_API && NA_NumArrayCheck(o))

#endif
