/**************************************************************************/
/* FILE   **************       pyMPI_Types.h       ************************/
/**************************************************************************/
/* Author: Patrick Miller May 17 2002					  */
/**************************************************************************/
/*  */
/**************************************************************************/

#ifndef PYMPI_TYPES_H
#define PYMPI_TYPES_H

/**************************************************************************/
/* TYPE   **************         PyMPI_Comm        ************************/
/************************************************************************ **/
/*  */
/**************************************************************************/
#define PYMPI_COMM_BODY \
  PyObject_HEAD \
  MPI_Comm	communicator; \
  double        time0; /* Time for deltaT timer */ \
  int		rank; /* Cached rank info */ \
  int		size; /* Cached size info */ \
  int		packedIntSize; \
  int		packedCharSize;

typedef struct {
  PYMPI_COMM_BODY
} PyMPI_Comm;

/**************************************************************************/
/* TYPE   **************       PyMPI_CartComm      ************************/
/************************************************************************ **/
/*  */
/**************************************************************************/
typedef struct {
  PYMPI_COMM_BODY

  int      ndims;
  int*     dims;
  int*     periods;
} PyMPI_CartComm;

/**************************************************************************/
/* TYPE   **************        PyMPI_Status       ************************/
/************************************************************************ **/
/*  */
/**************************************************************************/
typedef struct {
   PyObject_HEAD
   MPI_Status   status;
} PyMPI_Status;

/**************************************************************************/
/* TYPE   **************     PyMPI_Description     ************************/
/************************************************************************ **/
/*  */
/**************************************************************************/
typedef struct {
  long count;
  long extent;
  long datatype;
} PyMPI_Description;

/**************************************************************************/
/* TYPE   **************       PyMPI_Request       ************************/
/************************************************************************ **/
/*  */
/**************************************************************************/
#ifndef PYMPI_INITMESGLEN
#define PYMPI_INITMESGLEN 64
#endif
typedef struct {
  PyObject_HEAD
  int              iAmASendObject;    /* associated w/ a send operation?*/
  PyMPI_Description description;      /* what are we sending/recieveing?*/
  MPI_Request      descriptionRequest;/* for description isend/irecv    */
  char*            buffer;            /* allocated buffer for isend()/irecv() 
                                         must NOT be touched until operations
                                         have been completed!!          */
  MPI_Request      bufferRequest;     /* for data                       */
  MPI_Status	   status;	      /* Use for status (after receive) */
  PyObject*        postedMessage;     /* data as a python object        */
  MPI_Comm         communicator;      /* which communicator are we on?  */

  char firstBufMsg[PYMPI_INITMESGLEN]; /* Stores the result of the first part of the
                                   send in case the send was broken in two */
  int pkllen;                   /* Stores the pickeled length of msg being
                                   received*/
} PyMPI_Request;

/**************************************************************************/
/* TYPE   **************        PyMPI_Group        ************************/
/************************************************************************ **/
/*  */
/**************************************************************************/
typedef struct {
   PyObject_HEAD
   MPI_Group    group;
} PyMPI_Group;

/**************************************************************************/
/* TYPE   **************     PyMPI_Shared_File     ************************/
/**************************************************************************/
/* This defines a file-like object that reimplements a file for the input */
/* objects that share a read or write file handle on one process          */
/**************************************************************************/
typedef struct {
   PyObject_HEAD
   int master;
   int rank;
  int style;
  PyMPI_Comm* communicator;
  PyObject* file;
  PyObject* filename;
  PyObject* filemode;
  PyObject* local_buffer;
} PyMPI_Shared_File;


/**************************************************************************/
/* TYPE   **************      PyMPI_ReduceOps      ************************/
/**************************************************************************/
/* Constants for a global lookup table mapping MPI reduction values to    */
/* values guaranteed to be convertable to integers.			  */
/**************************************************************************/
typedef enum {
  PyMPI_MAX,
  PyMPI_MIN,
  PyMPI_SUM,
  PyMPI_PROD,
  PyMPI_LAND,
  PyMPI_BAND,
  PyMPI_LOR,
  PyMPI_BOR,
  PyMPI_LXOR,
  PyMPI_BXOR,
  PyMPI_MAXLOC,
  PyMPI_MINLOC,
  PyMPI_NUMREDUCEOPS
} PyMPI_ReductionOp;

typedef enum {
  PyMPI_STRING_BUFFER,
  PyMPI_FILE_BUFFER,
  PyMPI_NULL_BUFFER,
  PyMPI_NUMPARAMS
} PyMPI_Parameters;

/* ----------------------------------------------- */
/* Early adoption of Python 2.2 slots		   */
/* ----------------------------------------------- */
#if PYTHON_API_VERSION <= 1010
typedef PyObject *(*getter)(PyObject *, void *);
typedef int (*setter)(PyObject *, PyObject *, void *);

typedef struct PyGetSetDef {
	char *name;
	getter get;
	setter set;
	char *doc;
	void *closure;
} PyGetSetDef;
#endif

#endif
