"""
This Module contains some handy extensions to the os.path module.
"""
# (mcb) June, 1999




from types import *
from string import split
import os
from os import path
import shutil

from utils import *




def utpFileCopy(srcfnm, tgtfnm, mode = None):
	shutil.copyfile(srcfnm, tgtfnm)
	#os.system("cp %s %s" % (srcfnm, tgtfnm))
	if mode:
		os.chmod(tgtfnm, mode)
	return




def utpChDir(tgtdir):
	return os.chdir(tgtdir)




#
# unix style file listing tools - simple minded but clear ...
# if ever the strings should turn out to be really performansces
# killing it could be implemented in a different way
# 
#
utp_USER   = 0
utp_GROUP  = 3
utp_OTHERS = 6
utp_ALL    = 9
utp_SCOPES = [utp_USER, utp_GROUP, utp_OTHERS, utp_ALL]

utp_E      = ['e', '~']
utp_D      = ['-', 'd', 'l']
utp_R      = ['r', '-']
utp_W      = ['w', '-']
utp_X      = ['x', '-']
utp_PROF_E = ['e', '~', '?']
utp_PROF_D = ['-', 'd', 'l', '?']
utp_PROF_R = ['r', '-', '?']
utp_PROF_W = ['w', '-', '?']
utp_PROF_X = ['x', '-', '?']




def utpGetPathStatus(thepath):
	e = d = r = w = x = ''

	if path.exists(thepath):    e = 'e'
	else:
		e = '~'
		return e, d, r, w, x

	if path.isdir(thepath):     d = 'd'
	elif path.islink(thepath):  d = 'l'
	elif path.isfile(thepath):  d = '-'
	else:
		e = ''
		return e, d, r, w, x

	if(os.access(thepath, os.R_OK)):  r = 'r'
	else:                             r = '-'
	if(os.access(thepath, os.W_OK)):  w = 'w'
	else:                             w = '-'
	if(os.access(thepath, os.X_OK)):  x = 'x'
	else:                             x = '-'

	return e, d, r, w, x




def utpExtractDperm(perm, scope = utp_USER):

	d = r = w = x = ''
	if not (utpIsValidPerm(perm) and scope in utp_SCOPES):
		return d, r, w, x

	d = perm[0]
	r = perm[1 + scope]
	w = perm[2 + scope]
	x = perm[3 + scope]

	return d, r, w, x




def utpIsMatchingStatus(profile, status):

	if '~' == status[0]:
		if '?' == profile[0] or '~' == profile[0]:
			return TRUE
			
	for i in range(len(profile)):
		if '?' != profile[i]:
			if profile[i] != status[i]:
				return FALSE

	return TRUE




def utpIsValidStatus(status, length = 5):

		if length != len(status):
			return FALSE

		if    status[0] in utp_E \
	     or status[1] in utp_D \
	     or status[2] in utp_R \
	     or status[3] in utp_W \
	     or status[4] in utp_X:
			return TRUE
		else:
			return FALSE



	
def utpIsValidProfile(profile, length = 5):

	if length != len(profile):
		return FALSE

	if     profile[0] in utp_PROF_E \
     and profile[1] in utp_PROF_D \
     and profile[2] in utp_PROF_R \
     and profile[3] in utp_PROF_W \
     and profile[4] in utp_PROF_X:
		return TRUE
	else:
		return FALSE




def utpIsValidPerm(perm):

	if not type(perm) is StringType or len(perm) != 10:
		return FALSE

	if not perm[0] in utp_D:
		return FALSE

	if     perm[1] in utp_R and perm[2] in utp_W and perm[3] in utp_X \
	   and perm[4] in utp_R and perm[5] in utp_W and perm[6] in utp_X \
	   and perm[7] in utp_R and perm[8] in utp_W and perm[9] in utp_X:
		return TRUE
	else:
		return FALSE




def utpPathTailString(thepath, cut = 50):
	pathLength = len(thepath)
	dif = pathLength - cut
	if dif <= 0:
		return ' '*(-dif+4) + thepath
	else:
		return '....' + thepath[-cut:]
