#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include <Python.h>
#include <Numeric/arrayobject.h>

#include <mcb.h>
#include <binio.h>
#include <bina.h>
#include <binb.h>
#include <mari.h>

static PyObject *
OdmNpyMarInput(PyObject *self, PyObject *args)
{
	char *gfp, err_str[132];
	PyArrayObject *a;
	sint32_t binning, tcode, swap, result = NO_ERROR;

	if(!PyArg_ParseTuple(args, "sOlll", &gfp, &a, &binning, &tcode, &swap))
		return NULL;

	if(a->nd !=2 || a->descr->type_num != PyArray_LONG) {
		PyErr_SetString(PyExc_ValueError, "array a must be of type long");
		return NULL;
	}

	result = sint32_mar_i(gfp, (void *)(a->data), binning, swap);
	if(result) {
		sprintf(err_str, "got error %1d from sint32_mar_i", result);
		PyErr_SetString(PyExc_StandardError, err_str);
		return NULL;
	}

	return Py_BuildValue("l", result);
}

static PyObject *
OdmNpyBinaryInput(PyObject *self, PyObject *args)
{
	char *gfp;
	PyArrayObject *a;
	void *v;
	sint32_t size, offset, swap, result = NO_ERROR;

	if (!PyArg_ParseTuple(args, "sOlll", &gfp, &a, &size, &offset, &swap))
		return NULL;
	v = (void *)(a->data);
	result = raw_bin_i(gfp, v, (size_t)size, (size_t)offset);
	if(result) {
		PyErr_SetString(PyExc_IOError, "error reading binary file");
		return NULL;
	}
	if(swap) result = byte_swap(v, (size_t)(size/swap), (size_t)swap);
	return Py_BuildValue("l", result);
}

static PyObject *
OdmNpyConvBinaryInput(PyObject *self, PyObject *args)
{
	char *gfp;
	PyArrayObject *a;
	void *v;
	sint32_t nn, offset, ltype, lsize, rtype, rsize, swap, result = NO_ERROR;

	printf("This is OdmNpyConvBinaryInput...\n");

	if (!PyArg_ParseTuple(args, "sOlllllll", &gfp, &a, &nn, &offset,
	                                       &ltype, &lsize,
	                                       &rtype, &rsize,
	                                       &swap))
		return NULL;
	v = (void *)(a->data);
	result = convraw_bin_i(gfp, v, (size_t)nn, (size_t)offset,
	                       (int_t)ltype, (size_t)lsize,
	                       (int_t)rtype, (size_t)rsize,
	                       (size_t)swap);
	printf("result from convraw... is %ld\n", result);
	if(result) {
		PyErr_SetString(PyExc_IOError,
		                "IOError? error reading and converting binary file");
		return NULL;
	}
	return Py_BuildValue("l", result);
}

static PyObject *
OdmNpyBinaryOutput(PyObject *self, PyObject *args)
{
	char *gfp;
	PyArrayObject *a;
	void *v;
	sint32_t size, swap, result = NO_ERROR;

	if (!PyArg_ParseTuple(args, "sOll", &gfp, &a, &size, &swap))
		return NULL;
	v = (void *)(a->data);
	if(swap) byte_swap(v, (size_t)(size/swap), (size_t)swap);
	result = raw_bin_o(gfp, v, (size_t)size);
	if(result) {
		PyErr_SetString(PyExc_ValueError, "error writing binary file");
		return NULL;
	}
	return Py_BuildValue("l", result);
}

static PyObject *
OdmRampVideoScale(PyObject *self, PyObject *args)
{
	char *gfp;
	PyArrayObject *a, *b;
	void *v, *g;
	sint32_t n, photo, dll, dhl, gll, ghl, result = NO_ERROR;

	if (!PyArg_ParseTuple(args, "OOllllll", &a, &b, &n, &photo,
	                                        &dll, &dhl, &gll, &ghl))
		return NULL;
	v = (void *)(a->data);
	g = (void *)(b->data);
	RampScale_sint32(v, g, (size_t)n, (int_t)photo,
	                 dll, dhl, gll, ghl);
	return Py_BuildValue("l", result);
}

static PyObject *
OdmRampVideoScaleZoom(PyObject *self, PyObject *args)
{
	char *gfp;
	PyArrayObject *a, *b;
	void *v, *g;
	sint32_t n1, n2, photo, dll, dhl, gll, ghl, zoom, result = NO_ERROR;

	if (!PyArg_ParseTuple(args, "OOllllllll", &a, &b, &n1, &n2, &photo,
	                                        &dll, &dhl, &gll, &ghl, &zoom))
		return NULL;
	v = (void *)(a->data);
	g = (void *)(b->data);
	RampScaleZoom_sint32(v, g, (size_t)n1, (size_t)n2, (int_t)photo,
	                 dll, dhl, gll, ghl, (int_t)zoom);
	return Py_BuildValue("l", result);
}

static PyMethodDef OdakdmMethods[]={
	{"OdmNpyMarInput",        (PyCFunction)OdmNpyMarInput,         METH_VARARGS},
	{"OdmNpyBinaryInput",     (PyCFunction)OdmNpyBinaryInput,      METH_VARARGS},
	{"OdmNpyConvBinaryInput", (PyCFunction)OdmNpyConvBinaryInput,  METH_VARARGS},
	{"OdmNpyBinaryOutput",    (PyCFunction)OdmNpyBinaryOutput,     METH_VARARGS},
	{"OdmRampVideoScale",     (PyCFunction)OdmRampVideoScale,      METH_VARARGS},
	{"OdmRampVideoScaleZoom", (PyCFunction)OdmRampVideoScaleZoom,  METH_VARARGS},
	{NULL,NULL}
};

void initodakdm()
{
	(void) Py_InitModule("odakdm", OdakdmMethods);
}

void initPyODAKDM()
{
	(void) Py_InitModule("PyODAKDM", OdakdmMethods);
}
