/*  file: mcb.h
 *  author: mcb
 *  what it is: some basic stuff ...
 */

/* types */
typedef void void_t;
typedef char char_t;
typedef int int_t;
typedef unsigned char uint8_t;
typedef unsigned short int uint16_t;
typedef unsigned long int uint32_t;
typedef signed char sint8_t;
typedef signed short int sint16_t;
typedef signed long int sint32_t;
typedef float float_t;
typedef double double_t;
typedef int_t boolean_t;
typedef sint32_t error_t;

#define VOID_T         1
#define CHAR_T         2
#define INT_T          3
#define UINT8_T        4
#define UINT16_T       5
#define UINT32_T       6
#define SINT8_T        7
#define SINT16_T       8
#define SINT32_T       9
#define FLOAT_T       10
#define DOUBLE_T      11
#define BOOLEAN_T     12
#define ERROR_T       13

/* standard error handling */
#define NO_ERROR           (error_t)0

#define IO_ERR             (error_t)-100
#define IO_FOPEN_ERR       (error_t)-101
#define IO_FCLOSE_ERR      (error_t)-102
#define IO_FEOF_ERR        (error_t)-103
#define IO_FERROR_ERR      (error_t)-104
#define IO_FREAD_ERR       (error_t)-105
#define IO_FWRITE_ERR      (error_t)-106

#define FPO_ERR            (error_t)-200
#define FPO_ILLEGAL_ERR    (error_t)-201
#define ZERODIV_ERR        (error_t)-202

#define NULLPTR_ERR        (error_t)-300
#define ALLOC_ERR          (error_t)-301

#define NOTIMPL_ERR        (error_t)-401
#define SYNTAX_ERR         (error_t)-402

/* this we might need from time to time */
#define TRUE  1
#define FALSE 0

/* some handy things */
#define STRBOOL(x) (x ? "TRUE" : "FALSE")
#define MAXM(x,y) ((x) > (y) ? (x) : (y))
#define MINM(x,y) ((x) < (y) ? (x) : (y))

/* ? */
#define CRETURN(x) if(x) return x
#define FREAD_INFO(should, is) \
printf("fread: expected %1ld bytes, read: %1ld, diff %1ld\n", \
should, is, should - is)
#define FWRITE_INFO(should, is) \
printf("fwrite: expected %1ld bytes, wrote: %1ld, diff %1ld\n", \
should, is, should - is)
        

/* declarations */
extern int check_impl(int verbose);
extern void_t * void_newarray(size_t n);
extern char_t * char_newarray(size_t n);
extern int_t * int_newarray(size_t n);
extern uint8_t * uint8_newarray(size_t n);
extern uint16_t * uint16_newarray(size_t n);
extern uint32_t * uint32_newarray(size_t n);
extern sint8_t * sint8_newarray(size_t n);
extern sint16_t * sint16_newarray(size_t n);
extern sint32_t * sint32_newarray(size_t n);
extern float_t * float_newarray(size_t n);
extern double_t * double_newarray(size_t n);
extern boolean_t * boolean_newarray(size_t n);
extern error_t * error_newarray(size_t n);
