/* file: mari.c
 * author: mcb (Sun May 27 02:45:23 MEST 2001)
 * type: C source
 * what it is:
 */
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "mcb.h"
#include "debug.h"
#include "binio.h"
#include "bina.h"
#include "mari.h"

static const MarDef marS[3] = {
	{ 0,    0,    0,         0,           0,    0, 0 },
	{ 2, 2048, 2048, 2048*2048, 2048*2048*2, 4096, 1 },
	{ 2, 1024, 1024, 1024*1024, 1024*1024*2, 4096, 2 }
};

MarDef get_mardef(int_t binning)
{
	if(0 > binning || 2 < binning)
		return marS[0];
	else
		return marS[binning];
}

void printMarDef(MarDef md)
{
	printf("dataword:    %1ld\nnx:          %1ld\nny:          %1ld\nnn:          %1ld\nnbytes:      %1ld\ndataoffset:  %1ld\nbinning:     %1d\n",
	       md.dataword, md.nx, md.ny, md.nn, md.nbytes, md.dataoffset,
	       md.binning);
	return;
}

error_t uint16_mar_i(char *gfp, uint16_t *buffer, int_t binning, size_t swap)
{
	error_t result = NO_ERROR;

	CRETURN(raw_bin_i(gfp, (void *)buffer, marS[binning].nbytes,
	                   marS[binning].dataoffset));

	if(swap) CRETURN(byte_swap((void *)buffer, marS[binning].nn, (size_t)2));

	return result;
}

error_t sint32_mar_i(char *gfp, sint32_t *buffer, int_t binning, size_t swap)
{
	error_t result = NO_ERROR;
	void *v = NULL;

	v = void_newarray(marS[binning].nbytes);
	if(NULL == buffer) CRETURN(ALLOC_ERR);

	result = raw_bin_i(gfp, v, marS[binning].nbytes, marS[binning].dataoffset);
	if(result) {
		free(v);
		return result;
	}

	if(swap) result = byte_swap(v, marS[binning].nn, (size_t)2);
	if(result) {
		free(v);
		return result;
	}
	
	result = bin_conv(v, marS[binning].nn, (void *)buffer, UINT16_T, SINT32_T);
	free(v);
	return result;
}

error_t double_mar_i(char *gfp, double_t *buffer, int_t binning, size_t swap)
{
	error_t result = NO_ERROR;
	void *v = NULL;

	v = void_newarray(marS[binning].nbytes);
	if(NULL == buffer) CRETURN(ALLOC_ERR);

	result = raw_bin_i(gfp, v, marS[binning].nbytes, marS[binning].dataoffset);
	if(result) {
		free(v);
		return result;
	}

	if(swap) result = byte_swap(v, marS[binning].nn, (size_t)2);
	if(result) {
		free(v);
		return result;
	}
	
	result = bin_conv(v, marS[binning].nn, (void *)buffer, UINT16_T, DOUBLE_T);
	free(v);
	return result;
}
