/*
Update 08/11/2001 R. Wilcke (wilcke@esrf.fr)
                  analyse_args(): add new command line arguments "inp_min" and
                  "inp_max" and code to hand them to the correction routines.
Update 05/11/2001 R. Wilcke (wilcke@esrf.fr)
                  analyse_args(): add 2 more new arguments to azim_int() call
                  and code to get their values from the user.
Update 31/10/2001 R. Wilcke (wilcke@esrf.fr)
                  user_code(): add call to set_return_value() to return a status
                  to the calling program (i.e. "spec).
Update 22/10/2001 R. Wilcke (wilcke@esrf.fr)
                  analyse_args(): add 3 new arguments to azim_int() call and
                  code to get their values from the user;
Update 19/10/2001 R. Wilcke (wilcke@esrf.fr)
                  analyse_args(): change test for correct_image() return value;
                  analyse_args(): add code to implement azimuthal integration.
Update 16/10/2001 R. Wilcke (wilcke@esrf.fr)
                  read_esrf_file(): create a new header module for the source
                  image header before reading values into it;
                  move the closing of the source image header module from
                  save_esrf_file() to get_buffer();
                  save_esrf_file(): create a new header module for the online
                  image header before reading values into it;
                  get_buffer(): close both the source and the online header
                  module whenever the input source file or the online header has
                  changed;
                  read_esrf_file(): always read new values into the header
                  module, even if "headpass" is 0.
Update 03/10/2001 R. Wilcke (wilcke@esrf.fr)
                  save_esrf_file(): change last input argument to contain the
                  EDF I/O stream for the temporary online header and modify
                  code accordingly;
                  put_buffer(): change last argument in save_esrf_call() to
                  the EDF I/O stream for the temporary online header;
Update 02/10/2001 R. Wilcke (wilcke@esrf.fr)
                  scanhead(): get the values for the header structure from the
                  temporary "HDSTREAM" header;
                  scanhead(): change the first input argument from a pointer to
                  the header buffer ("char *header") to the stream descriptor
                  for the EDF data I/O ("int stream"), and change function
                  declaration accordingly;
                  analyse_args(): change the first argument of the scanhead()
                  call from the buffer pointer to the header stream descriptor;
                  analyse_args(): pre-set "Dummy" for the corrected image from
                  the online header;
                  read_esrf_file(): replace the code to read the header keywords
                  by a call to scanhead();
                  rename HEADER_NO and HEADER_LEN to "headrows" and "headcols",
                  make them local variables in scanhead() and remove them
                  anywhere else;
                  save_esrf_file(): remove the last two input arguments and test
                  for "HDSTREAM != -1" to find out if there is an online header;
                  put_buffer(): remove the last two arguments in the call to
                  save_esrf_file().
Update 01/10/2001 R. Wilcke (wilcke@esrf.fr)
                  get_buffer(): free temporary header when "HDSTREAM" is closed.
Update 28/09/2001 R. Wilcke (wilcke@esrf.fr)
                  added new global variable "HDSTREAM" for a temporary EDF
                  header;
                  get_buffer(): added code to read the online header and to put
                  it into the temporary EDF header;
                  analyse_args(): set "HDSTREAM" to -1 if "clear" parameter is
                  given on the command line;
                  save_esrf_file(): add code to get the online header from the
                  temporary EDF header and write it to the output file header;
Update 25/09/2001 R. Wilcke (wilcke@esrf.fr)
                  analyse_args(): add new command line parameter "pass" and the
                  code to set it;
                  read_esrf_file() and save_esrf_file(): add code to read the
                  entire header from the source file and to write it to the
                  corrected image file;
                  scanhead() and save_esrf_file(): replace edf_maxkeylen() and
                  edf_maxvallen() calls by macros EdfMaxKeyLen and EdfMaxValLen;
                  read_esrf_file(): replace edf_maxlinlen() call by macro
                  EdfMaxLinLen.
Update 24/09/2001 R. Wilcke (wilcke@esrf.fr)
                  analyse_args(): do no longer test the return value of
                  scanhead();
                  analyse_args(): change code to have correct setting of header
                  values and output "Dummy" value;
                  read_esrf_file(): move the code with the label "badheader" to
                  the end of the routine.
Update 14/09/2001 R. Wilcke (wilcke@esrf.fr)
                  read_esrf_file(): change the opening mode for the file in the
                  edf_open_data_file() call from "old" to "read";
                  analyse_args(): write an output file only if correct_image()
                  was successful;
                  analyse_args(): clear the flags of the SRCTYP header structure
                  before getting the new header values if the image is from a
                  shared memory.
Update 20/08/2001 R. Wilcke (wilcke@esrf.fr)
                  add declaration for function scanhead();
                  save_esrf_file(): put the initialized values of the CORTYP
                  header structure in the output file;
                  analyse_args(): declare "src_im" as static and do not free the
                  buffer when processing input source files;
                  analyse_args(): set HEADER_NO and HEADER_LEN to 0 if no online
                  header;
                  analyse_args(): test if the command line argument "dummy" is
                  set, and replace "Dummy" by the value in the input file only
                  if it is not set;
                  get_buffer() and analyse_args(): set the "Dummy" value from
                  the input source file, and reset it again to the value of
                  the command line if this is set. This is a kludge!  It should
                  be done with a proper flag signalling when "Dummy" is set;
Update 17/08/2001 R. Wilcke (wilcke@esrf.fr)
                  read_esrf_file() and scanhead(): fill the "init" member of the
                  header structure with the new flags indicating which keywords
                  have been found;
                  read_esrf_file(): transfer the header structure also for type
                  "SPDTYP";
                  analyse_args(): read input source image before all other
                  images to define the dimensions of the images to process;
                  get_buffer(): call prepare_flood() only after testing for the
                  correct size of the floodfield image;
                  analyse_args(): do not reset the image buffers to NULL when
                  executing "clear";
                  get_buffer(): add variable "shm_changed" to flag if the shared
                  memory segment has changed, and call prepare_flood() only if
                  "shm_changed || file_changed" is true;
                  scanheader(): do no longer return an error if not all header
                  elements are found;
                  scanheader() and read_esrf_file(): get additional header
                  keyword "WaveLength".
Update 14/08/2001 R. Wilcke (wilcke@esrf.fr)
                  analyse_args(): if there is a shared memory header provided
                  and the command line option "dummy" is not given, use the
                  "Dummy" value in the shared memory header to set "Dummy" for
                  the output file (with set_dummy());
                  read_esrf_file(): add input argument "type" in 5th position;
                  read_esrf_file(): read the values for the structure type
                  "data_head" from the header of the file and, if successful,
                  transfer the structure to the corresponding image type header
                  structure in the correction routines (except for SPDTYP);
                  get_buffer(): change the call to read_esrf_file() to include
                  the new "type" argument.
Update 13/08/2001 R. Wilcke (wilcke@esrf.fr)
                  analyse_args(): add command line argument "clear" and the
                  corresponding code to reset all option values to their default
                  values;
                  analyse_args(): add the second argument to the set_headval()
                  call to put the online header into the SRCTYP header;
Update 10/08/2001 R. Wilcke (wilcke@esrf.fr)
                  analyse_args(): rename variable "filename" to "distfile",
                  declare it static and initialize it to "spatial.dat";
                  analyse_args(): declare as static the variables simul_flag,
                  do_spd, do_flat, do_later, verbose, norm_int, overf, bkgconst,
                  dummy and arad and give them the required initialization
                  values;
                  scanhead() and save_esrf_file(): change format for reading of
                  header from "%s" to "%[^\n]" as the string can contain blanks;
                  analyse_args(): correct the code to get the "simul_flag"
                  option (it got "corid" instead) and move the code for the grid
                  simulation directly behind the loop over the option arguments;
                  analyse_args(): transfer the parameters to the correction
                  routines only after the end of the loop over the option
                  arguments.
Update 09/08/2001 R. Wilcke (wilcke@esrf.fr)
                  increase dimensions of current_shm[], old_where[], old_file[],
                  last_mtime[] and last_utime[] from 5 to 6 and add
                  initialization elements;
                  declare struct *pmem_head as "static";
                  analyse_args(): change code for the background corrections:
                  now the background constant can be specified in addition to
                  any of the two other background options.
Update 08/08/2001 R. Wilcke (wilcke@esrf.fr)
                  get_buffer(): in the "error_ret", free the buffer if it has
                  been allocated;
                  analyse_args(): rename "input_file" to "srcfile";
                  analyse_args(): remove declaration of shm_src, shm_cor,
                  shm_flo and shm_bkg;
                  analyse_args(): test if the get_buffer() calls have been
                  successful, and return with an error if not;
                  analyse_args(): test for "srcid != -1" instead of "src_im" for
                  the shared memory case;
                  analyse_args(): move the get_buffer() call for the source
                  image into the code for the shared memory case - the file case
                  has already its own get_buffer();
                  analyse_args(): give the get_buffer() call for the source
                  image a "srcid" = -1 for the file case and a "srcfile" = NULL
                  for the shared memory case;
                  main(): print an error message if analyse_args() return != 0.
Update 07/08/2001 R. Wilcke (wilcke@esrf.fr)
                  analyse_args(): add code to get a buffer for the scattering
                  background image and hand it over to the correction routines;
                  get_buffer(): add code for obtaining a buffer for the
                  scattering background image;
                  clean_buffer(): do not free an empty buffer pointer;
                  analyse_args(): clean the source image buffer at the end of
                  the routine (did not happen before if there was no valid
                  buffer for the corrected image);
                  rename global variable COR_FILE to "corfile" and make it a
                  local variable in analyse_args().
Update 06/08/2001 R. Wilcke (wilcke@esrf.fr)
                  analyse_args(): initialize "dummy" to 0., and add code to
                  select the correct value of "dummy" - this parameter might be
                  given on the command line and in the user-header.
Update 03/08/2001 R. Wilcke (wilcke@esrf.fr)
                  add routine scanhead() to get the header keywords and values
                  from the header shared memory segment and put them in the
                  header structure;
                  analyse_args(): read header from shared memory segment
                  directly after the source image has been read, get the values
                  using scanhead() and hand them to the correction routines
                  with set_headval().
Update 02/08/2001 R. Wilcke (wilcke@esrf.fr)
                  move declaration of structure current_shm to the beginning of
                  the code;
                  analyse_args(): add command line argument "norm_int" and the
                  code to read it in and pass it to the correction routines;
                  get_buffer(): change order of arguments in the set_xysize();
                  get_buffer(): declare return type of function as "int".
Update 01/08/2001 R. Wilcke (wilcke@esrf.fr)
                  move the get_buffer() and clean_buffer() calls for the header
                  shared memory segment (HEADER_ID) from  put_buffer() to
                  analyse_args();
                  rename global variable HEADER_ID to "headid" and make it local
                  to routine analyse_args();
                  rename local variable header_buf to HEADER_BUF and make it
                  global;
Update 26/07/2001 R. Wilcke (wilcke@esrf.fr)
                  get_buffer(): correct the values given to HEADER_NO and
                  HEADER_LEN;
                  save_esrf_file(): change the format in the sscanf() call of
                  the header buffer to remove leading blanks in the values;
                  save_esrf_file(): update comments about the header keywords
                  that are automatically written (EDF_DataFormatVersion and
                  EDF_DataBlocks keywords removed);
                  save_esrf_file(): change reading of the header buffer so that
                  it can work with two different formats of the header buffer.
Update 28/06/2001 R. Wilcke (wilcke@esrf.fr)
                  use routines set_bkgim() and set_floim() to hand pointers to
                  the background image and the floodfield image to the image
                  correction routines;
                  change call to correct_image() by eliminating the background
                  image and the floodfield image from the input arguments.
Update 26/06/2001 R. Wilcke (wilcke@esrf.fr)
                  correct the comments explaning "xfile" and "yfile";
                  analyse_args(): add command line arguments "xoutfile" and
                  "youtfile" and the code to read them in and pass them to the
                  correction routines;
Update 25/06/2001 R. Wilcke (wilcke@esrf.fr)
                  get_buffer(): add missing string argument in prmsg() call in
                  test for correct image size;
                  remove declaration of variables X_COR, Y_COR, DO_XYFILE and
                  SPLINE_INVALID;
                  remove declaration of variables XOFFSET and YOFFSET and all
                  code that uses them (they do not seem to serve any purpose in
                  the image correction);
                  remove declaration of variable COR_FORMAT and all related
                  code, the output format is now always EDF;
                  remove declaration of the parameters for the geometrical
                  method (CURV_RADIUS, XCENTER and YCENTER) and all related
                  code. This method is no longer used;
                  remove function save_mar_file(), it is no longer needed;
                  analyse_args(): change type of "bkgconst" from "int" to
                  "float" and change format argument in scan_argument()
                  accordingly;
                  remove declaration of variable LUT_INVALID (this is now an
                  internal variable of the functions in "correct.c");
                  use new function calls to set the values of former global
                  variables:
                  - set_verbose() for "verbose";
                  - set_overflow() for IMAGE_OVER and IMAGE_OVER_SET;
                  - set_dummy() for Dummy;
                  - set_actrad() for ACTIVE_R;
                  - set_splinfil() for FILENAME;
                  - set_xycorin() for XFILE and YFILE;
                  - set_xysize() for XSIZE and YSIZE;
                  - set_bkgconst() for BKG_CONST;
                  use new function calls to obtain the values of former global
                  variables:
                  - get_xsize() for XSIZE;
                  - get_ysize() for YSIZE;
Update 19/06/2001 R. Wilcke (wilcke@esrf.fr)
                  initialize global variable COR_FILE to NULL.
Update 18/06/2001 R. Wilcke (wilcke@esrf.fr)
                  read_esrf_file(): remove reading of BYTEORDER header keyword
                  and the code to do forced byteswapping;
                  analyse_args(): remove code for setting the global variable
                  SRC_SWAP for forced byteswapping;
                  remove global variable SRC_SWAP.
Update 12/06/2001 R. Wilcke (wilcke@esrf.fr)
                  change variable name "DUMMY" to "Dummy" to avoid name conflict
                  with macro DUMMY().
Update 14/05/2001 R. Wilcke (wilcke@esrf.fr)
                  save_esrf_file(): completely rewritten to use the "ESRF Data
                  Format" access routines of P. Boesecke;
                  put_buffer(): replace SHM_FLOAT by MFloat in the call to
                  save_esrf_file();
                  remove struct "esrf_id" (no longer needed).
Update 11/05/2001 R. Wilcke (wilcke@esrf.fr)
                  remove gethead() routine - no longer needed.
Update 10/05/2001 R. Wilcke (wilcke@esrf.fr)
                  read_esrf_file(): completely rewritten to use the "ESRF Data
                  Format" access routines of P. Boesecke;
                  get_buffer(): replace SHM_FLOAT by MFloat in the call to
                  read_esrf_file();
                  get_buffer(): do no longer allocate a buffer for the image
                  (this is done in read_esrf_file());
                  get_buffer(): test if the shared memory segment has changed,
                  and allocate a new data buffer only if it has.
Update 25/04/2001 R. Wilcke (wilcke@esrf.fr)
                  analyse_args(): correct comments for "flat_distortion"
                  parameter;
Update 19/04/2001 R. Wilcke (wilcke@esrf.fr)
                  get_buffer(): allow shared memory segments of type "unsigned
                  short" for input image and background, copy them to an
                  allocated data buffer of type "float";
                  clean_buffer(): when detaching from a shared memory segment,
                  free the corresponding allocated buffer if it exists.
Update 14/03/2001 R. Wilcke (wilcke@esrf.fr)
                  get value for Dummy from data header, if possible.
Update 13/02/2001 R. Wilcke (wilcke@esrf.fr)
                  clean up global variables: remove C_XSIZE, C_YSIZE;
                  added global variable Dummy.
Update 02/02/2001 R. Wilcke (wilcke@esrf.fr)
                  get_buffer(): change code to return a buffer of type "float"
                  except for a "header" buffer;
                  put_buffer(): change type of output buffer to "SHM_FLOAT".

*/

#include "spd.h"

#if MY_MALLOC
/*
 * If MY_MALLOC is defined, an alternative set of routines for memory
 * management is used. The following routines are defined:
 *
 * - pmalloc(), prealloc(), pfree() replace the standard routines malloc(),
 *   realloc() and free();
 * - print_memsize() prints the total allocated memory size.
 *
 * The differences to the standard routines are:
 * - the alternative set provides error printout indicating the current file
 *   and line number where the error occurred;
 * - the alternative set operates on a linked list of data structures of type
 *   "pmem". Each structure contains the size of its data segment, a pointer to
 *   the next element in the list, and a pointer to its own data segment. This
 *   allows to keep track of the overall memory usage by the program with the
 *   routine print_memsize().
 *
 * Otherwise, the input parameters and return values of the routines in the
 * alternative set are the same as the ones in the standard set.
 *
 * If MY_MALLOC is not defined, pmalloc(), prealloc() and pfree() are defined
 * to be the standard set of memory management routines, and print_memsize()
 * is a dummy.
 */

static struct pmem *pmem_head = NULL;

void *_pmalloc(int size,char *file,int line)
{
  struct pmem *ptr;
  /*
   * Allocate the new memory segment, put the address of the last memory
   * segment in the link pointer, and save the address of the new memory
   * segment for use in the link pointer at the next call.
   */
  if((ptr = (struct pmem *) malloc (size + sizeof(struct pmem))) == NULL)
    __prmsg(FATAL,file,line,("Cannot allocate %d bytes\n",size));
  ptr->next = pmem_head;
  pmem_head = ptr;
  ptr->data = (void *)(((char *)ptr) + sizeof(struct pmem));
  ptr->size = size;

  return ptr->data;
}

void *_prealloc(void *ptr,int size,char *file,int line)
{
  struct pmem *loop_ptr,*new_ptr,**ref_ptr;

  /*
   * Loop throuth the linked list until the requested data segment is found or
   * the end of the list is reached (then loop_ptr == NULL).
   */
  for(loop_ptr = pmem_head, ref_ptr = &pmem_head; loop_ptr;
    loop_ptr = *(ref_ptr = &loop_ptr->next))
    if(ptr == loop_ptr->data)
      break;
  if(loop_ptr == NULL)
    __prmsg(FATAL,file,line,("Ptr was never allocated: 0x%x \n",ptr));

  /*
   * Reallocate the requested data segment.
   */
  if((new_ptr = (struct pmem *)
    realloc(loop_ptr,size + sizeof(struct pmem))) == NULL)
    __prmsg(FATAL,file,line,("Cannot reallocate %d bytes \n",
      size + sizeof(struct pmem)));

  *ref_ptr = new_ptr;
  new_ptr->data  = (void*)(((char*)new_ptr) + sizeof(struct pmem));
  new_ptr->size = size;

  return(new_ptr->data);
}

_pfree(void *ptr,char *file,int line)
{
  struct pmem *loop_ptr, **ref_ptr;
  /*
   * Loop throuth the linked list until the requested data segment is found or
   * the end of the list is reached (then loop_ptr == NULL).
   */

  for(loop_ptr = pmem_head, ref_ptr = &pmem_head; loop_ptr;
    loop_ptr = *(ref_ptr = &loop_ptr->next))
    if(ptr == loop_ptr->data)
      break;
  if(loop_ptr == NULL)
    __prmsg(FATAL,file,line,("Ptr was never allocated: 0x%x\n",ptr));
  /*
   * Free the requested data segment, and re-adjust the link pointer.
   */
  *ref_ptr = loop_ptr->next;
  free(loop_ptr);
}

/*
 * Print the total memory size of all allocated data segments.
 */
int print_memsize()
{
  struct pmem *loop_ptr;
  float sum = 0;

  for(loop_ptr = pmem_head; loop_ptr; loop_ptr = loop_ptr->next)
    sum += loop_ptr->size;
  prmsg(MSG,("Memory usage is now: %7.2f MB\n",sum / 1024 / 1024));
}
#else
int print_memsize()
{
}
#endif /* MY_MALLOC */

/*
 * Switch the byte order in the input array "s" containing "n" elements of type
 * short.
 *
 * Input : s: input data array, type short
 *         n: number of data items in the input data array
 * Output: s: input data array with bytes swapped
 * Return: none
 */

union swap2_data {
  unsigned char  c[2];
  unsigned short x;
};

byte_swap2N(s,n)
  register union swap2_data *s;
  int n;
{
  register int i;
  register unsigned char t;

  for(i = 0; i < n; i++, s++) {
    t = s->c[0];
    s->c[0] = s->c[1];
    s->c[1] = t;
  }
}

/*
 * Determines the minimum and the maximum of the four input values.
 *
 * Input : f1, f2, f3, f4: the four values to be searched for miminum and
 *                         maximum
 * Output: p_minf: the minimum of the four input values
 *         p_maxf: the maximum of the four input values
 * Return: 0
 */

int minmax4(float f1,float f2,float f3,float f4,float *p_minf,float *p_maxf)
{
  int i;
  float ft[3];
  float minf = f1;
  float maxf = f1;

  ft[0] = f2; ft[1] = f3; ft[2] = f4;
  for(i=0; i<3; i++) {
    if(minf > ft[i])
      minf = ft[i];
    if(maxf < ft[i])
      maxf = ft[i];
  }
  *p_minf = minf;
  *p_maxf = maxf;
  return(0);
}

/*
 * Obtains a parameter value from an input argument string.
 *
 * It searches the input argument "arg" for a string of the form
 *
 *   parameter_name=parameter_value
 *
 * where parameter_name is the string contained in the input argument "str".
 *
 * If found, it prints the parameter value according to the format given in the
 * input argument "format" and returns the value in "result".
 *
 * Input : arg:    string to be searched for the parameter name and value
 *         str:    string with the parameter name
 *         format: format for the parameter's value ("%s", "%d" or "%f")
 * Output: result: the value of the requested parameter
 * Return: 1  if the requested parameter was found
 *         0  otherwise
 */

int scan_argument(char *arg,char *str,char *format,void *result)
{
  char str_eq[256];

  /*
   * Add a "=" (equal sign) to "str" and then search for the string in "arg".
   */
  strcpy(str_eq,str);
  strcat(str_eq,"=");

  if(strncmp(arg,str_eq,strlen(str_eq)) == 0) {
    strcat(str_eq,format);
    /*
     * Read the parameter value from the string "arg" according to the format
     * given.
     */
    if(sscanf(arg,str_eq,result) == 0) {
      prmsg(ERROR,("Format: %s=xxx wrong\n",str));
      return(0);
    } else {
      /*
       * Print parameter value.
       */
      strcat(str_eq,"\n");
      if(format[0] == '%' && format[1] == 's')
	prmsg(DMSG,(str_eq,result));
      else if(format[0] == '%' && format[1] == 'f')
	prmsg(DMSG,(str_eq,*(float *)result));
      else if(format[0] == '%' && format[1] == 'd')
	prmsg(DMSG,(str_eq,*(int *)result));
    }
    return(1);
  } else
    return(0);
}

/*
 * Creates a name for an output file by taking the string "infile" with the
 * name of the input file and replacing the extension contained in "inext" by
 * the string contained in "outext".
 *
 * More precisely, the "infile" is searched for the occurrence of the substring
 * given by "inext". If found, everything in "infile" from this location onward
 * is replaced by "outext". It does not need to be separated by e.g. a dot, and
 * the substring does not even have to be at the end of "infile". As an
 * example, with "infile" containing "datafile3.dat", "inext" containing "e3"
 * and "outext" containing "_cor", the output file name is "datafil_cor".
 *
 * If "inext" is not found as a substring of "infile", then the output file name
 * is created by concatenating "infile" with "outext".
 *
 * Note that the routine returns a pointer to a static character array. It will
 * therefore be overwritten by each subsequent call, but it needs not (cannot)
 * be freed.
 *
 * Input : infile: string with the name for the input file
 *         inext:  string with the extension for the input file name
 *         outext: string with the extension for the output file name
 * Output: none
 * Return: string with the name for the output file
 */

char *outname(char *infile,char *inext,char *outext)
{
  char *pos;
  static char outfile[512];
  int inextlen = strlen(inext);

  /*
   * Search for the substring with the input file name extension.
   */
  if(pos = (char *)strstr(infile,inext)) {

    /*
     * If found, replace everything from the start of the input file name
     * extension with the output file name extension.
     */
    strncpy(outfile,infile,pos - infile);
    outfile[pos - infile] = '\0';
    strcat(outfile,outext);
    strcat(outfile,pos + inextlen);
  } else {

    /*
     * If not found, just concatenate the input file name with the output file
     * extension.
     */
    strcpy(outfile,infile);
    strcat(outfile,outext);
  }
  return(outfile);
}

/*
 * Determines the byte ordering scheme of the computer on which the program
 * runs.
 *
 * The possibilities are big endian, where the most significant byte (of a
 * 2-byte or bigger word) has the lower address, or little endian, where the
 * least significant byte has the lower address.
 *
 * Input : none
 * Output: none
 * Return: 1  if big endian byte ordering
 *         0  if little endian byte ordering
 */

isbigendian()
{
  union {
    char    buf[4];
    long    x;
  } v;

  /* ??? why does setting to 0 help for the 64 bit case? Would one then not get
     0x1234567800000000 for the big endian case ??? */
  v.x = 0; /*if 64 bit longs */
  v.buf[0] = 0x12; v.buf[1] = 0x34; v.buf[2] = 0x56; v.buf[3] = 0x78;

  if (v.x == 0x12345678)
    return 1;    /* Sun Sparc, HP700 ... */
  else if (v.x == 0x78563412)
    return 0;    /* 80x86, vax, ... */
  /* ??? if it is neither (see remark above), what is returned then ??? */
}

/*
 * Measures and prints the time difference between two consecutive calls.
 *
 * At the first call to this routine, the input argument "str" must be a NULL
 * pointer. This sets the start time.
 *
 * All subsequent calls with "str" not equal to a NULL pointer measure the time
 * between the start time and the time of the present call, print it together
 * with "str" and store the time of the present call into the start time as
 * preparation for the next call. It is thus possible to time a whole sequence
 * of events.
 *
 * To end such a sequence and start a new one, the routine can at any time be
 * called again with a NULL pointer, thus resetting the start time.
 *
 * Input : str: if NULL: resets the start time to the time of the present call
 *              else:    string to be printed with the time difference
 * Output: none
 * Return: none
 */

bench(char *str)
{
  static struct timeval start,stop;
  struct timezone tzp;

  if(str == (char *)NULL) {
    gettimeofday(&start,&tzp);
  }
  else {
    gettimeofday(&stop,&tzp);
    prmsg(MSG,("Time in %s : %10.3f\n",str,(double)(stop.tv_sec-start.tv_sec) +
      (double)(stop.tv_usec-start.tv_usec) * (double)0.000001));
    start.tv_sec = stop.tv_sec;
    start.tv_usec = stop.tv_usec;
  }
}
