import Numeric, pgplot

def plot_image(image, xlabel='x pixels', ylabel='y pixels', title='PGPLOT',device='/xw'):
	fmin=Numeric.minimum.reduce(Numeric.minimum.reduce(image))
	fmax=Numeric.maximum.reduce(Numeric.maximum.reduce(image))

	pgplot.pgopen(device)
	ier = Numeric.array((1.0,),Numeric.Int32)
	print ier.shape
	pgplot.pgscrn(0, 'White', ier)
	pgplot.pgscrn(1, 'Black', ier)
	[mxj,mxi]=Numeric.shape(image)
	GEO=[0,mxj,0,mxi]
	tr=Numeric.array((int(GEO[0]),1.0,0.0,int(GEO[2]),0.0,1.0))
	(VPX1,VPX2,VPY1,VPY2)= (Numeric.array((1.0,) ,Numeric.Float32),
		Numeric.array((1.0,) , Numeric.Float32),
                Numeric.array((1.0,) , Numeric.Float32), 
		Numeric.array((1.0,) ,Numeric.Float32)  )
	pgplot.pgsvp(0.0,1.0,0.0,1.0)
	pgplot.pgqvp(1, VPX1, VPX2, VPY1, VPY2)
	D= min(VPX2[0]-VPX1[0], VPY2[0]-VPY1[0])/80.0
	VPX1a = VPX1[0] + 5.0*D
	VPX2a = VPX2[0] - 2.0*D
	VPY1a = VPY1[0] + 20.0*D
	VPY2a = VPY2[0] - 8.0*D
	pgplot.pgvsiz(VPX1a, VPX2a, VPY1a, VPY2a)
	pgplot.pgwnad(0.0+int(GEO[0]), 1.0+mxi+int(GEO[0]), 0.0+int(GEO[2]), 1.0+mxj+int(GEO[2]))
	al=Numeric.array([0.0 , 0.0 , 1.0 , 1.0   ], Numeric.Float32)
	rl=Numeric.array([0.0 , 0.0 , 1.0 , 1.0   ], Numeric.Float32)
	gl=Numeric.array([0.0 , 0.0 , 1.0 , 1.0   ], Numeric.Float32)
	bl=Numeric.array([0.0 , 0.0 , 1.0 , 1.0   ], Numeric.Float32)
	pgplot.pgctab( al, rl, gl, bl, Numeric.shape(al)[0], 1.0, 0.5)
	pgplot.pgbox('BCINTS',100.0,10,'BCINTS',100.0,10)
	pgplot.pglab(xlabel, ylabel, title)
	pgplot.pgimag (image ,mxi,mxj ,1,mxi,1,mxj ,fmin,fmax,tr)

        tmp = """	print fmin, fmax
	tmpscale = Numeric.arange(fmin, fmax, (fmax-fmin)/100.0)
	print tmpscale.shape[0]
	scale = Numeric.zeros((5,tmpscale.shape[0]),Numeric.Float64)
	[mxj,mxi]=Numeric.shape(scale)
	for i in range(0,5):
		scale[i,:] = tmpscale 
	VPX1b = VPX1[0] + 30.0*D
	VPX2b = VPX2[0] - 30.0*D
	VPY1b = VPY1[0] - 20.0*D
	VPY2b = VPY2[0] - 40.0*D
	pgplot.pgvsiz(VPX1b, VPX2b, VPY1b, VPY2b)
	pgplot.pgwnad(fmin*1.0, 1.0+(fmax-fmin)*1.0, 0.0, 1.0+(fmax-fmin)/20.0)
	al=Numeric.array([0.0 , 0.0 , 1.0 , 1.0   ], Numeric.Float32)
	rl=Numeric.array([0.0 , 0.0 , 1.0 , 1.0   ], Numeric.Float32)
	gl=Numeric.array([0.0 , 0.0 , 1.0 , 1.0   ], Numeric.Float32)
	bl=Numeric.array([0.0 , 0.0 , 1.0 , 1.0   ], Numeric.Float32)
	pgplot.pgctab( al, rl, gl, bl, Numeric.shape(al)[0], 1.0, 0.5)
	pgplot.pgbox('BCINTS',0.0,0,'BC',0.0,0)
	pgplot.pglab('pixel values','','')
	tr1 = fmin*1.0
	tr2 = (fmax-fmin)/100.0
	tr=Numeric.array((tr1,tr2,0.0,0.0,0.0,tr2))
	pgplot.pgimag (scale ,mxi,mxj ,1,mxi,1,mxj ,fmin,fmax,tr)
        """

        


