/*+++***********************************************************************
NAME

    waxs.h

SYNOPSIS

    #include "waxs.h"

DESCRIPTION

    Header of the module "waxs.c"

***********************************************************************---*/
#ifndef _WAXS_
# define _WAXS_

/***************************************************************************
* General Definitions                                                      *
***************************************************************************/

#ifndef PRIVATE
# define PRIVATE       static /* used to declare variables of private type */
# define PUBLIC                /* used to declare variables of public type */
#endif

# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include <ctype.h>
# include <limits.h>
# include <errno.h>
# include <stdio.h>
# include <fcntl.h>
# include <math.h>
# include <float.h>

/******************************************************************************
* Public Type Defs                                                            *
******************************************************************************/

typedef struct waxs_coordinate {
  int    status;
  double s_1; // saxs coordinate 1
  double s_2; // saxs coordinate 2
  } WaxsCoord;

/*===========================================================================*/

/***************************************************************************
* Functions                                                                *
***************************************************************************/
PUBLIC extern int 
       waxs_Init ( double k, double rot_1, double rot_2, double rot_3 );

PUBLIC extern void
       waxs_PrintParams ( FILE * out ),
       waxs_PrintCoord  ( FILE * out, WaxsCoord sp );

PUBLIC extern WaxsCoord 
       waxs_Saxs ( WaxsCoord sp );

#endif
