/*+++***********************************************************************
NAME

    poisson.h

SYNOPSIS

    #include "poisson.h"

DESCRIPTION
    Header of the module "poisson.c"
***********************************************************************---*/
#ifndef _POISSON_
# define _POISSON_

/***************************************************************************
* General Definitions                                                      *
***************************************************************************/

#ifndef PRIVATE
# define PRIVATE       static /* used to declare variables of private type */
# define PUBLIC                /* used to declare variables of public type */
#endif

# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include <ctype.h>
# include <limits.h>
# include <errno.h>
# include <stdio.h>
# include <fcntl.h>
# include <math.h>
# include <float.h>

/***************************************************************************
* Functions                                                                *
***************************************************************************/

PUBLIC extern double

       Poisson( long k, double ny ),           // poisson distribution
       SumPoisson( long k, double ny ),        // Sum(0,k,Poisson(k,ny))
       RandomNoise( void );          // random noise between 0.0 and 1.0

PUBLIC extern long
       InvSumPoisson ( double y, double ny ),  // inverted SumPoisson
       PoissonNoise( double ny );       // poissonian noise with mean ny


PUBLIC extern void 
       PoissonNoiseSeed( unsigned int seed );  // set random number seed

#endif
