/*****************************************************************************
 dirent.h

 Emulate UNIX directory routines to allow test of routines under Turbo C V1.0

 DIR
 typedef struct dirent { char d_name[dirent_buflen]; } dirent;
 DIR *           opendir  ( char * path );
 struct dirent * readdir  ( DIR * dirp );
 void            closedir ( DIR * dirp );

 HISTORY
 22-Dec-1995 Peter Boesecke
*****************************************************************************/
# include <stdio.h>
# include <dirent.h>

/*----------------------------------------------------------------------------
  opendir
  Create a new directory pointer for the directory specified in path.
  The return value is NULL, in the case of an error.
  Only syntactical check of the path name, no actual read.
----------------------------------------------------------------------------*/
DIR * opendir ( char * path )
{ DIR * dirp;

  if (!(dirp = (DIR *) malloc (sizeof(DIR)) ) ) {
     printf("Cannot alloc memory for DIR\n"); exit(-1); }

  /* copy directory name and convert to upper case */
  strncpy(dirp->dir_name,path,dirent_buflen);
  if ( (dirp->dir_name[strlen(dirp->dir_name)-1]!='\\') &&
       (dirp->dir_name[strlen(dirp->dir_name)-1]!=':') )
     strcat(dirp->dir_name,"\\");
  strcat(dirp->dir_name,"*.*");
  (void) strupr(dirp->dir_name);
  dirp->new = 1;

  return(dirp); }

/*----------------------------------------------------------------------------
  readdir
  Read file names one after each other from directory dirp.
  Returns NULL if all file names have been read.
----------------------------------------------------------------------------*/
struct dirent * readdir( DIR * dirp )
{ int done;
  struct ffblk datinf;

  if (dirp->new) done = findfirst(dirp->dir_name,&datinf,0);
    else done = findnext(&datinf);
  dirp->new = 0;
  if (done) return( (struct dirent *) NULL);

  /* copy file name and convert to upper case */
  (void) strncpy(dirp->dir_entry.d_name,datinf.ff_name,dirent_buflen);
  (void) strupr(dirp->dir_entry.d_name);

  return(&dirp->dir_entry); }

/*----------------------------------------------------------------------------
  closedir
  Release directory pointer dirp.
----------------------------------------------------------------------------*/
void closedir ( DIR * dirp )
{ free(dirp); }

/****************************************************************************/
