/* @(#) $Source: SaxsImage.h V1.91 by Peter Boesecke 2001-09-16         $  */
/****************************************************************************
* SaxsImage.h                                                               *
****************************************************************************/

#ifndef SAXS_IMAGE
# define SAXS_IMAGE

# include "SaxsOption.h"
# include "SaxsDefinition.h"

# define DefaultExtension  ".edf"
# define DefaultInput      "input"DefaultExtension
# define DefaultOutput     "output"DefaultExtension

typedef struct ImageHeaderBlock {
	/* control variables */
	int		I;		/* flag: TRUE = valid header */
	long int	ImNum;		/* (i) image number */
        int		Stream;         /* (i) stream */
	long int	StreamOpenMode;	/* (i) file open mode */
                                        /* DataCtrl and ActualLoopCount are
                                           used inside SaxsImageLoop and count
                                           the number of calculation cycles.
                                           They start with 0 and are 
                                           incremented AFTER at the end of 
                                           SaxsImageLoop */
        long int        DataCtrl;       /* (i/o) nominal number of loops after
                                           allocation of memory, incremented */
        long int        ActualLoopCount;/* (i/o) actual number of loops after
                                           allocation of memory, incremented */
        int             Write;          /* if 0, do not write at end of loop */
        size_t      	ImgByteLen;     /* (o) total length of read/wr data */
	long int	Dim[4];		/* (i/o) image array dimensions */
	float         * Data;		/* (i/o) pointer to data array
					   Data[Dim[1],Dim[2]] */
        int             DoNotScale;     /* (i/o) do not use this header to
                                           calculate image overlap 
                                           (default: FALSE) */
        IO_line         Header;         /* key under which the full header 
                                           is available when I-flag is TRUE */

        /* standard SAXS keyword values */
	IO_float	Dummy;		/* dummy value */
 	IO_float	DDummy;		/* dummy difference */
 	IO_float	Offset[3];	/* image offset in pixels */
	IO_float	Center[3];	/* image center in pixels */
	/* optional SAXS keyword values */
	IO_float	PixSiz[3];	/* pixel size in meters */
	IO_float	SampleDistance; /* sample distance in meters */
	IO_float	WaveLength;	/* wavelength in meters */
        IO_line         Title;          /* title */
        IO_line         Time;           /* time of first creation, 
                                           e.g. start of exposure */
        IO_long         Orientation;    /* Orientation of the image. Images
                                           with orientations different from 1
                                           are automatically converted to 1 */
	} ImgHeadBlk;

/***************************************************************************
* Routines                                                                 *
***************************************************************************/

   extern char
        *SaxsImageVersion       ( void );
   extern void
	OpenImageFile		( CmdBlk *pcb, ImgBlk ib[], int blkno,
                                  const char *fname, long int FileNumber,
                                  long int OpenMode, int *pstatus),
        NewImage                ( CmdBlk *pcb, ImgBlk ib[], int blkno,
                                  long int ImageNumber, ImgHeadBlk ihb[],
                                  ImgHeadBlk * template, int *pstatus),
        NewImageHeader          ( CmdBlk *pcb, ImgBlk ib[], int blkno,
                                  long int ImageNumber, ImgHeadBlk ihb[],
                                  ImgHeadBlk * template, int *pstatus), 
        WriteHeaderLine         ( CmdBlk *pcb, int blkno, ImgHeadBlk ihb[],
                                  char * keyword, char * Value, int * pstatus ),
        WriteHeaderFloat        ( CmdBlk *pcb, int blkno, ImgHeadBlk ihb[],
                                  char * keyword, float Value, int * pstatus ),
        WriteHeaderLong         ( CmdBlk *pcb, int blkno, ImgHeadBlk ihb[],
                                  char * keyword, long int Value, 
                                  int * pstatus ),
        WriteImage              ( CmdBlk *pcb, ImgBlk ib[], int blkno,
                                  ImgHeadBlk ihb[], int *pstatus),
        FreeImage               ( CmdBlk *pcb, int blkno, ImgHeadBlk ihb[] ),
        CloseImageFile          ( CmdBlk *pcb, ImgBlk ib[], int blkno,
                                  int * pstatus),
        GeoHeaderCopy           ( ImgHeadBlk ihb[], int blkin, int blkout ),
        DoNotScaleWith          ( ImgHeadBlk ihb[], int blk ),
	PrintImageHeaderBlock 	( int i, ImgHeadBlk * pihb ),
	ImageLoop	( CmdBlk * pcb, ImgBlk ib[],
                	  void (*Function) (CmdBlk *, ImgHeadBlk [], int * ),
                	  int allneeded, int * pstatus ) ;
   extern int
	ReadImage 		( CmdBlk *pcb, ImgBlk ib[], int blkno,
				  long int ImageNumber, ImgHeadBlk ihb[],
				  int *pstatus),
        ReadImageHeader         ( CmdBlk *pcb, ImgBlk ib[], int blkno,
				  long int ImageNumber, ImgHeadBlk ihb[],
				  int *pstatus),
	SearchMinMaxImage 	( CmdBlk *pcb, ImgBlk ib[], int blkno,
                                  long int * pMinImage, long int *pMaxImage,
                                  int *pstatus),
        ReadImageDimension      ( CmdBlk *pcb, ImgBlk ib[], int blkno,
                                  long int ImageNumber,
                                  long int * pDim_1, long int *pDim_2,
                                  int *pstatus),
        ReadHeaderLine		( CmdBlk *pcb, int blkno,
                                  ImgHeadBlk ihb[], char * keyword,
				  char * Value, int * pstatus ),
        ReadHeaderFloat		( CmdBlk *pcb, int blkno,
                                  ImgHeadBlk ihb[], char * keyword,
                                  float * Value, int * pstatus ),
        ReadHeaderLong		( CmdBlk *pcb, int blkno,
                                  ImgHeadBlk ihb[], char * keyword,
                                  long int * Value, int * pstatus ),
        ImageIsNew              ( int blkno, ImgHeadBlk ihb[] ),
        ImageToWrite            ( int blkno, ImgHeadBlk ihb[] ),
        ImageIsFirst            ( CmdBlk * pcb, int blkno, ImgHeadBlk ihb[] ),
        ImageIsLast             ( CmdBlk * pcb, int blkno, ImgHeadBlk ihb[] ); 
   extern char *
        ReportSaxsImageError    ( int ExternalError );

#endif /* SAXS_IMAGE */

/****************************************************************************
*                                                                           *
****************************************************************************/
