/* SaxsError.h V1.42 by P. BOESECKE 2001-07-06                            */
/**************************************************************************/
/* SaxsError.h                                                            */
/**************************************************************************/

#ifndef _SAXS_ERROR
# define _SAXS_ERROR

  typedef struct SaxsErrorBlock {
    char * ModuleName;  /* pointer to module name */
    char * RoutineName; /* pointer to routine name */
    char * Message;	/* pointer to an info string */
    int  * pstatus;     /* pointer to status variable */
    int  ExternalError;	/* number of external error */
    char * (*ReportError) (int ExternalError );
                        /* pointer to external error report function */
   } SaxsErrBlk;

# if defined(__alpha) || defined(__TURBOC__) || defined(__STDC__)
#  define FULLDECLARATION
# endif

# ifdef FULLDECLARATION
   extern char
    * SaxsErrorVersion( void );
   extern void
    InitSaxsError( SaxsErrBlk *pseb, int * pstatus ),
    SetSaxsError( SaxsErrBlk *pseb, const char * ModuleName,
                  const char * RoutineName, const char * Message,
                  int status, int ExternalError,
                  char *  (*ReportError) (int ) ),
    ReportSaxsError( SaxsErrBlk *pseb , int ExitFlag),
    PrintSaxsError ( SaxsErrBlk *pseb ),
    ReportSaxsStatus(int Status, SaxsErrBlk *pseb , int ExitFlag),
    ReportInputStatus(int Status, int ExitFlag);
# else
   extern char
    *SaxsErrorVersion();
   extern void
    InitSaxsError(),
    SetSaxsError(),
    ReportSaxsError(),
    PrintSaxsError(),
    ReportSaxsStatus(),
    ReportInputStatus();
# endif

enum Status { Failed  = -1,  Success = 0, Abort = 1,    SkipInput,
              ScanError   ,  NoDefault  , NoOption ,    NoFloatNumber,
              NoIntegerNumber,            BadParenthesis,
              DivByZero,     NoFlag,      CommaExpected,
              FloatingPointError,         DomainError,  IntegerOverflow,
              UnknownFloatFunction,       UnknownIntegerFunction,
              WrongImageNumber,           NotEnoughBlocks,
              NotEnoughMemoryAvailable,   FileNotFound, ImageProtected,
              FileProtected, FileOpeningError,          FileAlreadyOpened,
              FileMustBeOpened, HeaderNotInitialized,
              FilePositioningError,       FileReadError,
              FileClosingError,           KeywordMissing,
              UnknownDataType, UnknownUnit, SizeMismatch, FileWriteError,
              OutOfRange, ExternalErrorReport = 100 };

#endif /* _SAXS_ERROR */

/**************************************************************************/
/*                                                                        */
/**************************************************************************/

