import Command
from PyDisWindow import Plugin, ViewWindow
from PyDVT.Binding import Pen,Brush
import PyDVT.ImageView as ImageView
import PyDVT.ExtendedImageView as ExtendedImageView
from Py4datDisplay import ViewSelectHRect,Py4datImageViewRoi
import Py4datImageStack
import EdfFileData
import MccdFileData
import DataSelection
import ParametersDialog

__version__=  '1.0.0'
__author__ =  'Anne-Cecile Gendrin'

DEBUG=0

class Py4datRoisPlugin(Plugin):
	'''
	Py4datRoisPlugin allows to select Rois on Images.
		
    	Methods:
    	===========================
		_SetRoi
		_DelAllRois
		EventRoiSelection
		ClickOnRoiCB
		EventButtonPressMotion
		EventButtonRelease
		InsideRoi
		PutRoi
		DelRoi
		ShowRoisNames
		ShowRoiName
		HideRoisNames
		HideRoiName
		SetActiveRoi
		GetActiveRoi
		GetRois
		SetModeStateRoi
		EnableModeRoi
		DisableModeRoi
		_DestroySelect
	'''
  	########################################################
    	### Virtuals
    	########################################################
	def OnStartInit (self):
		if DEBUG: print 'In Py4datRoisPlugin.OnStartInit...'
		return 1

    	def OnFinishInit (self,app_window):
        	if DEBUG: print 'In Py4datRoisPlugin.OnFinishInit...'
		self.app_window=app_window

    	def OnInitWindowPopupMenu (self,window):
    		if DEBUG: print 'In Py4datRoisPlugin.OnInitWindowPopupMenu...'
    		if hasattr(window,'shortName') and window.shortName=='Mosaic': return
		if isinstance(window.View,ImageView.ImageView) == 1:
			window.rois={}
			window.ROIx0=0
			window.ROIx1=0
			window.ROIy0=0
			window.ROIy1=0
			window.activeRoi=None
			window.activeRoiHighlight=[]
			window.roiLimit_dnd=0 	# roi limit drag 'n' drop management mode
			window.View.AddMenuSeparator()
			window.View.GraphicalRoiMenuItem=window.View.AddMenuPopupItem('Graphical Roi',Command.Command(self._SetRoi,window))
			window.View.ManualRoiMenuItem=window.View.AddMenuPopupItem('Manual Roi',Command.Command(self._SetManualRoi,window))
			window.View.AddMenuPopupItem('Del Roi',Command.Command(self._DelAllRois,window))
			
	def GetInfoString(self):
		return "v. "+__version__+",  Author:"+__author__
	
    	########################################################
    	### Private methods
    	########################################################

	################## SELECT ROI ###############################################

	def _SetRoi(self,window):
		if DEBUG==1: print 'In _SetRoi...'
		newstate=not window.View.MenuPopup.IsItemChecked(window.View.GraphicalRoiMenuItem)
		self.SetModeStateRoi(newstate,window)
		window.View.MenuPopup.CheckItem(window.View.GraphicalRoiMenuItem,newstate)
	
	def _SetManualRoi(self,window):
		if DEBUG: print 'In _SetManualRoi...'
		dial=ParametersDialog.ParametersDialog(None, {'ROIx[0]':window.ROIx0,'ROIx[1]':window.ROIx1,'ROIy[0]':window.ROIy0,'ROIy[1]':window.ROIy1},labelSize=60,sizeX=180,sizeY=140)
		if dial.dlg.result()==0: return
		window.ROIx0=int(dial.params['ROIx[0]'])
		window.ROIx1=int(dial.params['ROIx[1]'])
		window.ROIy0=int(dial.params['ROIy[0]'])
		window.ROIy1=int(dial.params['ROIy[1]'])
		self._DelAllRois(window)			# TO SELECT ONLY ONE ROI
		self.PutRoi(name='roi',Limitsx=[(window.ROIx0,window.ROIx1)],Limitsy=[(window.ROIy0,window.ROIy1)],pen=Pen((100,100,100),2,"solid"),brush=Brush((100,100,100),"fill_25"))
		
	def _DelAllRois(self,window):
		for roi in self.GetRois(window): 
			self.DelRoi(roi.name)
		

	############################################
	###   SELECTION ON THE IMAGE CALLBACKS   ###
	############################################
	
	def EventRoiSelection(self,source):
		"""
		Virtual : Callback of a new roi selection : to be overidden for specific behavior
		"""
		window=self.app_window.mdi.activeWindow()
		self._DelAllRois(window)			# TO SELECT ONLY ONE ROI
		if DEBUG : print "EventRoiSelection"
		((xmin,y0),(xmax,y1))=window.View.Select.Selection["BoundingRect"][0].PageCoord,window.View.Select.Selection["BoundingRect"][1].PageCoord
		self.PutRoi(name='roi',Limitsx=[(xmin,xmax)],Limitsy=[(y0,y1)],pen=Pen((100,100,100),2,"solid"),brush=Brush((100,100,100),"fill_25"))
		nbRois=len(self.GetRois(window))
		if DEBUG:
			i=0
			while i<nbRois:
				print self.GetRois(window)[i].name
				print self.GetRois(window)[i].Limitsx[0]
				i=i+1

	##########################################
	###  IMAGE ITEMS SELECTION CALLBACKS   ###
	##########################################
		
	def ClickOnRoiCB(self,roiName=None):
		"""
		Callback of a click in a roi event : to be overidden for specific behavior
		"""
		if DEBUG : print " ClickOnRoiCB ",roiName
		# if more than one roi, make it being the active one
		self.SetActiveRoi(roiName)

	##################################
	###   MOUSE EVENTS CALLBACKS   ###
	##################################
	
	
	def EventButtonPressMotion(self,pos):
		#if self.opts['RoiSelection']: 
		# roi Limitsx drag 'n' drop
		window=self.app_window.mdi.activeWindow()
		if window.roiLimit_dnd:
			i=0
			while i<len(window.draggedRoiLimit):
				roi,limit=window.draggedRoiLimit[i]
				roi.MoveLimit(limit,pos.DataCoord[0])
				if roi==self.GetActiveRoi():
					# update active roi highlight box
					for obj in window.activeRoiHighlight:
						xmin,ymin,xmax,ymax=window.View.Drawable.GetObjectCoords(obj)
						ymin,ymax=0,view.Source[0].GetData().Pages[0].Array.shape[1]
						if xmin==limit:
							xmin=pos.DataCoord[0]
							window.View.Drawable.SetObjectCoords(obj,xmin,ymin,xmax,ymax)
						elif xmax==limit:
							xmax=pos.DataCoord[0]
							window.View.Drawable.SetObjectCoords(obj,xmin,ymin,xmax,ymax)
				window.draggedRoiLimit[i]=(roi,pos.DataCoord[0])
				i+=1
	
	def EventButtonRelease(self,pos):
		#if self.opts['RoiSelection']: 
		# disable roi Limitsx drag 'n' drop if set
		window=self.app_window.mdi.activeWindow()
		if window.roiLimit_dnd:
			window.roiLimit_dnd=0
			window.draggedRoiLimit=overlappedRoiLimit
	

	################################
	###      ROI MANAGEMENT      ###
	################################
	
	def InsideRoi(self,pos):
		"""
		return the sequence of rois containing the image position 'pos'. If None, return an empty sequence
		"""
		window=self.app_window.mdi.activeWindow()
		ret=[]
		for roi in window.rois.keys():
			# in each roi 
			for min,max in window.rois[roi].Limitsx:
				# in each roi limit
					if pos[0]>=min and pos[0]<=max:
						ret.append(window.rois[roi])
		return ret

	
	
	def PutRoi(self,name='roi',Limitsx=[],Limitsy=[],pen=Pen((0,0,0),2,"solid"),brush=Brush((0,0,0),"fill_25")):
		"""
		Put a roi on the image with the specified parametres :
			-	name : the name given to this roi. If an already existant roi have the same name, it will be renamed with an non existing name using the style existing-name'_x'
				 		   where x is a integer.
			-	Limitsx : the image Limitsx defining this roi : it's a sequence of min,max tuples
			-	Limitsy : the image Limitsy defining this roi : it's a sequence of min,max tuples
			-	pen : the pen style used for drawing the roi border
			-	brush : the brush style used for filling the roi
		Once the roi has been added, it is set as the active one		   
		"""	
		window=self.app_window.mdi.activeWindow()
		if DEBUG: print 'In PutRoi...'
		if window.rois.has_key(name):
			# if a roi with a name of label exists : renamed the one to add
			i=0
			while window.rois.has_key(name+'_'+str(i)):
				i+=1
			name+='_'+str(i)
		
		# hide all other roi names
		for roi in window.rois.keys():
			window.rois[roi].HideName()
		 
		# add the new roi parametres to the list
		#print 'ROI name=',name,'ROI Limitsx=',Limitsx
		window.rois[name]=Py4datImageViewRoi(window.View,name,Limitsx,Limitsy,pen,brush)
		window.ROIx0, window.ROIx1 = window.rois[window.rois.keys()[0]].Limitsx[0]
		window.ROIy0, window.ROIy1 = window.rois[window.rois.keys()[0]].Limitsy[0]
		
		# make the new roi become the active one
		self.SetActiveRoi(name)
			
	def DelRoi(self,name=''):
		"""
		Delete the roi with the given name
		"""
		window=self.app_window.mdi.activeWindow()
		if window.rois.has_key(name):
			# erases roi rectangles
			for obj in window.rois[name].drawnRect:
				window.View.Drawable.EraseObject(obj)
			# erases roi labels
			for obj in window.rois[name].drawnLab:
				window.View.Drawable.EraseObject(obj)
			# delete it in the rois list
			del window.rois[name]
			
			if self.GetActiveRoi().name == name:
				# if roi to delete is the active one : erases active roi border rectangles
				for obj in window.activeRoiHighlight:
					window.View.Drawable.EraseObject(obj)
					window.activeRoiHighlight.remove(obj)
			
	def ShowRoisNames(self):
		"""
		show all rois labels
		"""
		window=self.app_window.mdi.activeWindow()
		for roi in window.rois.keys():
			window.rois[roi].ShowName()
			
	def ShowRoiName(self,name=''):
		"""
		show the label of the roi called 'name' 
		"""
		window=self.app_window.mdi.activeWindow()
		if window.rois.has_key(name):
			window.rois[name].ShowName()
		
	def HideRoisNames(self):
		"""
		hide all rois labels
		"""
		window=self.app_window.mdi.activeWindow()
		for roi in window.rois.keys():
			window.rois[roi].HideName()
			
	def HideRoiName(self,name=''):
		"""
		hide the label of the roi called 'name' 
		"""
		window=self.app_window.mdi.activeWindow()
		if window.rois.has_key(name):
			window.rois[name].HideName()
		
	def SetActiveRoi(self,name=''):
		"""
		if existant, set the roi with a name of 'name' as the active one. Draws a red rectangle around it, and remove it on the old active one
		"""		
		window=self.app_window.mdi.activeWindow()
		if window.rois.has_key(name):
			window.activeRoi=window.rois[name]

			# if more than one roi : draw a red rectangle around the roi to view which one is the active one
			if len(window.rois)>1: 
				# erases old active roi border rectangles
				for obj in window.activeRoiHighlight:
					window.View.Drawable.EraseObject(obj)
					window.activeRoiHighlight.remove(obj)
				# create it on new active one
				ymin,ymax=0,window.View.Source[0].GetData().Pages[0].Array.shape[1]
				#for xmin,xmax in window.activeRoi.Limitsx and ymin, ymax in window.activeRoi.Limitsy :
				i=0
				while i < len(window.activeRoi.Limitsx):
					xmin,xmax=window.activeRoi.Limitsx[i]
					ymin,ymax=window.activeRoi.Limitsy[i]
					# create the highlight rectangle
					window.activeRoiHighlight.append(window.View.Drawable.PutRectangle(xmin,ymin,xmax,ymax,pen=Pen((255,0,0),2,"solid")))
					i=i+1

				# erases others roi lablels
				self.HideRoisNames()
			# show the label of the active roi
			self.ShowRoiName(name)
			
	def GetActiveRoi(self):
		"""
		return the active roi
		"""
		window=self.app_window.mdi.activeWindow()
		return window.activeRoi
		
	def GetRois(self,window):
		"""
		return a sequence containing all the displayed roi
		"""
		if window==None: 
			return []
		else:
			ret=[]
			for roi in window.rois.keys():
				ret.append(window.rois[roi])
			return ret
		
	# Roi mode
	def SetModeStateRoi(self,state,window):
		if state==0:
			self.DisableModeRoi()
		else:
			self.EnableModeRoi(window)
	
	def EnableModeRoi(self,window):
		# disable other selections
		if DEBUG: print 'In EnableModeRoi...'
		window=self.app_window.mdi.activeWindow()
		if window.View.ZoomSelect is not None:
			window.View.DisableModeZoom()

		if window.View.Select is None:
			window.View.MenuPopup.CheckItem(window.View.GraphicalRoiMenuItem,1)
		
			window.activeMode='Roi'
			
			if (window.View.Source != ()):
				self._DestroySelect()
				data=window.View.Source[0].GetData()
				if data==None: return
				window.View.Select=ViewSelectHRect(data,self.EventRoiSelection)
				window.View.Select.ConnectView(window.View)
		
	def DisableModeRoi(self):
		window=self.app_window.mdi.activeWindow()
		if window.View.Select is not None:
			#self.MenuPopup.UnselectItem(3)
			window.View.MenuPopup.CheckItem(window.View.GraphicalRoiMenuItem,0)
			
			window.View.activeMode=None
			self._DestroySelect()
			
	def _DestroySelect(self):
		window=self.app_window.mdi.activeWindow()
		if window.View.Select is not None:
			window.View.Select.Erase(window.View)
			window.View.Select.Destroy()
			window.View.Select=None
    		
plugin=Py4datRoisPlugin()
