import Command, sys, qt,types
sys.path.insert(0,'.')
sys.path.insert(0,'./maths')

from PyDisWindow import Plugin,ViewWindow
import PyDVT.DataSelection as DataSelection
import PyDVT.ImageView as ImageView
import PyDVT.ExtendedImageView as ExtendedImageView
from PyDVT.Binding import Pen,Brush
from ConstantParameterDialog import ConstantParameterDialog
from ErrorWindow import ErrorWindow
from Py4datDisplay import ViewSelectHRect,Py4datImageViewRoi

##### Transformation Filters #####
from AddConstantFilter import AddConstantFilter
from MultiplyByConstantFilter import MultiplyByConstantFilter
from SubstractBackgroundFilter import SubstractBackgroundFilter
from LeftRightFlipFilter import LeftRightFlipFilter
from TopBottomFlipFilter import TopBottomFlipFilter
from TransposeFilter import TransposeFilter
from CropFilter import CropFilter



__version__=  '1.0.0'
__author__ =  'Anne-Cecile Gendrin'
__date__= '05/12/2002'

DEBUG=0

class Py4datMathsPlugin(Plugin):
    	########################################################
    	### Virtuals
    	########################################################
    	def OnStartInit (self):
		return 1

     	def OnInitMenuBar (self,menu_bar):
        	if DEBUG: print 'In Py4datMathsPlugin.OnInitMenuBar...'
		menuFile=menu_bar.children()[0]
        	menuFile.insertItem('Open Background',self.OpenBackground,0,-1,5)
		self.menu_plugin = qt.QPopupMenu(menu_bar)
		self.menu_plugin.insertItem('Flip Left/Right',self.LeftRightFlip)
		self.menu_plugin.insertItem('Flip Top/Bottom',self.TopBottomFlip)
		self.menu_plugin.insertItem('Transpose',self.Transpose)
		#self.menu_plugin.insertItem('Crop to ROI',self.Crop)
		self.menu_plugin.insertSeparator()
        	self.menu_plugin.insertItem('Add Constant',self.AddConstant)
		self.menu_plugin.insertItem('Multiply by Constant',self.MultiplyByConstant)
		self.menu_plugin.insertSeparator()
		self.menu_plugin.insertItem('Substract Constant * Background',self.SubstractBackground)
		menu_bar.insertItem('&Transformation',self.menu_plugin)
		
    	def OnFinishInit (self,app_window):
        	if DEBUG: print 'In Py4datMathsPlugin.OnFinishInit...'
		self.app_window=app_window
		self.app_window.Constant=1

    	def OnInitWindowPopupMenu (self,window):
    		if DEBUG: print 'In Py4datMathsPlugin.OnInitWindowPopupMenu...'
		window.Transformation=[]

	def GetInfoString(self):
		return "v. "+__version__+",  Author:"+__author__

    	########################################################
    	### Private methods
    	########################################################	

	def OpenBackground(self):
		if DEBUG: print 'In Py4datMathsPlugin.OpenBackground...'
        	self.app_window.onOpen()
		activeWindow=self.app_window.mdi.activeWindow()
		if activeWindow==None:return
		activeWindow.setCaption('Background Image -' + activeWindow.name)
		if activeWindow==None: return
		self.app_window.BackgroundOutput=activeWindow.View.GetSource()[0].GetOutput()

	def ConstantChoice(self):
		self.dial=ConstantParameterDialog(None,{'Constant':self.app_window.Constant})	
		self.app_window.Constant=self.dial.Constant
	
	def SelectRoi(self):
		if DEBUG: print 'In Py4datMathsPlugin.SelectRoi...'
		window=self.app_window.mdi.activeWindow()
		window.rois={}
		data=window.View.Source[0].GetData()
		#window.View.CreateViewSelect(ImageViewSelect.ImageViewSelectRect, callback=window.View.EventSelection)
		window.View.Select=ViewSelectHRect(data,self.EventRoiSelection)
		window.View.Select.ConnectView(window.View)
	
	def EventRoiSelection(self):
		if DEBUG: print 'In Py4datMathsPlugin.EventRoiSelection...'
		window=self.app_window.mdi.activeWindow()
		((x0,y0),(x1,y1))=window.View.Select.Selection["BoundingRect"][0].PageCoord,window.View.Select.Selection["BoundingRect"][1].PageCoord
		self.PutRoi(name='roi',Limitsx=[(x0,x0)],Limitsy=[(y0,y1)],pen=Pen((100,100,100),2,"solid"),brush=Brush((100,100,100),"fill_25"))

	def PutRoi(self,name='roi',Limitsx=[],Limitsy=[],pen=Pen((0,0,0),2,"solid"),brush=Brush((0,0,0),"fill_25")):
		if DEBUG: print 'In Py4datMathsPlugin.PutRoi...'
		window=self.app_window.mdi.activeWindow()
		if DEBUG: print 'In PutRoi...'
		if window.rois.has_key(name):
			# if a roi with a name of label exists : renamed the one to add
			i=0
			while window.rois.has_key(name+'_'+str(i)):
				i+=1
			name+='_'+str(i)
		window.rois[name]=Py4datImageViewRoi(window.View,name,Limitsx,Limitsy,pen,brush)
	
	def Transform(self,param):
		if DEBUG: print 'In Py4datMathsPlugin.Transform...'
		if param=='BKG' and hasattr(self.app_window,'BackgroundOutput')==0: 
			dial=ErrorWindow(None,message=' You must open 1 background image !',sizex=237,sizey=60)
			return
		window=self.app_window.mdi.activeWindow()
		if param=='BKG' and self.app_window.BackgroundOutput['data'].shape != window.View.Source[0].GetOutput()['data'].shape:
			dial=ErrorWindow(None,message=' The 2 images must have the same shape !',sizex=237,sizey=60)
			return
		if window is None: return
		
		if param=='BKG' or param=='ADD' or param=='MULTIPLY':
			self.ConstantChoice()
			if self.dial.dlg.result()==0: return
		if param=='CROP':
			print 'DEBUG', window, window.View, dir(window), dir(window.View)
			self.SelectRoi()
		
		transformedWindow=self.app_window.GetWindow('Transformed - '+ window.name)
		if transformedWindow is None:
			transformedWindow=ViewWindow (self.app_window.mdi,ExtendedImageView.ExtendedImageView,name='Transformed - '+ window.name,view_pars={"UseImageValues":1},master_window=window)
			self.app_window.Set2DViewMenu(transformedWindow)
			transformedWindow.DataSelection=window.View.Source[0]
			window.Transformation=[]
		else : transformedWindow.DataSelection=transformedWindow.View.Source[0]
		if hasattr(window,'prefix'): prefix='Transformed - '+window.prefix
		else: prefix='Transformed - '
		transformedWindow.SetTitle(window.OriginalCaption,prefix=prefix)
		
		if param=='ADD': transformedWindow.Filter=ImageView.ColormapFilter(None,AddConstantFilter(transformedWindow.DataSelection,buffer_input=1, Constant=self.app_window.Constant))
    		elif param=='MULTIPLY': transformedWindow.Filter=ImageView.ColormapFilter(None,MultiplyByConstantFilter(transformedWindow.DataSelection,buffer_input=1, Constant=self.app_window.Constant))
		elif param=='BKG': transformedWindow.Filter=ImageView.ColormapFilter(None,SubstractBackgroundFilter(transformedWindow.DataSelection,buffer_input=1, Constant=self.app_window.Constant,BackgroundOutput=self.app_window.BackgroundOutput))
		elif param=='LRFLIP': transformedWindow.Filter=ImageView.ColormapFilter(None,LeftRightFlipFilter(transformedWindow.DataSelection,buffer_input=1))
		elif param=='TBFLIP': transformedWindow.Filter=ImageView.ColormapFilter(None,TopBottomFlipFilter(transformedWindow.DataSelection,buffer_input=1))
		elif param=='TRANS': transformedWindow.Filter=ImageView.ColormapFilter(None,TransposeFilter(transformedWindow.DataSelection,buffer_input=1))
		elif param=='CROP': transformedWindow.Filter=ImageView.ColormapFilter(None,CropFilter(transformedWindow.DataSelection,buffer_input=1, ROI=window.rois['roi']))
		transformedWindow.Filter.SetColormapParameters(window.Filter.GetColormapParameters())
		transformedWindow.View.SetSource(transformedWindow.Filter)
		
		if param=='ADD' or param=='MULTIPLY': Transformation=[param,self.app_window.Constant]
		elif param=='BKG': Transformation=[param,self.app_window.Constant,self.app_window.BackgroundOutput]
		elif param=='LRFLIP' or param=='TBFLIP' or param=='TRANS': Transformation=[param]
		window.Transformation.append(Transformation)
		
		
	def AddConstant(self):
		param='ADD'
		self.Transform(param)
		
	def MultiplyByConstant(self):
		param='MULTIPLY'
		self.Transform(param)
		
	def SubstractBackground(self):
		param='BKG'
		self.Transform(param)	
		
	def LeftRightFlip(self):
		param='LRFLIP'
		self.Transform(param)
		
	def TopBottomFlip(self):
		param='TBFLIP'
		self.Transform(param)
	
	def Transpose(self):
		param='TRANS'
		self.Transform(param)
		
	def Crop(self):
		param='CROP'
		self.Transform(param)


	################## GET SOURCE WINDOW ################################################

	def GetSourceWindow(self,window=None):
		if window==None: window=self.app_window.mdi.activeWindow()
		if hasattr(window,'master_window'):
			while window.master_window!=None:
				window=window.master_window

plugin=Py4datMathsPlugin()
